//This file contains the actual structure of the machine itself, along with the movement of the paddles.

#declare MAJ = .055         //Major radius of the tori making up the tubes
#declare MIN = .004         //Minor radius of the tori making up the tubes
#declare BACKBAR = .15      //How far back the "connection bars" should extend

#declare PARTTORUS = union  //A single torus for the balls to pass through, minus 1/5 for the paddle to 
                            //pass through
{difference
 {torus {MAJ, MIN+.001}
  intersection
  {box {<0,-.1,0>,<-.1,.1,.1> rotate y*-36}
   box {<0,-.1,0>,<-.1,.1,.1> rotate y*-54}
  }
 }
 #declare POINT = <-MAJ,0,0>
 #declare POINT = vrotate(POINT,y*36)
 translate x*.175
}
#declare FIVETORI = union
{object {PARTTORUS rotate z*0}
 object {PARTTORUS rotate z*-45}
 object {PARTTORUS rotate z*-90}
 object {PARTTORUS rotate z*-135}
 object {PARTTORUS rotate z*-180}

 //These spheres fill in the tips of the two edge tori, so they're not "sharp"
 sphere {<-MAJ,0,0>, MIN+.001 rotate y*-36 translate x*.175}
 sphere {<-MAJ,0,0>, MIN+.001 rotate y*36 translate x*.175}
 sphere {<-MAJ,0,0>, MIN+.001 rotate y*-36 translate x*.175 rotate z*180}
 sphere {<-MAJ,0,0>, MIN+.001 rotate y*36 translate x*.175 rotate z*180}

}

#declare BIGTORI = union
{torus
 {.175+MAJ, MIN
  rotate x*90
 }
 #declare BOTTOM = <0,-MAJ,0>
 #declare TOR2 = vrotate(BOTTOM,x*72)
 torus
 {.175+MAJ - (MAJ+vdot(TOR2,y)), MIN
  rotate x*90
  translate z * vdot(TOR2,z)
 }
 torus
 {.175+MAJ - (MAJ+vdot(TOR2,y)), MIN
  rotate x*90
  translate z * -vdot(TOR2,z)
 }
 #declare TOR3 = vrotate(BOTTOM,x*144)
 torus
 {.175+MAJ - (MAJ+vdot(TOR3,y)), MIN
  rotate x*90
  translate z * vdot(TOR3,z)
 }
 torus
 {.175+MAJ - (MAJ+vdot(TOR3,y)), MIN
  rotate x*90
  translate z * -vdot(TOR3,z)
 }
}
#declare HALFBIGTORI = difference
{object {BIGTORI}
 box {<-.3,0,-.3>, <.3,.3,.3>}
}                                                                             

#declare TUBE = union
{object {FIVETORI}
 object {HALFBIGTORI}

 cylinder {<MAJ+.175,0,0>, <MAJ+.175,0,BACKBAR>, MIN}
 cylinder {POINT+x*.175, <vdot(POINT,x)+.175,0,BACKBAR>, MIN}
 cylinder {<MAJ+.175,0,0>, <MAJ+.175,0,BACKBAR>, MIN rotate z*180}
 cylinder {POINT+x*.175, <vdot(POINT,x)+.175,0,BACKBAR>, MIN rotate z*180}

 texture {T_Silver_3C}
}


//I forget what all these numbes mean. The basic idea is that if the paddles moved at a constant rate,
//then they'd pass through the balls after knocking them out of the tubes. I had to play around with
//these numbers to get the paddle to pause after launching the ball, then go faster to catch up with the 
//next ball, and then go at the same speed as the ball. 
#declare STARTING = .005
#declare WAIT = .025
#declare CATCHUP = .50
#declare HIT = .03791009
#declare BOT = HIT + .5*INTUBE  //.0989
#declare PARTCYCLE = .160083

#declare PADDLECLOCK = mod (CLOCK1,PARTCYCLE)
#if (PADDLECLOCK <= STARTING)                 //.06944444444444
    #declare PADDLECLOCK2 = PADDLECLOCK
    #declare PADDLECLOCK2 = -360*PADDLECLOCK2/.1318666
    #else
    #if (PADDLECLOCK <= STARTING + WAIT)
        #declare PADDLECLOCK2 = STARTING
        #declare PADDLECLOCK2 = -360*PADDLECLOCK2/.1318666
        #else
        #if (PADDLECLOCK <= BOT)
            #declare PADDLECLOCK2 = STARTING + WAIT*((PADDLECLOCK-STARTING-WAIT)/(BOT-STARTING-WAIT)) + (BOT-STARTING-WAIT)*((PADDLECLOCK-STARTING-WAIT)/(BOT-STARTING-WAIT))
            #declare PADDLECLOCK2 = -360*PADDLECLOCK2/.1318666
            #else
                 #declare PADDLECLOCK2 = -180+ANGLE
        #end
    #end
#end

#declare RIGHTPLATE = cylinder
{<0,-.005,0>, <0,.005,0>, RAD
 rotate z*15
 translate x*-.175
}
#declare RIGHTPADDLE = union
{object {RIGHTPLATE}
 cylinder {<0,0,0>, <-.165,0,0>, MIN*2}
 sphere {<-.165,0,0>, MIN*2}
 cylinder {<0,0,0>, <0,0,BACKBAR>, MIN*1.5}
 sphere {<0,0,0>, MIN*2}
 texture {T_Gold_3C}
 rotate z*17
 rotate z*PADDLECLOCK2
 translate x*(.175+.25)
}

#declare PADDLECLOCK = mod (CLOCK1+TIME+INTUBE,PARTCYCLE)
#if (PADDLECLOCK <= STARTING)                 //.06944444444444
    #declare PADDLECLOCK2 = PADDLECLOCK
    #declare PADDLECLOCK2 = 360*PADDLECLOCK2/.1318666
    #else
    #if (PADDLECLOCK <= STARTING + WAIT)
        #declare PADDLECLOCK2 = STARTING
        #declare PADDLECLOCK2 = 360*PADDLECLOCK2/.1318666
        #else
        #if (PADDLECLOCK <= BOT)
            #declare PADDLECLOCK2 = STARTING + WAIT*((PADDLECLOCK-STARTING-WAIT)/(BOT-STARTING-WAIT)) + (BOT-STARTING-WAIT)*((PADDLECLOCK-STARTING-WAIT)/(BOT-STARTING-WAIT))
            #declare PADDLECLOCK2 = 360*PADDLECLOCK2/.1318666
            #else
                 #declare PADDLECLOCK2 = 180+ANGLE2
        #end
    #end
#end

#declare LEFTPLATE = cylinder
{<0,-.005,0>, <0,.005,0>, RAD
 rotate z*-15
 translate x*.175
}
#declare LEFTPADDLE = union
{object {LEFTPLATE}
 cylinder {<0,0,0>, <.165,0,0>, MIN*2}
 cylinder {<0,0,0>, <0,0,BACKBAR>, MIN*1.5}
 sphere {<.165,0,0>, MIN*2}
 sphere {<0,0,0>, MIN*2}
 texture {T_Gold_3C}
 rotate z*-17
 rotate z*PADDLECLOCK2
 translate -x*(.175+.25)
}


//These are the three points for the large silver triangles of the machine
#declare A = <CATCH1+MAJ,0,.15>        //Right Bottom
#declare B = <-TOSS1-MAJ,0,.15>        //Left Bottom
#declare C = <vdot((A+B)/2,x),.8,.15>   //Top

#declare D = vdot(C,y) * abs(2*vdot(B,x))/vdot(A-B,x)       //Top of center triangle
#declare FORWARD = .05                                      //"Forwardness" of center triangle

#declare TWOBIG = texture
{T_Silver_3C}
#declare ONESMALL = texture
{T_Gold_3C}

#declare MACHRAD = .045     //Machine roundedness radius
#declare DEPTH=.8           //Depth of the machine

#declare SIDELENGTH = vlength(A-C)
#declare SIDEANGLE = degrees(acos((vlength(A-B)/2)/SIDELENGTH))
#declare SIDEMESHRIGHT = mesh
{triangle {<MACHRAD,0,MACHRAD+.15>, <MACHRAD,0,DEPTH>, <MACHRAD,SIDELENGTH,MACHRAD+.15>}
 triangle {<MACHRAD,SIDELENGTH,DEPTH>, <MACHRAD,0,DEPTH>, <MACHRAD,SIDELENGTH,MACHRAD+.15>}
 rotate z*(90-SIDEANGLE)
 translate x*vdot(A,x)
}
#declare SIDEMESHLEFT = mesh
{triangle {<-MACHRAD,0,MACHRAD+.15>, <-MACHRAD,0,DEPTH>, <-MACHRAD,SIDELENGTH,MACHRAD+.15>}
 triangle {<-MACHRAD,SIDELENGTH,DEPTH>, <-MACHRAD,0,DEPTH>, <-MACHRAD,SIDELENGTH,MACHRAD+.15>}
 rotate -z*(90-SIDEANGLE)
 translate x*vdot(B,x)
}

#declare BIGTRIANGLE = union
{mesh {triangle {A,B,C}}

 sphere {A+z*MACHRAD, MACHRAD}
 sphere {B+z*MACHRAD, MACHRAD}
 sphere {C+z*MACHRAD, MACHRAD}
 cylinder {A+z*MACHRAD, B+z*MACHRAD, MACHRAD}
 cylinder {B+z*MACHRAD, C+z*MACHRAD, MACHRAD}
 cylinder {A+z*MACHRAD, C+z*MACHRAD, MACHRAD}

 cylinder {A+z*MACHRAD, A+z*(DEPTH-.15), MACHRAD}
 cylinder {B+z*MACHRAD, B+z*(DEPTH-.15), MACHRAD}
 cylinder {C+z*MACHRAD, C+z*(DEPTH-.15), MACHRAD}

 object {SIDEMESHRIGHT }
 object {SIDEMESHLEFT}

 texture {TWOBIG}
}

#declare SMALLTRIANGLE = union
{mesh {triangle {B-z*FORWARD, (B*<-1,1,1>)-z*FORWARD, <0,D,.15-FORWARD>}}

 sphere {B-z*(FORWARD-MACHRAD), MACHRAD}
 sphere {(B*<-1,1,1>)-z*(FORWARD-MACHRAD), MACHRAD}
 sphere {<0,D,.15-(FORWARD-MACHRAD)>, MACHRAD}
 cylinder {<0,D,.15-(FORWARD-MACHRAD)>, (B*<-1,1,1>)-(FORWARD-MACHRAD), MACHRAD}
 cylinder {<0,D,.15-(FORWARD-MACHRAD)>, B-(FORWARD-MACHRAD), MACHRAD}
 cylinder {(B*<-1,1,1>)-z*(FORWARD-MACHRAD), B-z*(FORWARD-MACHRAD), MACHRAD}

 texture {ONESMALL}
}


#declare TRIANGLES = union
{object {BIGTRIANGLE}
 object {BIGTRIANGLE translate -x*(vdot(A,x)-abs(vdot(B,x)))}
 object {SMALLTRIANGLE}
 scale <1.05,1.05,1>
 translate y*-.06
}
           
//The little black nubs at the edges of the rods going into the machine; it helps to distinguish
//them from their reflections and show where they end           
#declare NUBS = union
{cylinder {<.425,0,.14>,<.425,0,1>, .013}                           //Center
 cylinder {<.5555,0,.145>,<.5555,0,1>, .009}                        //Mid-Right
 cylinder {<.6545,0,.145>,<.6545,0,1>, .009}                        //Right
 cylinder {<.425*2-.5555,0,.145-FORWARD>,<.425*2-.5555,0,1>, .009}  //Mid-Left
 cylinder {<.425*2-.6545,0,.145-FORWARD>,<.425*2-.6545,0,1>, .009}  //Left

 cylinder {<-.425,0,.14>,<-.425,0,1>, .013}
 cylinder {<-.5555,0,.145>,<-.5555,0,1>, .009}
 cylinder {<-.6545,0,.145>,<-.6545,0,1>, .009}
 cylinder {<-.425*2+.5555,0,.145-FORWARD>,<-.425*2+.5555,0,1>, .009}
 cylinder {<-.425*2+.6545,0,.145-FORWARD>,<-.425*2+.6545,0,1>, .009}

 texture
 {pigment {color rgb <.2,.2,.2>}
 }
}

#declare MACHINE = union
{object {TRIANGLES}
 object {NUBS}
 object {TUBE translate x* .425}
 object {TUBE translate x*-.425}
 object {RIGHTPADDLE}
 object {LEFTPADDLE}
}

object {MACHINE}