// Marsenvr.inc   1999 Neil Alexander

// Mars environment for Mars animation
// does not include sky or sun

#include "marstext.inc"

plane { y,0
  texture {
    pigment { granite
      color_map {
        [0 rgb Suncol]
        [1 rgb Suncol*0.75]
        }
      scale 100
      }
    normal { bumps 0.3 scale 20 }
    finish { diffuse 0.85 }
    }
  }

#declare C1 = 0;
#declare S1 = seed(8);
#while (C1<250)             // rocks
  blob {        // random-shaped rock
    threshold 0.56
    sphere {0,1,1} // base part to make sure rock is grounded
    sphere {0,1,1  // random parts
      scale <0.5+rand(S1),0.5+rand(S1),0.5+rand(S1)>
      translate <rand(S1),rand(S1),rand(S1)>/2
      }
    sphere {0,1,1
      scale <0.5+rand(S1),0.5+rand(S1),0.5+rand(S1)>
      translate <rand(S1),rand(S1),rand(S1)>/2
      }
    sphere {0,1,1
      scale <0.5+rand(S1),0.5+rand(S1),0.5+rand(S1)>
      translate <rand(S1),rand(S1),rand(S1)>/2
      } 
    
    scale 24*rand(S1)
    
    translate <(rand(S1)-0.5)*3000,0,rand(S1)*2000-500>
    
    
    texture { //  rock texture
      pigment { bozo
        color_map {
          [0 rgb Suncol*0.75]
          [1 rgb <0.4,0.4,0.38>]
          }
        turbulence 0.4
        omega 0.8
        scale 0.5
        }
      finish { diffuse 0.8 }
      normal { granite 0.7 scale 2 }
      }
    }
  #declare C1 = C1 + 1;
  #end // while loop - rocks   
  
#declare C1 = 0;
#declare S1 = seed(12);
#while (C1<250)             // rocks, 2nd field
  blob {        // random-shaped rock
    threshold 0.56
    sphere {0,1,1} // base part to make sure rock is grounded
    sphere {0,1,1  // random parts
      scale <0.5+rand(S1),0.5+rand(S1),0.5+rand(S1)>
      translate <rand(S1),rand(S1),rand(S1)>/2
      }
    sphere {0,1,1
      scale <0.5+rand(S1),0.5+rand(S1),0.5+rand(S1)>
      translate <rand(S1),rand(S1),rand(S1)>/2
      }
    sphere {0,1,1
      scale <0.5+rand(S1),0.5+rand(S1),0.5+rand(S1)>
      translate <rand(S1),rand(S1),rand(S1)>/2
      } 
    
    scale 24*rand(S1)
    
    translate <(rand(S1)-0.5)*3000,0,rand(S1)*-2000-500>
    
    
    texture { //  rock texture
      pigment { bozo
        color_map {
          [0 rgb Suncol*0.75]
          [1 rgb <0.4,0.4,0.38>]
          }
        turbulence 0.4
        omega 0.8
        scale 0.5
        }
      finish { diffuse 0.8 }
      normal { granite 0.7 scale 2 }
      }
    }
  #declare C1 = C1 + 1;
  #end // while loop - rocks
 
height_field { 
  gif
  "Mars.gif"
  smooth
  translate <-0.5,0,-0.5>
  scale <40000,5000,40000>
  translate <-5000,-1000,0>
  rotate y*220
  
  texture {
    pigment { gradient y
      pigment_map {
        [0 granite
          color_map {
            [0 rgb Suncol]
            [1 rgb Suncol*0.75]
            }
          scale 0.02
          ]
        [0.75 granite
          color_map {
            [0 rgb Suncol*0.5]
            [1 rgb <0.3,0.07,0.05>]
            }
          scale 0.02
          ]
        }
      scale 5000
      turbulence 0.2
      }
    normal { bumps 0.3 scale 20 }
    finish { diffuse 0.85 }
    }
  }