// Marstext.inc   1999 Neil Alexander

// textures for Mars animation     

#declare Suncol = <1.0,0.75,0.6>;

#declare Marscol = rgb <1.0,0.7,0.5>;

#declare Whitetext = texture { 
      pigment { color rgb 1 }
      finish { diffuse 0.8 phong 0.2 phong_size 15 }
      }
      
#declare Blacktext = texture { 
      pigment { color rgb 0.3 }
      finish { phong 0.5 phong_size 25 }
      } 
      
#declare Alumtext = texture { // brushed aluminum
      pigment { color rgb 1 }
      finish {
        diffuse 0.5 
        metallic 
        brilliance 3 
        phong 1 
        phong_size 40 
        reflection 0.2 
        }
      normal { bumps 0.01 scale 0.0001 }
      }
      
#declare Shinytext = texture { // shiny metal
        pigment { color rgb 0.8 }
        finish {
          diffuse 0.5 
          metallic 
          brilliance 4 
          phong 1 
          phong_size 50 
          reflection 0.4 
          }
        } 
        
#declare Brasstext = texture { // shiny brass
        pigment { color rgb <1,0.9,0.4> }
        finish {
          diffuse 0.5 
          metallic 
          brilliance 4 
          phong 1 
          phong_size 50 
          reflection 0.4 
          }
        }

#declare Whitebulb = texture {
  pigment { color rgb <1,0.85,0.7>}
  finish { ambient 1 }
  }
  
#declare Redbulb = texture {
  pigment { color rgb <1,0.4,0.4>}
  finish { ambient 1 }
  }
  
#declare Bluebulb = texture {
  pigment { color rgb <0.5,0.55,1>}
  finish { ambient 1 }
  }

#declare SolarPanel = texture {
  pigment { hexagon
    pigment {gradient z
      color_map {
        [0.05 color rgb <1,0.9,0.4>]
        [0.05 color rgb <0.1,0.1,0.4>]
        [0.95 color rgb <0.1,0.1,0.4>]
        [0.95 color rgb <1,0.9,0.4>]
        }
      scale 0.25
      },   
    pigment {gradient z
      color_map {
        [0.05 color rgb <1,0.9,0.4>]
        [0.05 color rgb <0.1,0.1,0.4>]
        [0.95 color rgb <0.1,0.1,0.4>]
        [0.95 color rgb <1,0.9,0.4>]
        }
      rotate y*60
      scale 0.25
      },
    pigment {gradient z
      color_map {
        [0.05 color rgb <1,0.9,0.4>]
        [0.05 color rgb <0.1,0.1,0.4>]
        [0.95 color rgb <0.1,0.1,0.4>]
        [0.95 color rgb <1,0.9,0.4>]
        }
      rotate y*120
      scale 0.25
      }
    scale 10
    }
  finish { diffuse 0.3 phong 1 phong_size 50 reflection 0.3 }
  }  // end SolarPanel
    