// Persistence Of Vision raytracer version 3.1

//Dice phase 1 - objects fall to floor

#version 3.0
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

#declare G4 = texture { T_Glass4 }

camera {
    location <-30, 36, -36>
    right <4/3, 0.0, 0.0>
    direction 2*z
    look_at <0, 0, 0>
}


light_source { <10, 20, -30> color White fade_distance 24 fade_power 1}
light_source { <10, 25, 30 > color White fade_distance 14 fade_power 2}
light_source { <-15, 35, -15> color White fade_distance 30 fade_power 2}

//marble floor
box{<-100,-100,-100> <100,-6,100> 
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
}

//All objects defined at Y=0

#declare Face = prism {conic_sweep linear_spline
       0.8,// height 1
       1,  // height 1
       5,
       <0.5,0.5>,<-0.5,0.5>,<-0.5,-0.5>,<0.5,-0.5>,<0.5,0.5>
       rotate <180,0,0> translate <0.5,1,0.5> scale <10,5.05,10> //base ends up at y=-1 after rotation
       texture {G4} interior {ior 1.5} finish {ambient 0.25}
      }
#declare One = cylinder {<5,-0.01,5>,<5,.1,5>, 0.85 texture {pigment {White } finish {Shiny ambient 0.25}}}
#declare NNZ = prism {linear_sweep linear_spline
                      -0.01,
                      0.1,
                      5,
                      <7,7>,<8,8>,<9,8>,8,7>,<7,7>
                      scale<0.5,1,0.5>}
#declare Two = union {object {One translate <-2,0,2>}
                      object {One translate <2,0,-2>}}
#declare Three = union{object {One}
                       object {Two}}
#declare Four = union {object {Two}
                       object {One translate <2,0,2>}
                       object {One translate <-2,0,-2>}}
#declare Five = union {object {One}
                       object {Four}}
#declare Six = union {object {Four}
                      object {One translate <0,0,2>}
                      object {One translate <0,0,-2>}}                                              
//construction of cube net
#declare Net = union {
object {Face translate <-5,0,-5>
}//1
object {Face translate <-5,0,5>
}//2
object {Face translate <5,0,-5>
}//3
object {Face translate <-15,0,-5>
}//4
object {Face translate <-5,0,-15>
}//5
object {Face translate <15,0,-5>
}//6
}

object {Net translate <0,max(125-clock*131,-6),0>}
object {One translate <-5,max(23-clock*131,-6),-5>}
object {Two translate <-5,max(46-clock*131,-6),5>}
object {Three translate <5,max(66-clock*131,-6),-5>}
object {Four translate <-15,max(81-clock*131,-6),-5>}
object {Five translate <-5,max(91-clock*131,-6),-15>}
object {Six translate <15,max(96-clock*131,-6),-5>}
          