// Persistence Of Vision raytracer version 3.1

//Dice phase 2 - net of dice folds up to form a cube

#version 3.0
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

camera {
    location <-30, 36, -36>
    right <4/3, 0.0, 0.0>
    direction 2*z
    look_at <0, 0, 0>
}


light_source { <10, 20, -30> color White fade_distance 24 fade_power 1}
light_source { <10, 25, 30 > color White fade_distance 14 fade_power 2}
light_source { <-15, 35, -15> color White fade_distance 30 fade_power 2}

//marble floor
box{<-100,-100,-100> <100,-6,100> 
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
}

//All objects defined at y = 0
#declare Face = prism {conic_sweep linear_spline
       0.8,// height 1
       1,  // height 2
       5,
       <0.5,0.5>,<-0.5,0.5>,<-0.5,-0.5>,<0.5,-0.5>,<0.5,0.5>
       rotate <180,0,0> translate <0.5,1,0.5> scale <10,1,10> //base ends up at y=-1 after rotation
       texture {pigment {Gray40} finish {Shiny}}
      }
#declare One = cylinder {<5,-0.01,5>,<5,.1,5>, 0.85 texture {pigment {White } finish {Shiny ambient 0.25}} }
#declare Two = union {object {One translate <-2,0,2>}
                      object {One translate <2,0,-2>}}
#declare Three = union{object {One}
                       object {Two}}
#declare Four = union {object {Two}
                       object {One translate <2,0,2>}
                       object {One translate <-2,0,-2>}}
#declare Five = union {object {One}
                       object {Four}}
#declare Six = union {object {Four}
                      object {One translate <0,0,2>}
                      object {One translate <0,0,-2>}}                                              

//faces of the dice folding up into a cube

union {object {Face}
       object {One}
       translate <-5,-6,-5>
}//1

union {object {Face}
       object {Two}
       rotate <-90*clock,0,0> translate <-5,-6,5>
}//2

union {
union {object {Face}
       object {Six} rotate <0,0,90*clock> translate <10,0,0>}
union {object {Face}
       object {Three}} rotate <0,0,90*clock> translate <5,-6,-5>
}//6 and 3
      
union {object {Face}
       object {Four}
       translate <-10,0,0> rotate <0,0,-90*clock> translate <-5,-6,-5>
}//4

union {object {Face}
       object {Five}
       translate <0,0,-10> rotate <90*clock,0,0> translate <-5,-6,-5>
}//5
