// Persistence Of Vision raytracer version 3.1

//Dice phase 3 - cube transforms to rounded dice

#version 3.0
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

camera {
    location <-30, 36, -36>
    right <4/3, 0.0, 0.0>
    direction 2*z
    look_at <0, 0, 0>
}


light_source { <10, 20, -30> color White fade_distance 24 fade_power 1}
light_source { <10, 25, 30 > color White fade_distance 14 fade_power 2}
light_source { <-15, 35, -15> color White fade_distance 30 fade_power 2}

//marble floor
box{<-100,-100,-100> <100,-6,100> 
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
}
//the dice
difference {superellipsoid {<0.3*clock +0.005,0.3*clock+0.005> pigment {Gray40} finish {Shiny} hollow }
   cylinder { <-1.001,0.4,0.4>, <-0.99,0.4,0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}    //4
   cylinder { <-1.001,-0.4,0.4>, <-0.99,-0.4,0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}  //4
   cylinder { <-1.001,0.4,-0.4>, <-0.99,0.4,-0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}  //4
   cylinder { <-1.001,-0.4,-0.4>, <-0.99,-0.4,-0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//4
   cylinder { <-0.4,-0.4,-1.001>, <-0.4,-0.4,-0.99>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//5
   cylinder { <-0.4,0.4,-1.001>, <-0.4,0.4,-0.99>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//5
   cylinder { <0.4,-0.4,-1.001>, <0.4,-0.4,-0.99>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//5
   cylinder { <0.4,0.4,-1.001>, <0.4,0.4,-0.99>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//5
   cylinder { <0,0,-1.001>, <0,0,-0.99>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//5
   cylinder { <-0.4,1.001,-0.4>, <-0.4,0.99,-0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//6
   cylinder { <0.4,1.001,-0.4>, <0.4,0.99,-0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//6
   cylinder { <-0.4,1.001,0.4>, <-0.4,0.99,0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//6
   cylinder { <0.4,1.001,0.4>, <0.4,0.99,0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//6
   cylinder { <0,1.001,0.4>, <0,0.99,0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//6
   cylinder { <0,1.001,-0.4>, <0,0.99,-0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//6
   cylinder { <1.001,0.4,-0.4>, <0.99,0.4,-0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//3
   cylinder { <1.001,-0.4,0.4>, <0.99,-0.4,0.4>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//3
   cylinder { <1.001,0,0>, <0.99,0,0>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//3
   cylinder { <-0.4,0.4,1.001>, <-0.4,0.4,0.99>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//2
   cylinder { <0.4,-0.4,1.001>, <0.4,-0.4,0.99>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//2
   cylinder { <0,-1.001,0>,<0,-0.99,0>, 0.17 texture {pigment {White rgbt<1,1,1,1> }}}//1
scale 5 translate <0,-1,0>
}

light_source {<0,0,0> color rgb <1,1,1> * 5}

