// Persistence Of Vision raytracer version 3.1

//Dice phase 5 - hole closes

#version 3.0
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

camera {
    location <-30, 36, -36>
    right <4/3, 0.0, 0.0>
    direction 2*z
    look_at <0, 0, 0>
}


light_source { <10, 20, -30> color White fade_distance 24 fade_power 1}
light_source { <10, 25, 30 > color White fade_distance 14 fade_power 2}
light_source { <-15, 35, -15> color White fade_distance 30 fade_power 2}

//marble floor (with hole for dice to fall into
difference {box{<-100,-100,-100> <100,-6,100>} 
cylinder { <0,-5.9,0>, <0,-100,0>, 10}
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
}

disc {<0,-6,0>, y, 10
texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   } translate <0,-25+clock*25,0>
}