#declare FlipXY=transform { matrix <0,1,0, 1,0,0, 0,0,1, 0,0,0> }
#declare FlipXZ=transform { matrix <0,0,1, 0,1,0, 1,0,0, 0,0,0> }
#declare FlipYZ=transform { matrix <1,0,0, 0,0,1, 0,1,0, 0,0,0> }

#macro Connect(SP,SR,EP,ER)
  #local D=vlength(EP-SP);
  #local Rd=SR-ER;
  #local D2=sqrt(D*D-Rd*Rd);
  cone { SP+(EP-SP)/D*Rd*(SR)/D,(SR)*D2/D,EP+(EP-SP)/D*Rd*(ER)/D,(ER)*D2/D }
#end

#macro RoundedBar(v_SP,v_EP,R)
  #local vSP=(v_SP)*<1,1,1>;
  #local vEP=(v_EP)*<1,1,1>;
#if (vSP.x > vEP.x)
  #local tSave=vSP.x;
  #local vSP=<vEP.x,vSP.y,vSP.z>;
  #local vEP=<tSave,vEP.y,vEP.z>;
#end
#if (vSP.y > vEP.y)
  #local tSave=vSP.y;
  #local vSP=<vSP.x,vEP.y,vSP.z>;
  #local vEP=<vEP.x,tSave,vEP.z>;
#end
#if (vSP.z > vEP.z)
  #local tSave=vSP.z;
  #local vSP=<vSP.x,vSP.y,vEP.z>;
  #local vEP=<vEP.x,vEP.y,tSave>;
#end

  prism { vSP.y,vEP.y,9,
    <vEP.x-R,vEP.z>,<vEP.x,vEP.z-R>,<vEP.x,vSP.z+R>,
    <vEP.x-R,vSP.z>,<vSP.x+R,vSP.z>,<vSP.x,vSP.z+R>,
    <vSP.x,vEP.z-R>,<vSP.x+R,vEP.z>,<vEP.x-R,vEP.z> }
  cylinder { <vSP.x+R,vSP.y,vSP.z+R>,<vSP.x+R,vEP.y,vSP.z+R>,R }
  cylinder { <vEP.x-R,vSP.y,vSP.z+R>,<vEP.x-R,vEP.y,vSP.z+R>,R }
  cylinder { <vSP.x+R,vSP.y,vEP.z-R>,<vSP.x+R,vEP.y,vEP.z-R>,R }
  cylinder { <vEP.x-R,vSP.y,vEP.z-R>,<vEP.x-R,vEP.y,vEP.z-R>,R }
#end

#macro RoundedBox(v_SP,v_EP,R)
  #local vSP=(v_SP)*<1,1,1>;
  #local vEP=(v_EP)*<1,1,1>;
#if (vSP.x > vEP.x)
  #local tSave=vSP.x;
  #local vSP=<vEP.x,vSP.y,vSP.z>;
  #local vEP=<tSave,vEP.y,vEP.z>;
#end
#if (vSP.y > vEP.y)
  #local tSave=vSP.y;
  #local vSP=<vSP.x,vEP.y,vSP.z>;
  #local vEP=<vEP.x,sSave,vEP.z>;
#end
#if (vSP.z > vEP.z)
  #local tSave=vSP.z;
  #local vSP=<vSP.x,vSP.y,vEP.z>;
  #local vEP=<vEP.x,vEP.y,tSave>;
#end

  box {<vSP.x,vSP.y+R,vSP.z+R>,<vEP.x,vEP.y-R,vEP.z-R>}
  box {<vSP.x+R,vSP.y,vSP.z+R>,<vEP.x-R,vEP.y,vEP.z-R>}
  box {<vSP.x+R,vSP.y+R,vSP.z>,<vEP.x-R,vEP.y-R,vEP.z>}

  #local vSP=vSP+R;
  #local vEP=vEP-R;

  sphere { <vSP.x,vSP.y,vSP.z>,R}
  sphere { <vEP.x,vSP.y,vSP.z>,R}
  sphere { <vSP.x,vEP.y,vSP.z>,R}
  sphere { <vEP.x,vEP.y,vSP.z>,R}
  sphere { <vSP.x,vSP.y,vEP.z>,R}
  sphere { <vEP.x,vSP.y,vEP.z>,R}
  sphere { <vSP.x,vEP.y,vEP.z>,R}
  sphere { <vEP.x,vEP.y,vEP.z>,R}

  cylinder { <vSP.x,vSP.y,vSP.z>,<vEP.x,vSP.y,vSP.z>,R }
  cylinder { <vSP.x,vEP.y,vSP.z>,<vEP.x,vEP.y,vSP.z>,R }
  cylinder { <vSP.x,vSP.y,vEP.z>,<vEP.x,vSP.y,vEP.z>,R }
  cylinder { <vSP.x,vEP.y,vEP.z>,<vEP.x,vEP.y,vEP.z>,R }
  cylinder { <vSP.x,vSP.y,vSP.z>,<vSP.x,vEP.y,vSP.z>,R }
  cylinder { <vEP.x,vSP.y,vSP.z>,<vEP.x,vEP.y,vSP.z>,R }
  cylinder { <vSP.x,vSP.y,vEP.z>,<vSP.x,vEP.y,vEP.z>,R }
  cylinder { <vEP.x,vSP.y,vEP.z>,<vEP.x,vEP.y,vEP.z>,R }
  cylinder { <vSP.x,vSP.y,vSP.z>,<vSP.x,vSP.y,vEP.z>,R }
  cylinder { <vEP.x,vSP.y,vSP.z>,<vEP.x,vSP.y,vEP.z>,R }
  cylinder { <vSP.x,vEP.y,vSP.z>,<vSP.x,vEP.y,vEP.z>,R }
  cylinder { <vEP.x,vEP.y,vSP.z>,<vEP.x,vEP.y,vEP.z>,R }
#end

#macro AxisRotate(Axis,Angle)
  #local vX=vnormalize(Axis);
  #local vY=vnormalize(vcross(vX,<vX.y,vX.z,-vX.x>));
  #local vZ=vnormalize(vcross(vX,vY));
  matrix < vX.x,vY.x,vZ.x, vX.y,vY.y,vZ.y, vX.z,vY.z,vZ.z, 0,0,0 >
  rotate x*(Angle)
  matrix < vX.x,vX.y,vX.z, vY.x,vY.y,vY.z, vZ.x,vZ.y,vZ.z, 0,0,0 >
#end

#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
#if (vlength(vY)>0)
  #local vZ1=vnormalize(vcross(vX1,vY));
  #local vZ2=vnormalize(vcross(vX2,vY));
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
  matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end
#end

#macro Transition(Start,End,Swerve,Phase)
  #local t_P=(Phase)*pi;
  #if(t_P<0) #local t_P=0; #end
  #if(t_P>pi) #local t_P=pi; #end
  #local t_TL=(1-cos(t_P))/2;
  #local t_TS=(1-cos(t_P*2))/2;
  ( (Start)*(1-t_TL) + (End)*t_TL + (Swerve)*t_TS )
#end

#macro SmoothSeed(Array,Freq)
  #declare Array[0]= Freq;
  #declare Array[1]= seed(floor(clock*(Freq)));
  #declare Array[2]= seed(floor(clock*(Freq)+1));
  #declare Array[3]= seed(floor(clock*(Freq)+2));
#end

#macro SmoothRand(Array)
  #local t_T=clock*Array[0]-floor(clock*Array[0]);
  ( rand(Array[1])*(t_T-1)*(t_T-1)*.5
  + rand(Array[2])*(.5+t_T-t_T*t_T)
  + rand(Array[3])*t_T*t_T*.5 )
#end

#macro Matrix(mv_X,mv_Y,mv_Z,mv_L)
matrix <(mv_X).x,(mv_X).y,(mv_X).z,(mv_Y).x,(mv_Y).y,(mv_Y).z,(mv_Z).x,(mv_Z).y,(mv_Z).z,(mv_L).x,(mv_L).y,(mv_L).z >
#end

#macro vmatrix(op,vx,vy,vz,vl)
  (((op).x*(vx))+((op).y*(vy))+((op).z*(vz))+vl)
#end

#macro Stretch(vector,amount)
  #local v_X=vnormalize(vector);
  #local s_A=(amount)-1;
  matrix <
    s_A*v_X.x*v_X.x+1,s_A*v_X.x*v_X.y,  s_A*v_X.x*v_X.z,
    s_A*v_X.y*v_X.x,  s_A*v_X.y*v_X.y+1,s_A*v_X.y*v_X.z,
    s_A*v_X.z*v_X.x,  s_A*v_X.z*v_X.y,  s_A*v_X.z*v_X.z+1,
    0,0,0>
#end

#macro FindKnee(pA,pH,lT,lS,vD)
  #local lB=vlength(pA-(pH));
#if( (lB>lT+lS) | (lT>lB+lS) | (lS>lT+lB) )
#error "Invalid span lengths.\n"
#end
  #local tS=(lT+lS+lB)/2;
  #local tA=sqrt(tS*(tS-(lT))*(tS-(lS))*(tS-lB));
  #local tH=tA*2/lB;
  #local vO=vnormalize(pA-(pH));
  #local vF=vnormalize(vcross(vD,vO));
  #local vU=vnormalize(vcross(vO,vF));
  (pH+vO*sqrt((lT)*(lT)-tH*tH)+vU*tH)
#end

#macro QuickSpline(Array,Index)
  #local I=floor(Index);
  #local J=Index-I;
  ( .5*(A[I]+A[I+1]) + J*(A[I+1]-A[I]) + J*J*.5*(A[I]-2*A[I+1]+A[I+2]) )
#end

#macro vm_invert(org,vx,vy,vz,vl)
  #local p_T=org-(vl);
  ( p_T.x*<(vx).x,(vy).x,(vz).x> 
  + p_T.y*<(vx).y,(vy).y,(vz).y> 
  + p_T.z*<(vx).z,(vy).z,(vz).z> )
#end

#macro Move(StartTime,StartPosition,EndTime,EndPosition,Swerve)
  #local t_P=(clock-(StartTime))/(EndTime-(StartTime));
  #local t_P=max(min(t_P,1),0)*pi;
  #local t_TL=(1-cos(t_P))/2;
  #local t_TS=(1-cos(t_P*2))/2;
  ( (StartPosition)*(1-t_TL) + (EndPosition)*t_TL + (Swerve)*t_TS )
#end

#macro sgn(ARG)
  ( (ARG) = 0 ? 0 : ( (ARG) < 0 ? -1 : 1) ) 
#end

#macro BevelBox(S,E,BW)
  #local vC=(S+E)/2;
  #local vD=<abs(S.x-E.x),abs(S.y-E.y),abs(S.z-E.z)>/2;
  #local xE=(vD.y+vD.z)/2-BW/sqrt(8);
  #local yE=(vD.x+vD.z)/2-BW/sqrt(8);
  #local zE=(vD.x+vD.y)/2-BW/sqrt(8);

  intersection {
    box { -1,1 matrix <vD.x,0,0, 0,xE,xE, 0,-xE,xE, vC.x,vC.y,vC.z> }
    box { -1,1 matrix <yE,0,-yE, 0,vD.y,0, yE,0,yE, vC.x,vC.y,vC.z> }
    box { -1,1 matrix <zE,zE,0, -zE,zE,0, 0,0,vD.z, vC.x,vC.y,vC.z> }
    bounded_by { box { vC-vD,vC+vD } }
  }
#end

