#macro PrepConSpline(PtArray,CoArray)
  #local I=0;
  #local Sum=0;
  #while (I<(dimension_size(PtArray,1)-3))
    #local L0=PtArray[I+1];
    #local L1=PtArray[I+2];
    #local V0=vnormalize(L1-PtArray[I]);
    #local V1=vnormalize(PtArray[I+3]-L0);
    #local vA=(L1-L0)*3/2;
    #local vB=(V0+V1)/4;
    #local C=vdot(vA,vA);
    #local D=vdot(vA,vB);
    #local E=vdot(vB,vB)-1;
    #local T=(D-sqrt(D*D-C*E))/E;
    #declare CoArray[I][0]=L0;
    #declare CoArray[I][1]=V0;
    #declare CoArray[I][2]=-2*V0/T-V1/T-3*L0/T/T+3*L1/T/T;
    #declare CoArray[I][3]=V0/T/T+V1/T/T+2*L0/T/T/T-2*L1/T/T/T;
    #declare CoArray[I][4]=<Sum,T,1>;
    #local Sum=Sum+T;
    #local I=I+1;
  #end
  #while (I<dimension_size(CoArray,1)-1)
    #declare CoArray[I][4]=<Sum,1000,1>;
    #local Sum=Sum+1000;
    #local I=I+1;
  #end
#end

#macro PrepFullSpline(PtArray,CoArray)
  #local I=0;
  #local J=0;
  #local Sum=0;
  #while (I<dimension_size(PtArray,1)-2)
    #local L0=PtArray[I];
    #local L1=PtArray[I+2];
    #local V0=PtArray[I+1];
    #local V1=PtArray[I+3];
    #local vA=(L1-L0)*3/2;
    #local vB=(V0+V1)/4;
    #local C=vdot(vA,vA);
    #local D=vdot(vA,vB);
    #local E=vdot(vB,vB)-(vlength(V0)+vlength(V1))*(vlength(V0)+vlength(V1))/4;
    #local T=(D-sqrt(D*D-C*E))/E;
    #declare CoArray[J][0]=L0;
    #declare CoArray[J][1]=V0;
    #declare CoArray[J][2]=-2*V0/T-V1/T-3*L0/T/T+3*L1/T/T;
    #declare CoArray[J][3]=V0/T/T+V1/T/T+2*L0/T/T/T-2*L1/T/T/T;
    #declare CoArray[J][4]=<Sum,T,1>;
    #local Sum=Sum+T;
    #local I=I+2;
    #local J=J+1;
  #end
  #declare CoArray[J][0]=PtArray[I];
  #declare CoArray[J][1]=PtArray[I+1];
  #declare CoArray[J][2]=<0,0,0>;
  #declare CoArray[J][3]=<0,0,0>;
  #declare CoArray[J][4]=<Sum,1e20,1>;
#end


#macro PrepVarSpline(PtArray,CoArray)
  #local I=0;
  #local Sum=0;
  #while (I<(dimension_size(PtArray,1)-3))
    #local L0=PtArray[I+1];
    #local L1=PtArray[I+2];
    #local V0=(L1-PtArray[I])/2;
    #local V1=(PtArray[I+3]-L0)/2;
    #local vA=(L1-L0)*3/2;
    #local vB=(V0+V1)/4;
    #local C=vdot(vA,vA);
    #local D=vdot(vA,vB);
    #local E=vdot(vB,vB)-(vlength(V0)+vlength(V1))*(vlength(V0)+vlength(V1))/4;
    #local T=(D-sqrt(D*D-C*E))/E;
    #declare CoArray[I][0]=L0;
    #declare CoArray[I][1]=V0;
    #declare CoArray[I][2]=-2*V0/T-V1/T-3*L0/T/T+3*L1/T/T;
    #declare CoArray[I][3]=V0/T/T+V1/T/T+2*L0/T/T/T-2*L1/T/T/T;
    #declare CoArray[I][4]=<Sum,1,T>;
    #local Sum=Sum+T;
    #local I=I+1;
  #end
  #while (I<dimension_size(CoArray,1)-1)
    #declare CoArray[I][4]=<Sum,1,1000>;
    #local Sum=Sum+1000;
    #local I=I+1;
  #end
#end

#macro SplineLoc(CoArray,Index)
  #local T=Index;
  #local T2=1; #local T3=1;
  #if (T<0) #local T2=0; #local T3=0; #end
  #local I=0;
  #while(T>vdot(CoArray[I][4],x+y) & I<dimension_size(CoArray,1)-1)
    #local I=I+1;
  #end
  #local T=(T-CoArray[I][4].x)*CoArray[I][4].z;
  (CoArray[I][3]*T*T*T*T3 + CoArray[I][2]*T*T*T2 + CoArray[I][1]*T +CoArray[I][0])
#end

#macro SplineVel(CoArray,Index)
  #local T=Index;
  #local T2=1; #local T3=1;
  #if (T<0) #local T2=0; #local T3=0; #end
  #local I=0;
  #while(T>vdot(CoArray[I][4],x+y) & I<dimension_size(CoArray,1)-1)
    #local I=I+1;
  #end
  #local T=(T-CoArray[I][4].x)*CoArray[I][4].z;
  (CoArray[I][3]*T*T*3*T3 + CoArray[I][2]*T*2*T2 + CoArray[I][1])
#end

#macro SplineAcc(CoArray,Index)
  #local T=Index;
  #local T2=1; #local T3=1;
  #if (T<0) #local T2=0; #local T3=0; #end
  #local I=0;
  #while(T>vdot(CoArray[I][4],x+y) & I<dimension_size(CoArray,1)-1)
    #local I=I+1;
  #end
  #local T=(T-CoArray[I][4].x)*CoArray[I][4].z;
  (CoArray[I][3]*T*6*T3 + CoArray[I][2]*2*T2)
#end
