#ifndef(GrebFoot)

#include "meshmacu.inc"

#local C=(sqrt(2)-1)*4/3;
#local X=3/sqrt(10);
#local Y=1/sqrt(10);

#local A=1.8;
#local B=sqrt(1.8*1.8+.9*.9);
#local T=.30;
#local N=T*C;
#local H=.001;
#local S=3-Test;

#local P0=<0,0,0>;
#local P1=<9*X,-9*Y,0>;
#local P2=<20-6*X,-6*Y,0>;
#local P3=<20,0,0>;
#local P4=<20+X*T*C,Y*T*C,0>;
#local P5=<20+X*T,Y*T,0>;

#local P8=<-B*X,B*Y,0>;
#local P9=<-B*X*C,B*Y*C,0>;

#local V0=<Y,X,0>;
#local V1=<Y,X,C>;
#local V2=<Y*C,X*C,1>;
#local V3=<0,0,1>;

#local AV=< B, B,A>;
#local BV=AV*C;
#local CV=AV*.001;
#local TV=<-T, T,T>;
#local NV=<-N, N,N>;
#local HV=<-H, H,H>;
#local Q0=<-1,-1,-1>;
#local Q1=< 1, 1,-1>;
#local Q2=<-1,-1, 1>;
#local Q3=< 1, 1, 1>;

#declare GrebFoot=mesh {

//ankle cuff

Bicubic(
  P8+CV*V0*Q0,P8+BV*V0*Q0,P9+AV*V0*Q0,P0+AV*V0*Q0,
  P8+CV*V1*Q0,P8+BV*V1*Q0,P9+AV*V1*Q0,P0+AV*V1*Q0,
  P8+CV*V2*Q0,P8+BV*V2*Q0,P9+AV*V2*Q0,P0+AV*V2*Q0,
  P8+CV*V3*Q0,P8+BV*V3*Q0,P9+AV*V3*Q0,P0+AV*V3*Q0,S)

Bicubic(
  P8+CV*V0*Q1,P8+BV*V0*Q1,P9+AV*V0*Q1,P0+AV*V0*Q1,
  P8+CV*V1*Q1,P8+BV*V1*Q1,P9+AV*V1*Q1,P0+AV*V1*Q1,
  P8+CV*V2*Q1,P8+BV*V2*Q1,P9+AV*V2*Q1,P0+AV*V2*Q1,
  P8+CV*V3*Q1,P8+BV*V3*Q1,P9+AV*V3*Q1,P0+AV*V3*Q1,S)

Bicubic(
  P8+CV*V0*Q2,P8+BV*V0*Q2,P9+AV*V0*Q2,P0+AV*V0*Q2,
  P8+CV*V1*Q2,P8+BV*V1*Q2,P9+AV*V1*Q2,P0+AV*V1*Q2,
  P8+CV*V2*Q2,P8+BV*V2*Q2,P9+AV*V2*Q2,P0+AV*V2*Q2,
  P8+CV*V3*Q2,P8+BV*V3*Q2,P9+AV*V3*Q2,P0+AV*V3*Q2,S)

Bicubic(
  P8+CV*V0*Q3,P8+BV*V0*Q3,P9+AV*V0*Q3,P0+AV*V0*Q3,
  P8+CV*V1*Q3,P8+BV*V1*Q3,P9+AV*V1*Q3,P0+AV*V1*Q3,
  P8+CV*V2*Q3,P8+BV*V2*Q3,P9+AV*V2*Q3,P0+AV*V2*Q3,
  P8+CV*V3*Q3,P8+BV*V3*Q3,P9+AV*V3*Q3,P0+AV*V3*Q3,S)

// instep
Bicubic(
  P0+AV*V0*Q0,P1+AV*V0*Q0,P2+TV*V0*Q0,P3+TV*V0*Q0,
  P0+AV*V1*Q0,P1+AV*V1*Q0,P2+TV*V1*Q0,P3+TV*V1*Q0,
  P0+AV*V2*Q0,P1+AV*V2*Q0,P2+TV*V2*Q0,P3+TV*V2*Q0,
  P0+AV*V3*Q0,P1+AV*V3*Q0,P2+TV*V3*Q0,P3+TV*V3*Q0,S)

Bicubic(
  P0+AV*V0*Q1,P1+AV*V0*Q1,P2+TV*V0*Q1,P3+TV*V0*Q1,
  P0+AV*V1*Q1,P1+AV*V1*Q1,P2+TV*V1*Q1,P3+TV*V1*Q1,
  P0+AV*V2*Q1,P1+AV*V2*Q1,P2+TV*V2*Q1,P3+TV*V2*Q1,
  P0+AV*V3*Q1,P1+AV*V3*Q1,P2+TV*V3*Q1,P3+TV*V3*Q1,S)

Bicubic(
  P0+AV*V0*Q2,P1+AV*V0*Q2,P2+TV*V0*Q2,P3+TV*V0*Q2,
  P0+AV*V1*Q2,P1+AV*V1*Q2,P2+TV*V1*Q2,P3+TV*V1*Q2,
  P0+AV*V2*Q2,P1+AV*V2*Q2,P2+TV*V2*Q2,P3+TV*V2*Q2,
  P0+AV*V3*Q2,P1+AV*V3*Q2,P2+TV*V3*Q2,P3+TV*V3*Q2,S)

Bicubic(
  P0+AV*V0*Q3,P1+AV*V0*Q3,P2+TV*V0*Q3,P3+TV*V0*Q3,
  P0+AV*V1*Q3,P1+AV*V1*Q3,P2+TV*V1*Q3,P3+TV*V1*Q3,
  P0+AV*V2*Q3,P1+AV*V2*Q3,P2+TV*V2*Q3,P3+TV*V2*Q3,
  P0+AV*V3*Q3,P1+AV*V3*Q3,P2+TV*V3*Q3,P3+TV*V3*Q3,S)

//toe cap

Bicubic(
  P3+TV*V0*Q0,P4+TV*V0*Q0,P5+NV*V0*Q0,P5+HV*V0*Q0,
  P3+TV*V1*Q0,P4+TV*V1*Q0,P5+NV*V1*Q0,P5+HV*V1*Q0,
  P3+TV*V2*Q0,P4+TV*V2*Q0,P5+NV*V2*Q0,P5+HV*V2*Q0,
  P3+TV*V3*Q0,P4+TV*V3*Q0,P5+NV*V3*Q0,P5+HV*V3*Q0,S)

Bicubic(
  P3+TV*V0*Q1,P4+TV*V0*Q1,P5+NV*V0*Q1,P5+HV*V0*Q1,
  P3+TV*V1*Q1,P4+TV*V1*Q1,P5+NV*V1*Q1,P5+HV*V1*Q1,
  P3+TV*V2*Q1,P4+TV*V2*Q1,P5+NV*V2*Q1,P5+HV*V2*Q1,
  P3+TV*V3*Q1,P4+TV*V3*Q1,P5+NV*V3*Q1,P5+HV*V3*Q1,S)

Bicubic(
  P3+TV*V0*Q2,P4+TV*V0*Q2,P5+NV*V0*Q2,P5+HV*V0*Q2,
  P3+TV*V1*Q2,P4+TV*V1*Q2,P5+NV*V1*Q2,P5+HV*V1*Q2,
  P3+TV*V2*Q2,P4+TV*V2*Q2,P5+NV*V2*Q2,P5+HV*V2*Q2,
  P3+TV*V3*Q2,P4+TV*V3*Q2,P5+NV*V3*Q2,P5+HV*V3*Q2,S)

Bicubic(
  P3+TV*V0*Q3,P4+TV*V0*Q3,P5+NV*V0*Q3,P5+HV*V0*Q3,
  P3+TV*V1*Q3,P4+TV*V1*Q3,P5+NV*V1*Q3,P5+HV*V1*Q3,
  P3+TV*V2*Q3,P4+TV*V2*Q3,P5+NV*V2*Q3,P5+HV*V2*Q3,
  P3+TV*V3*Q3,P4+TV*V3*Q3,P5+NV*V3*Q3,P5+HV*V3*Q3,S)

}
#end
