#ifndef(GrebHand)

#local C=(sqrt(2)-1)*4/3;
#local S=3-Test;

#local C0=<1,1,0>;
#local C1=<1,1,C>;
#local C2=<C,C,1>;
#local C3=<0,0,1>;

#local VS=vnormalize(<2,1,0>);
#local VE=vnormalize(<2,-1,0>);

#local P0=< 0,0,0>-2.5*VS;
#local P1=< 0,0,0>-2.5*C*VS;
#local P2=< 0,0,0>;
#local P3=< 0,0,0>+6*VS;
#local P4=<25,0,0>-6*VE;
#local P5=<25,0,0>;
#local P6=<25,0,0>+.5*C*VE;
#local P7=<25,0,0>+.5*VE;

#local R0=<-1/sqrt(5), 2/sqrt(5), .5>*.01;
#local R1=<-1/sqrt(5), 2/sqrt(5), .5>*C*2;
#local R2=<-1/sqrt(5), 2/sqrt(5), .5>*2;
#local R5=< 1/sqrt(5), 2/sqrt(5), .5>*.05;
#local R6=< 1/sqrt(5), 2/sqrt(5), .5>*C*.05;
#local R7=< 1/sqrt(5), 2/sqrt(5), .5>*.01;

#declare GrebHand=mesh {

#local Count=0; #while(Count<4)

#switch (Count)
#case(0) #local Q=<-1,-1,-1>; #break
#case(1) #local Q=<-1,-1, 1>; #break
#case(2) #local Q=< 1, 1, 1>; #break
#case(3) #local Q=< 1, 1,-1>; #break
#end

Bicubic(
  P0+R0*C0*Q,P0+R0*C1*Q,P0+R0*C2*Q,P0+R0*C3*Q,
  P0+R1*C0*Q,P0+R1*C1*Q,P0+R1*C2*Q,P0+R1*C3*Q,
  P1+R2*C0*Q,P1+R2*C1*Q,P1+R2*C2*Q,P1+R2*C3*Q,
  P2+R2*C0*Q,P2+R2*C1*Q,P2+R2*C2*Q,P2+R2*C3*Q,S)

Bicubic(
  P2+R2*C0*Q,P2+R2*C1*Q,P2+R2*C2*Q,P2+R2*C3*Q,
  P3+R2*C0*Q,P3+R2*C1*Q,P3+R2*C2*Q,P3+R2*C3*Q,
  P4+R5*C0*Q,P4+R5*C1*Q,P4+R5*C2*Q,P4+R5*C3*Q,
  P5+R5*C0*Q,P5+R5*C1*Q,P5+R5*C2*Q,P5+R5*C3*Q,S)

Bicubic(
  P5+R5*C0*Q,P5+R5*C1*Q,P5+R5*C2*Q,P5+R5*C3*Q,
  P6+R5*C0*Q,P6+R5*C1*Q,P6+R5*C2*Q,P6+R5*C3*Q,
  P7+R6*C0*Q,P7+R6*C1*Q,P7+R6*C2*Q,P7+R6*C3*Q,
  P7+R7*C0*Q,P7+R7*C1*Q,P7+R7*C2*Q,P7+R7*C3*Q,S)

#local Count=Count+1; #end
}

#declare l_GrebHand=20;
#end
