#macro Intersect(va,vb)
  #local det=va.x*vb.z-va.z*vb.x;
  #local va2=vdot(va,va);
  #local vb2=vdot(vb,vb);
  <(va2*vb.z-vb2*va.z)/det,0,(va.x*vb2-vb.x*va2)/det>
#end

#macro Voronoi(Start,End,DivX,DivZ,Edge,Texture)

#local S=seed(0);
#local yMax=max(Start.y,End.y);
#local xMin=min(Start.x,End.x);
#local yMin=min(Start.y,End.y);
#local zMin=min(Start.z,End.z);
#local xLen=abs(Start.x-End.x);
#local zLen=abs(Start.z-End.z);

#local Center=array[DivX][DivZ]

#local I=0; #while(I<DivX)
#local J=0; #while(J<DivZ)
  #local xX=rand(S)*.4+.3;
  #local zZ=rand(S)*.4+.3;
  #if(I=0 | (I=DivX-1)) #local xX=.5; #end
  #if(J=0 | (J=DivZ-1)) #local zZ=.5; #end

  #local xX=(xX+I)*xLen/DivX+xMin;
  #local zZ=(zZ+J)*zLen/DivZ+zMin;

  #local Center[I][J]=<xX,0,zZ>;
#local J=J+1; #end
#local I=I+1; #end

#local I=0; #while(I<DivX)
#local J=0; #while(J<DivZ)

#if (I=0)
  #local vG=-x*xLen/DivX/2;
#else
  #local vG=(Center[I-1][J]-Center[I][J])/2;
#end

#if (I=DivX-1)
  #local vC= x*xLen/DivX/2;
#else
  #local vC=(Center[I+1][J]-Center[I][J])/2;
#end

#if (J=0)
  #local vE=-z*zLen/DivZ/2;
#else
  #local vE=(Center[I][J-1]-Center[I][J])/2;
#end

#if (J=DivZ-1)
  #local vA= z*zLen/DivZ/2;
#else
  #local vA=(Center[I][J+1]-Center[I][J])/2;
#end

#if (I=0 | J=0)
  #local vF=<-xLen/DivX,0,-zLen/DivZ>*2;
#else
  #local vF=(Center[I-1][J-1]-Center[I][J])/2;
#end

#if (I=DivX-1 | J=0)
  #local vD=< xLen/DivX,0,-zLen/DivZ>*2;
#else
  #local vD=(Center[I+1][J-1]-Center[I][J])/2;
#end

#if (I=0 | J=DivZ-1)
  #local vH=<-xLen/DivX,0, zLen/DivZ>*2;
#else
  #local vH=(Center[I-1][J+1]-Center[I][J])/2;
#end

#if (I=DivX-1 | J=DivZ-1)
  #local vB=< xLen/DivX,0, zLen/DivZ>*2;
#else
  #local vB=(Center[I+1][J+1]-Center[I][J])/2;
#end

intersection {
  plane { y,yMax }
  plane {-y,-yMin }

#if(vdot(vA,Intersect(vH,vB))>vdot(vA,vA))
  plane { vA,0 translate vA }
  plane { vnormalize(vA)+y,-Edge/2 translate vA+y*yMax }
#end

#if(vdot(vB,Intersect(vA,vC))>vdot(vB,vB))
  plane { vB,0 translate vB }
  plane { vnormalize(vB)+y,-Edge/2 translate vB+y*yMax }
#end

#if(vdot(vC,Intersect(vB,vD))>vdot(vC,vC))
  plane { vC,0 translate vC }
  plane { vnormalize(vC)+y,-Edge/2 translate vC+y*yMax }
#end

#if(vdot(vD,Intersect(vC,vE))>vdot(vD,vD))
  plane { vD,0 translate vD }
  plane { vnormalize(vD)+y,-Edge/2 translate vD+y*yMax }
#end

#if(vdot(vE,Intersect(vD,vF))>vdot(vE,vE))
  plane { vE,0 translate vE }
  plane { vnormalize(vE)+y,-Edge/2 translate vE+y*yMax }
#end

#if(vdot(vF,Intersect(vE,vG))>vdot(vF,vF))
  plane { vF,0 translate vF }
  plane { vnormalize(vF)+y,-Edge/2 translate vF+y*yMax }
#end

#if(vdot(vG,Intersect(vF,vH))>vdot(vG,vG))
  plane { vG,0 translate vG }
  plane { vnormalize(vG)+y,-Edge/2 translate vG+y*yMax }
#end

#if(vdot(vH,Intersect(vG,vA))>vdot(vH,vH))
  plane { vH,0 translate vH }
  plane { vnormalize(vH)+y,-Edge/2 translate vH+y*yMax }
#end

 bounded_by { cylinder { y*yMin,y*yMax,1 scale <xLen/DivX,1,zLen/DivZ> } }

  translate Center[I][J]
  texture { Texture finish { ambient .1 diffuse .8+.2*rand(S) } }
}

#local J=J+1; #end
#local I=I+1; #end

#end
