#include "metals.inc"

#render concat( "ufo clock value currently " , str(ufo_clock,-1,5) , ".\n" )

#declare matt_black=
  texture {
    pigment {
      color rgb<0,0,0>
    }
    finish {
      ambient 0
      diffuse 0
    }
  }
   
#declare color_wheel_top=
  texture {
    pigment {
      radial
      color_map {
        [ 0     color rgb<1,0,0> ]
        [1/6    color rgb<.8,.8,0> ]
        [2/6    color rgb<0,.8,0> ]
        [3/6    color rgb<0,.8,1> ]
        [4/6    color rgb<0,0,1> ]
        [5/6    color rgb<1,0,1> ]
        [6/6    color rgb<1,0,0> ]
      }
    }
    finish { 
      ambient 1//AMB
      roughness .001
      specular .8
    }
    rotate <0,ufo_clock*360,0>
  }
  
#declare pan_color_top=
  texture {
    pigment {
      radial
      frequency 6
      color_map {
        [0         color rgb<0,0,0> ]
        [0.02      color rgb<0,0,0> ]
        [0.02      color rgb <0.91, 0.95, 0.91> ]
        [1         color rgb <0.91, 0.95, 0.91> ]
      }   
    }
    finish {
      ambient AMB //.25 //.3
      brilliance 4      // 3
      diffuse 0.5       // .4
      metallic
      specular 0.80     // .7
      roughness 1/80    // 1/60
      reflection 0.5    //.25
    }
    rotate <0,-ufo_clock*360,0>
  }


#declare ufo_top=
  intersection {      
    sphere { 0,10       
      texture { pan_color_top }
    }
    cone { <0,0,0>,9.5,<0,11,0>,13
      texture { color_wheel_top }
    }
    box { <-11,0,-11>,<11,11,11> 
      texture { matt_black }
    }                 
    scale <1,.2,1>    
    translate <0,.2,0>
  }

#declare ufo_base=
  object { ufo_top scale <1,-1,1> } //rotate <180,0,0> }   // n.b. scale <1,-1,1> to keep pan rotation same top and bottom
  
#declare ufo_middle=
  object {
    cylinder { <0,.2,0>,<0,-.2,0>,9.5 }
    texture { 
      pigment { 
        color rgb<1,1,1>
      } 
      finish { 
        ambient 1
      }
    }
    no_shadow
  }
                        
#declare ufo_light=
  union {
    light_source { <0,0,0> color .8*(ufo_lamp_switch) }//<0,.0285,3.9> }
    difference {
      cylinder { < 0,0,-1>,<0,0,(ufo_lamp_slide)>,.6 }
      cylinder { < 0,0,-1>,<0,0,(ufo_lamp_slide)>,.5 translate <0,0,.5> }
      texture { pigment { color rgb<0,0,0> } }
    }         
    translate <0,0,-ufo_lamp_slide>
    scale .1
    rotate <15,0,0>
    translate <0,0,9.5>
    //translate (ufo_cam_pos) //translate (ufo_lamp_slide)
  }
    
     
#declare ufo=
  union {
    object { ufo_top }
    object { ufo_base }    
    object { ufo_middle }
    #if (ufo_lamp_switch!=0)
      object { ufo_light }
    #end
    scale .4
  }
