// POV-Ray 2.0 sample data file written by Alexander Enzmann
#include "colors.inc"           // Standard colors library
#include "shapes.inc"           // Commonly used object shapes
#include "textures.inc"         // LOTS of neat textures.  Lots of NEW textures.
#include "stones.inc"

global_settings {
  max_intersections 200
}
#declare AMB=.4;

//#include "flight_macros.inc"
#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end                          
#macro move_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock,default_val)
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock < start_clock )
    ( default_val )
  #end
  #if ( current_clock > end_clock )
    ( default_val )
  #end
  #if ( ( current_clock >= start_clock ) & ( current_clock <= end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end

#declare second=clock;
#declare scene_clock=clock;
#while (scene_clock>1)
  #declare scene_clock=scene_clock-1;
#end

#declare ufo_cam_pos=<0,5,-11.5>; 
//#declare ufo_lamp_slide=<0,0,0>;
#declare ufo_lamp_switch=0;

#declare f_clock=0;                                                          
 #declare fish_mouth=0;
 #declare shock=on;
 #declare eyelid=0;  
 #declare iris=1;
 #declare eye_down=0;
 #declare head_dip=0;
 #declare head_tilt_right=0;
 #declare sympathy_twist=10; 
 #declare blind_upperbreak=0;
 #declare blind_lowerbreak=0;
 #declare swim_power=0;
 #declare view=1;
 #declare fish_pos=<0,3,0>;
 #declare fish_elevation=0;
 #declare fish_downright=0;
 #declare fish_right=0;

#declare rf_downplane=0;        // right fin downplane angle (sub-talk)
#declare lf_downplane=0;        // left fin downplane angle 
#declare rf_down=0;             // right fin 
#declare lf_down=0;             // left fin 
#declare rf_back=10;             // right fin rearward angle (swingwing) typ -10 to +20
#declare lf_back=10;             // left fin rearward angle (swingwing) typ -10 to +20


// first fifteen seconds - ufo drops in sky outside, and comes into room on smooth curve.

// at 4.0 and 4.4 seconds into anim, it will push blinds apart to allow entry.
#if ((clock>4.4) & (clock<6.0))
  #declare blind_upperbreak=sin(pi*(clock-4.4)/(6.0-4.4));
#end
#if ((clock>4.0) & (clock<5.6))
  #declare blind_lowerbreak=sin(pi*(clock-4.0)/(5.6-4.0));
#end                                               

#declare ufo_cam_pos=<47,29,-15>;
#declare ufo_cam_pos=(flight_spline ( (ufo_cam_pos),<47,7,-15>,<29,15,-9>,<22,15,-9>,0,5,clock) );
#declare ufo_cam_pos=(flight_spline ( (ufo_cam_pos),<17,15,-9>,<10,10,5>,<10,8,-5>,5,10,clock) );
#declare ufo_cam_pos=(flight_spline ( (ufo_cam_pos),<10,6,-15>,<0,5.8,-11.5>,<0,5.8,-10.5>,10,15,clock) );
 

 
#if (second>=15)
 #declare view=2;               // t+15 seconds - reset camera angle to view from within ufo 
 #declare ufo_cam_pos=<0,6,-12>;// and reset position to re-run these frames from in ufo camera
#end 

#declare ufo_cam_pos=(flight_spline ( (ufo_cam_pos),<0,5.8,-11.5>,<0,5.8,-10.2>,<0,5.8,-10>,15,19.5,clock) );
#declare ufo_lamp_switch=(flight_spline( 0,0,1,1,16,19,clock) );
//#declare ufo_lamp_slide=(flight_spline ( <0,0,0>,<0,0.02,3.5>,<0,0.035,3.85>,<0,.035,3.9>,17,20,clock) );
#declare ufo_lamp_slide=(flight_spline ( 4,1.5,.75,.25,17,25,clock) );


// Aaah, he's waking up, look he's yawning, isnt that cute.

#declare fish_mouth=0;
#declare fish_mouth=(move_spline(0,.5,1,1,21,22,clock,fish_mouth) );
#declare fish_mouth=(move_spline(1,1,1,1,22,22.5,clock,fish_mouth) );
#declare fish_mouth=(move_spline(1,1,.5,0,22.5,23.5,clock,fish_mouth) );

#declare fish_mouth=(move_spline(0,1,1,0,23.5,24,clock,fish_mouth) );
#declare fish_mouth=(move_spline(0,.7,.7,0,24,24.5,clock,fish_mouth) );

// He's opening his little eyes - isn't he sweet.

#declare eyelid=0;
#declare eyelid=(move_spline(0,1,1,0,23.5,24,clock,eyelid) );
#declare eyelid=(move_spline(0,1,1,0,24.5,25.5,clock,eyelid) );
#if (clock>26.8)
  #declare eyelid=1;
#end

//      AAAAAAAHHHHHH  U F O !
        
#if (clock>26.9)
  #declare iris=.05;
#end
#declare eyelid=(move_spline(0,.7,1,1,26.8,27,clock,eyelid) );
#declare iris=(move_spline(1,1,.05,.05,26.8,27,clock,iris) );

//      Quick - reverse gear and start backing up.
//      movement spline will back the fish up at the same time as raising his elevation in the water,
//      and dropping his eyes to match. Head also drops slightly.
//      end of motion at clock 34. at this point he is looking over the top of the bridge.
#if (clock>27)
 #declare f_clock=-clock;       // engage reverse gear, full revs.
#end         
#if (clock>29)
  #declare swim_power=2;        
#end
#declare swim_power=(move_spline(0,0,2,2,27,29,clock,swim_power) );     // double-speed (reverse)
#if (clock>=34)
  #declare fish_pos=<0,5.25,2.3>;
  #declare fish_elevation=35;
  #declare eye_down=35;
  #declare head_dip=25;
#end
#declare fish_pos=(move_spline(<0,3,0>,<0,3,0>,<0,3,2.3>,<0,5.25,2.3>,28,34,clock,fish_pos) );
#declare fish_elevation=(move_spline(0,0,20,35,28,34,clock,fish_elevation) );
#declare eye_down      =(move_spline(0,0,20,35,28,34,clock,eye_down) );
#declare head_dip      =(move_spline(0,0,15,25,28,34,clock,head_dip) ); 

#declare lf_down=(flight_spline(lf_down,0,-10,-20,30,31,clock) );         // flippers up
#declare rf_down=(flight_spline(rf_down,0,-10,-20,30,31,clock) );

#declare lf_downplane=(flight_spline(lf_downplane,0,10,20,30,31,clock) ); // angle bowplanes
#declare rf_downplane=(flight_spline(rf_downplane,0,10,20,30,31,clock) );

//at t=32, stop paddling backwards or you'll hit the back of the tank.

#declare swim_power=(flight_spline(swim_power,2,1,0,31,32,clock) );
#if (clock>32)
 #declare f_clock=clock/2;      //      reverse engines - all ahead half revs.
#end
#declare swim_power=(flight_spline(swim_power,0,.25,.25,32,34,clock) );   // quarter speed (forward)

#declare lf_down=(flight_spline(lf_down,0,10,20,31,33,clock) );           // thrust up
#declare rf_down=(flight_spline(rf_down,0,10,20,31,33,clock) );

#declare sympathy_twist=(flight_spline(sympathy_twist,sympathy_twist,25,25,32.5,33,clock) ); // switch on helpless look while behind bridge.

#declare lf_downplane=(flight_spline(lf_downplane,0,0,0,34,35,clock) );   // and relax back
#declare rf_downplane=(flight_spline(rf_downplane,0,0,0,34,35,clock) );   // to 'normal' 
#declare lf_down=(flight_spline(lf_down,0,0,0,34,35,clock) );             // settings while
#declare rf_down=(flight_spline(rf_down,0,0,0,34,35,clock) );             // behind bridge

// at 35 seconds, fish is hidden behind bridge. Over the next 5 seconds, he will blink thrice, and his iris will open back up to normal

#declare eyelid=(flight_spline(eyelid,1,0,0,35,35.15,clock) );            // blinking 3 times
#declare sympathy_twist=(flight_spline(sympathy_twist,sympathy_twist,20,20,35.1,35.2,clock) ); 
#declare iris=(flight_spline(iris,.05,.2,.2,35.1,35.2,clock) );
#declare eyelid=(flight_spline(eyelid,0,1,1,35.15,35.3,clock) );

#declare eyelid=(flight_spline(eyelid,1,0,0,37,37.2,clock) );            // slightly slower
#declare sympathy_twist=(flight_spline(sympathy_twist,sympathy_twist,15,15,37.15,37.25,clock) ); 
#declare iris=(flight_spline(iris,.2,.7,.7,37.15,37.25,clock) );
#declare eyelid=(flight_spline(eyelid,0,1,1,37.2,37.4,clock) );          // each time

#declare head_tilt_right=(flight_spline(head_tilt_right,head_tilt_right,15,15,37,37,clock) );
#declare eyelid=(flight_spline(eyelid,1,0,0,39,39.3,clock) );
#declare sympathy_twist=(flight_spline(sympathy_twist,sympathy_twist,10,10,39.25,39.35,clock) ); 
#declare iris=(flight_spline(iris,.7,1,1,39.25,39.35,clock) );
#declare eyelid=(flight_spline(eyelid,0,1,1,39.3,39.6,clock) );
#declare head_tilt_right=(flight_spline(head_tilt_right,head_tilt_right,0,0,39,40,clock) );

// start the motors up and dive at 40 secs, swim under the bridge

#declare swim_power=(flight_spline(swim_power,.25,.75,1,41,45,clock) );                       

#declare fish_pos=(flight_spline (fish_pos,<0,5.25,2.3>,<0,3,2.3>,<0,3,1>,41,45,clock) );
#declare head_dip=(flight_spline (head_dip,0,0,15,41,50,clock) );                    // 25 - 0 - 35
#declare fish_elevation=(flight_spline (fish_elevation,-25,0,30,41,50,clock) );      // 35 - 0 - 50
#declare eye_down=(flight_spline (eye_down,-10,-15,35,41,50,clock) );                // 35 - 0 - 55

// t+45 (-1)    set fins for bank left, followed by bank right.
//              syncronize the fish to bank left, then straighten. 
//              fish also must rotate left, and slide that way.
//#declare rf_downplane=(flight_spline (rf_downplane,-30,30,0,44,49,clock) );
//#declare lf_downplane=(flight_spline (lf_downplane,30,-30,0,44,49,clock) );
#declare fish_downright=(flight_spline (fish_downright,-10,-10,10,45,50,clock) );
#declare fish_right=(flight_spline (fish_right,-20,-20,0,45,50,clock) );
#declare fish_pos=(flight_spline (fish_pos,<0,3,-1.3>,<1.5,4,-2.5>,<.5,4.5,-3.0>,45,50,clock) );

// 50-55 backpaddle to treading water state
#if ( (clock>=45) ) //& (clock <=55) )
  #declare bp_freq=clock;
  #declare bp_mag=0;

  #declare bp_mag=(flight_spline(bp_mag,0,10,10,46,48,clock));       // start
  #declare bp_mag=(flight_spline(bp_mag,10,5,5,50,55,clock));   // stop
  #declare lf_downplane=-bp_mag-bp_mag*cos(bp_freq*2*pi);
  #declare lf_back=-2*bp_mag*sin(bp_freq*2*pi);
  #declare rf_downplane=-bp_mag-bp_mag*cos(bp_freq*2*pi);
  #declare rf_back=-2*bp_mag*sin(bp_freq*2*pi);
#end                                          

#declare swim_power=(flight_spline(swim_power,.75,.45,.35,50,55,clock) );        // ease off paddle power

#declare head_dip=(flight_spline (head_dip,20,25,35,50,55,clock) );                // 25 - 0 - 35
#declare fish_elevation=(flight_spline (fish_elevation,35,40,50,50,55,clock) );    // 35 - 0 - 50
#declare eye_down=(flight_spline (eye_down,40,50,55,50,55,clock) );                // 35 - 0 - 55
#declare fish_pos=(flight_spline (fish_pos,<-.5,5,-3.5>,<-.5,4.5,-3>,<0,5,-3>,50,55,clock) );    
#declare fish_downright=(flight_spline (fish_downright,0,-10,0,50,55,clock) );

#declare eyelid=(flight_spline(eyelid,1,0,0,54,54.25,clock) );           // blink
#declare eyelid=(flight_spline(eyelid,0,1,1,54.25,54.5,clock) );         // cont.       

// 55 - 65 bob about a bit. 
//      still at 35% swim power (thrust)
//      5 degrees of flipper flap (technical term there !)
//      in a semi-upright attitude.
          
#declare fish_elevation=(flight_spline (fish_elevation,49,41,40,57,59,clock) );    // fix to stop tail burying          
#declare fish_elevation=(flight_spline (fish_elevation,41,49,50,59,61,clock) );    // fix to stop tail burying          
#declare eye_down=(flight_spline (eye_down,54,41,40,57,59,clock) );
#declare eye_down=(flight_spline (eye_down,41,54,55,59,61,clock) );
#declare fish_pos=(flight_spline (fish_pos,<.5,5.5,-3>,<.5,4.35,-3>,<0,4.85,-3>,55,60,clock) );
#declare head_tilt_right=(flight_spline(head_tilt_right,head_tilt_right,15,15,54,58,clock) );

#declare eyelid=(flight_spline(eyelid,1,0,0,55.5,55.75,clock) );           // blink
#declare eyelid=(flight_spline(eyelid,0,1,1,55.77,56,clock) );             // cont.       

#declare head_tilt_right=(flight_spline(head_tilt_right,head_tilt_right,0,0,59,60,clock) );

#declare eyelid=(flight_spline(eyelid,1,0,0,57,57.25,clock) );           // blink
#declare eyelid=(flight_spline(eyelid,0,1,1,57.27,57.5,clock) );         // cont.       

#declare fish_pos=(flight_spline (fish_pos,<-.5,5.35,-3>,<-.5,4.75,-3>,<0,5,-3>,60,65,clock) );
#declare head_rise=0;
#declare eye_right=0;
#if(clock>80)
  #declare fish_elevation=30;
  #declare eye_down=30;
  #declare fish_right=-85;
  #declare head_dip=15;
  #declare head_rise=-20;
#end

#declare eye_right=(flight_spline(eye_right,eye_right,30,30,82,83,clock) );
#declare eye_right=(flight_spline(eye_right,eye_right,0,0,88,89,clock) );

#declare fish_downright=(flight_spline(fish_downright,fish_downright,20,20,83,85,clock) );
#declare fish_right=(flight_spline(fish_right,fish_right,0,0,84,90,clock) );          
#declare fish_downright=(flight_spline(fish_downright,fish_downright,-10,0,89,91,clock) );

#declare eyelid=(flight_spline(eyelid,1,0,0,90,90.25,clock) );           // blink
#declare eyelid=(flight_spline(eyelid,0,1,1,90.27,90.5,clock) );         // cont.  
                                                                                              
#declare eyelid=(flight_spline(eyelid,1,0,0,93,93.25,clock) );           // blink
#declare eyelid=(flight_spline(eyelid,0,1,1,93.27,93.5,clock) );         // cont.  

/*
#declare f_count=45;
#while (f_count<65.01)
 sphere { (flight_spline (<0,3.5,1>,<0,3,-1.3>,<1.5,4,-2.5>,<.5,4.5,-3.0>,45,50,f_count)),.05 texture { pigment { color rgb<1,1,1> } finish { ambient 1 } } }
 sphere { (flight_spline (<.5,4.5,-3.0>,<-.5,5,-3.5>,<-1,4,-3>,<0,5,-3>,50,55,f_count)),.05 texture { pigment { color rgb<1,1,0> } finish { ambient 1 } } }
 sphere { (flight_spline (<0,5,-3>,<1,6,-3>,<1,4.35,-3>,<0,4.85,-3>,55,60,f_count)),.05 texture { pigment { color rgb<1,.5,0> } finish { ambient 1 } } }
 sphere { (flight_spline (<0,4.85,-3>,<-1,5.35,-3>,<-.5,4.75,-3>,<0,5,-3>,60,65,f_count)),.05 texture { pigment { color rgb<1,0,0> } finish { ambient 1 } } }
 #declare f_count=f_count+.2;
#end 
*/

#if (clock>(95+1/32))
  #declare view=1;
  #declare fish_pos=<0,5,-3.5>;
  #declare ufo_pos=<0,5.8,-10.5>;
  #declare f_clock=clock*2;
#end

#declare b_cl=110-clock;
// at 4.0 and 4.4 seconds into anim, it will push blinds apart to allow entry.
#if ((b_cl>4.4) & (b_cl<6.0))
  #declare blind_upperbreak=sin(pi*(b_cl-5.4)/(6.0-104.4));
#end
#if ((b_cl>4.0) & (b_cl<5.6))
  #declare blind_lowerbreak=sin(pi*(b_cl-4.0)/(5.6-4.0));
#end                                               

#declare lf_downplane=(flight_spline(lf_downplane,lf_downplane,0,0,95,100,clock) );
#declare lf_back=(flight_spline(lf_back,lf_back,0,0,95,100,clock) );
#declare rf_downplane=(flight_spline(rf_downplane,rf_downplane,0,0,95,100,clock) );
#declare rf_back=(flight_spline(rf_back,rf_back,0,0,95,100,clock) );

#declare ufo_cam_pos=(flight_spline ( (ufo_cam_pos),<0,5.8,-11.5>,<10,6,-15>,<10,8,-5>,95,100,clock) );
#declare ufo_cam_pos=(flight_spline ( (ufo_cam_pos),<10,10,5>,<17,15,-9>,<22,15,-9>,100,105,clock) );
#declare ufo_cam_pos=(flight_spline ( (ufo_cam_pos),<29,15,-9>,<47,7,-15>,<47,29,-15>,105,110,clock) );
#declare ufo_lamp_switch=(flight_spline( 1,1,0,0,95,100,clock) );
#declare ufo_lamp_slide=(flight_spline ( .25,.75,1.5,4,95,100,clock) );

#declare head_dip=(flight_spline(head_dip,head_dip,0,0,95,97,clock) );
#declare head_rise=(flight_spline(head_rise,head_dip,0,0,95,97,clock) );               
#declare eye_down=(flight_spline(eye_down,eye_down,0,0,95,98,clock) ); 
#declare fish_elevation=(flight_spline(fish_elevation,fish_elevation,0,0,95,98,clock) );              

#declare swim_power=(flight_spline(.35,1.2,.75,.65,95,100,clock) );
#declare fish_downright=(flight_spline(fish_downright,fish_downright,30,30,95,98,clock) );

#declare fish_right=(flight_spline(fish_right,5,160,180,95,100,clock) );
#declare fish_right=(flight_spline(fish_right,200,355,360,100,105,clock) );
#declare fish_pos=(flight_spline(fish_pos,<-2,5,-3>,<-3,4.5,-1>,<-3,4,2>,95,101,clock) );

#declare fish_downright=(flight_spline(fish_downright,fish_downright,0,0,99,102,clock) );
#declare fish_pos=(flight_spline(fish_pos,<0,3,3>,<0,3,0>,<0,3,0>,105,107,clock) );
#declare swim_power=(flight_spline(swim_power,0,0,0,106,107,clock) );
#declare eyelid=(flight_spline(eyelid,eyelid,0,0,106,109,clock) );
 
  
//#declare view=0        //      dev only at this point
#if (view=0)   //       dev camera
camera {
   //location  <23,15, -22>
   location <-8,7,3>
   direction <0, 0, 1.45>
   up <0,1,0>
   right <4/3,0,0>
   //look_at   <23, 15, -9>
   look_at (fish_pos) //<0,3,-2>
}
#end
#declare tank_type=1;   // normal - glass with water in    
#if (view=1)    //      scene 1 camera (static room-cam)  
camera {
   location  <-15,6, -9>
   //location  <0,15, -22.1>
   direction <0, 0, 1.45>
   up <0,1,0>
   right <4/3,0,0>
   look_at   <20, 6, -2>
   #declare tank_type=3;        // glass - no water !
}
#end
#if (view=2)    //      scaene 2 camera (dynamic ufo-cam)
camera {
   location <.001,0,-.01>
   //location  <0,15, -22.1>
   direction <0, 0, 1.45>
   up <0,1,0>
   right <4/3,0,0>      
   look_at   <0, -1, 10>
   translate ufo_cam_pos
   translate <0,-.77,2.8>
   //look_at   <20, 6, -3>
   //#declare tank_type=2;        //      quicker - water only.
   #declare tank_type=0;        // none
}
#end

//#declare tank_type=0;        //      no glass, no water

//light_source { <0, 19, 0> color rgb<.3,.3,.3> }       //      dev- room light
light_source { <54.5,26,-25> color rgb<.6,.6,.4> }        //      sodium (street lamp)
//sphere { <55,26,-25>,1 texture { pigment { color rgb<1,1,1> } finish { ambient 1 } } no_shadow } // visible street lamp

#render "\n"
#include "room.inc"
object { room }                   

#declare weed_clock=-clock*360/4;
#include "fishbowl.inc"
object { fishbowl }
// fake bowl (for checking fish movement stays in tank boundaries)
/*object {
  difference {
    union {
      difference {       
        sphere { 0,10.5 }
        sphere { 0,10 }  
        cylinder { <0,0,0>,<0,20,0>,5 }
      }
      torus { 5,1 translate <0,-10,0> }
      torus { 5,1 translate <0,10,0> }
    }
    box { <-20,-20,-20>,<-2,20,20> }
  }
  texture { 
    pigment { color rgb<1,1,1> } 
    finish { ambient .5 }
  }
  rotate <0,-40,0>
  translate <0,11.0001,0>
  scale <1,10/11,1>
  scale .5
}*/
                         
// set up fish vars                         
//#declare fish_right=90;
    
//#declare t_port_c1=(flight_spline(t_port_c1,0,1,1,3,8,clock) );
//#declare t_port_c1=(flight_spline(t_port_c1,1,0,0,19,24,clock) );
    
#declare t_port_clock=0;                                        
#declare t_port_clock=(flight_spline(t_port_clock,0,1,1,62,68,clock) ); //      2-8
#declare t_port_clock=(flight_spline(t_port_clock,1,0,0,79,85,clock) ); //      21-25
#if ((clock<68) | ((clock>80) & (clock<83.7)) )                 
#if ( t_port_clock>0 )
object {        //      teleport bubble - moving object with static texture.
                //      texture in turn is dynamic but relative to absolute 0, not bubble 0        
  //sphere { 0,1
  cylinder { <0,-2,0>,<0,1,0>,1
    scale <2,1,1.5>
    translate <.75,0,0>
    //rotate <fish_downright,0,0>
    rotate <0,-90,0> 
    //rotate <fish_elevation,0,0>
    rotate <0,fish_right,0>
    translate (fish_pos)  
  }
  
  texture { 
    pigment { 
      gradient y
      color_map {
        [ 0 color rgbf<1,1,1,0> ]
        [ .05 color rgbf<1,1,1,0> ]
        [ .1 color rgbf<1,1,1,1> ]
        [ 1 color rgbf<1,1,1,1> ]
      }                   
      scale <1,10,1>
      translate <0,t_port_clock*10,0>
    }
    finish {
      ambient 1
      diffuse 0
    }
  }
  no_shadow  
}
#end
#end
/*
#declare fish_mouth=0;
#declare shock=off;
#declare eyelid=1;
#declare eye_down=60;
#declare head_dip=45;
#declare head_tilt_right=20;
#declare sympathy_twist=00;
*/
//#include "gf_tele.inc" //"goldfish.inc"
#include "goldfish.inc"
#if ((clock<68) | ((clock>80) & (clock<83.7)) )                 
  difference {
#end
  object { fish 
    #if (clock>=15)
      scale .28 
    #else
      scale .3    //      make him slightly bigger in scene1
    #end
    rotate <fish_downright,0,0>
    rotate <0,-90,0> 
    rotate <fish_elevation,0,0>
    rotate <0,fish_right,0>
    translate (fish_pos)
  }
#if ((clock<68) | ((clock>80) & (clock<83.7)) )                 
  box { <-10,0,-10>,<10,t_port_clock*10,10> }
}
#end          
  
//      closest pos= object { fish scale .3 rotate <0,-90,0> rotate <55,0,0> translate <0,5,-3> }



#declare ufo_clock=clock/2;
#include "ufo.inc"
object { ufo translate (ufo_cam_pos) }      

/*
#declare this_clock=0;
union {
#while (this_clock<=2)

    sphere { (flight_spline ( <47,29,-15>,<47,7,-15>,<29,15,-9>,<22,15,-9>,0,1,this_clock) ), .1 }
    sphere { (flight_spline ( <22,15,-9>,<17,15,-9>,<10,10,5>,<10,8,-5>,0,1,this_clock) ), .1 }
    //sphere { (flight_spline ( <10,8,-5>,<10,6,-15>,<0,5.8,-11.5>,<0,5.8,-10.5>,0,1,this_clock) ) , .1 }

  #declare this_clock=this_clock+(1/15*1/5);
#end
    texture { 
      pigment { 
        color rgb<1,1,1>
      } 
      finish { 
        ambient 1
      }
    }
  }
*/



                                        

#render concat( "Overall Scene clock value currently at " , str(clock,-1,5) , " seconds.\n" )