/*
 *
 * boid
 *
 */

import java.awt.*;
import java.io.*;

public class boid 
{
	public  int id;
	public point3d pos; 
	
	private point3d neighbours, newpos, attraction;
	private double[] distance;	//distance to neighbours;
	private double rotx, roty, rotz;
	private double phase, boidsize, school_radius;
	private int n1,n2,n3; //neighbourhood
	private int maxphase=14;

	public boid (int identity, int school_size, double boid_size, double radius) 
	{
			id=identity;
			distance = new double[school_size];
			boidsize=boid_size;
			pos = new point3d(0,0,0);
			newpos = new point3d(0,0,0);
			neighbours = new point3d(0,0,0);
			attraction = new point3d(0,0,0);
			rotx=roty=rotz=0;
			school_radius=radius;
	}

	public void init_pos (double x, double y, double z )
	{
		attraction.px=pos.px=x+((Math.random()-0.5)*3*boidsize);
		attraction.py=pos.py=y+((Math.random()-0.5)*3*boidsize);
		attraction.pz=pos.pz=z+((Math.random()-0.5)*4*boidsize);
		phase=(Math.random()*(double)maxphase);
		rotz=Math.random()*360;
	}

	public void type (Graphics g)
	{
		g.drawString("Boid-Pos [" + id + "]  " + pos.px + "  " + pos.py + "  " + pos.pz,20,30+id*15);
	}

	public void export (PrintStream ps)
	{
		String sx;
		String sy;
		String sz;
		ps.println("object { medusa" + Integer.toString((int)Math.floor(phase)));
		sx = Double.toString(rotx);
		sy = Double.toString(roty);
		sz = Double.toString(rotz);
		ps.println("   rotate     < " + sx +", " + sy +", " + sz +" > ");
		sx = Double.toString(pos.px);
		sy = Double.toString(pos.py);
		sz = Double.toString(pos.pz);
		ps.println("   translate  < " + sx +", " + sy +", " + sz +" >  }");
	}

	public void sense_distance (boid[] school)
	{
		int i;

		for (i=0;i<distance.length;i++)
		{
			distance[i] = school[i].pos.distance(pos);
		}

	}

	public void find_new_pos(point3d center, boid[] school, predator shark, double speed)
	{
		int i;
		double c_dist, n_dist, nh_dist, a_dist,	p_dist,
			   c_fact, n_fact, nh_fact, a_fact,	p_fact,
			   c_prio, n_prio, nh_prio, a_prio, p_prio;

		// find boids with smallest distance
		find_neighbours(school);

		// compute delta-vector	for predator
		p_dist=pos.distance(shark.curpos);
		p_prio=0;
		p_fact=1;
		if (p_dist < boidsize*6)
		{
			//increase distance
			p_prio=boidsize*6-p_dist;
			p_fact=(p_dist-(speed*4))/p_dist; // error if _dist==0
			if(p_fact<0) p_fact=0;
			p_fact=(-(1-p_fact));
		}

		// compute delta-vector	for nearest neighbour
		n_dist=distance[n1];
		n_prio=0;
		n_fact=1;
		if (n_dist < boidsize*4)
		{
			//increase distance
			n_prio=boidsize*4-n_dist;
			n_fact=(n_dist-(speed*2))/n_dist; // error if n_dist==0
			if(n_fact<0) n_fact=0;
			n_fact=(-(1-n_fact));
		}

		// compute delta-vector	for neighbours
		nh_dist=pos.distance(neighbours);
		nh_prio=0;
		nh_fact=1;
		if (nh_dist > boidsize*6)
		{
			//decrease distance
			nh_prio=nh_dist-boidsize*6;
			nh_fact=(nh_dist-speed)/nh_dist;
			if(nh_fact<0) nh_fact=0;
			nh_fact=1-nh_fact;
		}

		// compute delta-vector	for center
		c_dist=pos.distance(center);
		c_prio=0;
		c_fact=1;
		if (c_dist > school_radius)
		{
			//decrease distance
			c_prio=c_dist-school_radius;
			c_fact=(c_dist-speed)/c_dist;
			if(c_fact<0) c_fact=0;
			c_fact=1-c_fact;
		}

 		// compute delta-vector	for attraction
		a_dist=pos.distance(attraction);
		a_fact=1;
		if (a_dist < boidsize)
		{
			attraction.jitter(pos, 8*boidsize);
			a_dist=pos.distance(attraction);
		}
		//decrease distance
		a_fact=(a_dist-speed)/a_dist;
		if(a_fact<0) a_fact=0;
		a_fact=1-a_fact;


		// resolve priorities
		if (p_prio>0 && p_prio>boidsize)
		{
				newpos.moveto(pos,shark.curpos,p_fact);
				attraction=newpos;
		}
		else if (n_prio>0 && n_prio>boidsize)
		{
				newpos.moveto(pos,school[n1].pos,n_fact);
				attraction=newpos;
		}
		else if(nh_prio>c_prio && nh_prio>boidsize)
		{
				newpos.moveto(pos,neighbours,nh_fact);
				attraction=neighbours;
		}
		else if(c_prio>0 && c_prio>boidsize)
		{
				newpos.moveto(pos,center,c_fact);
				attraction=center;
		}
//		else newpos.moveto(pos,attraction,a_fact);
 		else newpos.moveto(pos,pos,0);

	}

	private void find_neighbours(boid[] school)
	{
		// find boids with smallest distance
		
		int near,i;
		double test_distance;

		near=-1;
		test_distance=10000000;
		for (i=0;i<distance.length;i++)
		{
			if (i!=id)
			{
			   if(distance[i]<test_distance)
			   {
				   near=i;
				   test_distance=distance[i];
			   }
			}
		}
		n1=near;

		near=-1;
		test_distance=10000000;
		for (i=0;i<distance.length;i++)
		{
			if (i!=id && i!=n1)
			{
			   if(distance[i]<test_distance)
			   {
				   near=i;
				   test_distance=distance[i];
			   }
			}
		}
		n2=near;

 		near=-1;
		test_distance=10000000;
		for (i=0;i<distance.length;i++)
		{
			if (i!=id && i!=n1 && i!=n2)
			{
			   if(distance[i]<test_distance)
			   {
				   near=i;
				   test_distance=distance[i];
			   }
			}
		}
		n3=near;

		neighbours.px=(school[n1].pos.px + school[n2].pos.px + school[n3].pos.px)/3;
		neighbours.py=(school[n1].pos.py + school[n2].pos.py + school[n3].pos.py)/3;
		neighbours.pz=(school[n1].pos.pz + school[n2].pos.pz + school[n3].pos.pz)/3;

	}

	public void moveto_new_pos()
	{
		double dx=newpos.px-pos.px;
		double dy=newpos.py-pos.py;

//		rotx=dx*(-60);
//		roty=dy*(-60);
		rotx=roty=0;
		rotz+=5;

		pos.px=newpos.px;
		pos.py=newpos.py;
		pos.pz=newpos.pz;

		phase+=0.25;
		if((int)phase>maxphase)phase=0;
	}
	
}