
// Fish.c	-	Schooling fish modeller.

//	(C) 1996, 1999 Michael Devine



#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <math.h>
#include "..\gfx.h"
#include <time.h>
#include <values.h>

#define X 0
#define Y 1
#define Z 2


#define NFISH 160

#define NNEIGHBORS 10

#define NAXIS 3

#define STEPS_PER_FRAME 3


int DoRandom = 0;
int DoRender = 1;
int NFrames = -1;
int POV_FrameNum = 0000;

//==== Structures... ====

struct fish_type {
	double pos[NAXIS];
	double vel[NAXIS];
	double acc[NAXIS];
//	double velold[NAXIS];
	double velavg[NAXIS];
	double veloldavg[NAXIS];

	int neighbors[NNEIGHBORS];
};


struct fish_type fish[NFISH];
double OldCamera[NAXIS+3];


#define THRESHOLD_DIST 0.25
#define TOO_CLOSE_DIST (THRESHOLD_DIST*THRESHOLD_DIST * 1.0)
#define ATTRCT_CURVE_FACTOR 0.5
#define REPULSION_MODERATOR 0.5
double influence(double dist)
{

/*	if (dist > 2*THRESHOLD_DIST)
		return 0.0;
	else*/ if (dist < THRESHOLD_DIST)
		return -1.0/(dist+REPULSION_MODERATOR) + 1.0/(THRESHOLD_DIST+REPULSION_MODERATOR);
	else
		return ATTRCT_CURVE_FACTOR*(dist - THRESHOLD_DIST)*(dist - THRESHOLD_DIST);
}

void init_fish(void);
void update_neighbors(void);
void render_fish(float clock);
double dist2(int f1, int f2);
void update_physics(void);
int parse_cmd_line(int argc, char **argv);
void write_fish(int clock);
void save_state(void);
void load_state(void);




float vlen(float x, float y, float z);

//#define DEBUG




int main(int argc, char **argv)
{
	int x, y;
	int clock = 0;
	int f;


	long int startt, endt;


	parse_cmd_line(argc, argv);

	//=== If NFrames > -1, then it was set in parse_cmd_line(), and we're
	//=== loading from a state file... init_fish() should not be called.
	//==== This is a disorganized hack.
	if (NFrames == -1)
		init_fish();


	if (DoRender) {
		setmode13();
		for (x=0;  x<256;  x++)
			palette(x, x>>2,x>>2,x>>2);
		palette(7, 63,63,63);
	}


	startt = time(0);
	//while ( !kbhit() && !(clock==NFrames) ) {
	while ( !kbhit() && (!(clock==STEPS_PER_FRAME) || NFrames==-1) ) {

		//update_neighbors();
		update_physics();

//		if ((clock & 0x07) == 7)
//			write_fish(clock);
		if (DoRender)
			render_fish(clock);
		else
			printf(".");
		if ((clock % STEPS_PER_FRAME) == STEPS_PER_FRAME-1)
			printf("%d\r", clock/STEPS_PER_FRAME);

		clock++;
	}

	write_fish(clock);

	save_state();

	//== Write final scene...
	//clock--;
	//write_fish(clock);

	//getche();
	//DoRandom = 1;
	endt = time(0);

	if (DoRender)
		setmode3();

	printf ( "Rendered %.0lf frames in %ld sec = %.2lf FPS\n", (double)clock, endt - startt, (double)clock/(endt - startt+0.00001) );

/*	for (f=0;  f<NFISH;  f++) {
		x = (int)(fish[f].pos[X] * 10.0) + 160;
		y = (int)(fish[f].pos[Y] * 10.0) + 100;
		printf("Fish %2d (%3d %3d) %f\n", f, x, y, (double)(rand()) / (double)RAND_MAX * 2.0 - 1.0);
	}
*/
	return 0;
}


void render_fish(float clock)
{

	int i;
	int f;
	int x, y;

	//= Clear screen.
	for (i=0;  i<32000;  i++)
		wscnbuf[i] = 0x0000;


	for (f=0;  f<NFISH;  f++) {

		x = (int)(fish[f].pos[X] * 40.0) + 160;
		y = (int)(fish[f].pos[Y] * 40.0) + 100;

		scnbuf[ x + ylu[y%200] ] = 255;

	}


	clock = clock;
}


//#define SQRT
#define SQRT sqrt

//float vlen(float x, float y, float z)
float vlen(float x, float y, float z)
{
//	float tmp = (x*x + y*y + z*z);
//	return sqrt_table[tmp / (float)SR_MAX * SR_T_MAX];
	return SQRT(x*x + y*y + z*z);
}












void init_fish()
{
	int f;
	int a, i;

//	int grid_num = (int)(sqrt(NFISH));

	for (f=0;  f<NFISH;  f++) {

		//== Random position...
		for (a=0;  a<NAXIS;  a++)
			fish[f].pos[a] = (double)(rand()) / (double)RAND_MAX * 2.0 - 1.0;

		//== Grid positions...
//		fish[f].pos[X] = (f / grid_num) * THRESHOLD_DIST - grid_num*THRESHOLD_DIST*0.5;
//		fish[f].pos[Y] = (f % grid_num) * THRESHOLD_DIST - grid_num*THRESHOLD_DIST*0.5;

		for (i=0;  i<NNEIGHBORS;  i++)
			fish[f].neighbors[i] = -1;

	}

	update_neighbors();

}


void update_neighbors()
{

	//==== Brute force insertion sort update the list of nearest
	//==== neighbors for each fish.

	int f, f2;
	int a;
	int i, idx;

	for (f=0;  f<NFISH;  f++) {

		for (f2=0;  f2<NFISH;  f2++) {

			if (f == f2)
				continue;

			//== Find position of f2 in f's list...
			idx = NNEIGHBORS;
			//= If f2 is closer...
			while (idx  &&  dist2(f, f2) < dist2(f, fish[f].neighbors[idx-1]) )
				idx--;

			//== idx is now the index where f2 should be inserted...
			for (i=NNEIGHBORS-1;  i>idx;  i--) {
				//== Move neighbor[i-1] down one...
				fish[f].neighbors[i] = fish[f].neighbors[i-1];
			}
			if (idx < NNEIGHBORS)
				fish[f].neighbors[idx] = f2;


		}
	}

}




double dist2(int f1, int f2)
{

	int a;

	double ret = 0.0;

	double tmp;

//	printf ( "Distance between %d and %d\n", f1, f2);
//	if (f1 == -1 || f2 == -1 )
	if (f2 == -1 )
		return MAXDOUBLE;

	for (a=0;  a<NAXIS;  a++) {
		tmp = fish[f2].pos[a] - fish[f1].pos[a];
		ret += tmp*tmp;
	}

	//return sqrt(ret);
	return ret;

}


void update_physics()
{

	int f, f2;
	int a;
	int i, idx;
	double scale;

	for (f=0;  f<NFISH;  f++) {

		//== Copy velocity vectors
		for (a=0;  a<NAXIS;  a++)
			fish[f].velavg[a] += fish[f].vel[a];


		//====  Maintain distance from rest of school...

		for (i=0;  i<NNEIGHBORS;  i++) {
			//== Move towards neighbor vector scaled by "influence".
			f2 = fish[f].neighbors[i];
			scale = influence( sqrt(dist2(f, f2)) );
			for (a=0;  a<NAXIS;  a++)
				fish[f].vel[a] += scale*(fish[f2].pos[a] - fish[f].pos[a]);
		}
/*		for (f2=0;  f2<NFISH;  f2++) {
			//== Move away from any other very close fishes.
			if ( f2 != f  &&  dist2(f,f2) < TOO_CLOSE_DIST ) {
				scale = 0.15 * influence( sqrt(dist2(f, f2)) );
				for (a=0;  a<NAXIS;  a++)
					fish[f].vel[a] += scale*(fish[f2].pos[a] - fish[f].pos[a]);
			}
		}
*/	}



	//=== Add random darting movements...
	if (DoRandom) {
#		define RAND_THRESH (RAND_MAX / 512)
#		define MAX_DART_VEL 0.1
		for (f=0;  f<NFISH;  f++) {
			if (rand() < RAND_THRESH) {
				for (a=0;  a<NAXIS;  a++)
					fish[f].vel[a] += (double)(rand()) / (double)RAND_MAX * 2.0 * MAX_DART_VEL - MAX_DART_VEL;
			}
		}
	}


	//==== Do basic physics...

	for (f=0;  f<NFISH;  f++) {

		for (a=0;  a<NAXIS;  a++)
			fish[f].pos[a] += fish[f].vel[a];
	}



	//=== Slow fish down...
#	define SLOWING_FACTOR 0.6
	for (f=0;  f<NFISH;  f++) {

		for (a=0;  a<NAXIS;  a++)
			fish[f].vel[a] *= SLOWING_FACTOR;
	}


}



int parse_cmd_line(int argc, char **argv)
{

	//=== Print usage...
	if (argc < 2) {
		printf("Usage: fish #0.clock #frame\n");
	}

	if (argc > 2) {
		NFrames = atoi(argv[2]);
		POV_FrameNum = NFrames;
		DoRender = 0;

		load_state();
		printf("Loading previous session...");

	}


	printf(" - NFrames: %d\n", NFrames);




//	exit(0);

	return 0;
}



void write_fish(int clock)
{
	FILE *out;
	char filename[256];

	int a, f;
	double camera[NAXIS+3];
	double vel_len, vel_len2;


	//=== Calculate camera position
	for (a=0;  a<NAXIS;  a++)
		camera[a] = 0.0;
	for (f=0;  f<NFISH;  f++) {
		for (a=0;  a<NAXIS;  a++)
			camera[a] += fish[f].pos[a];
	}
	for (a=0;  a<NAXIS;  a++)
		camera[a] /= NFISH;


	//=== Open POV file...
	//sprintf(filename, "\\ramdisk\\fish%04d.pov", POV_FrameNum);
	sprintf(filename, "\\ramdisk\\fish.pov");
	if ((out = fopen(filename, "wt")) == NULL)
	{
		fprintf(stderr, "Cannot open output file.\n");
		exit(1);
	}

	//=== Write file header...
	fprintf(out, "#version 3\n");
	fprintf(out, "#include \"colors.inc\"\n");
	fprintf(out, "#include \"shapes.inc\"\n");
	fprintf(out, "#include \"textures.inc\"\n");
	fprintf(out, "#include \"glass.inc\"\n");
	fprintf(out, "#include \"metals.inc\"\n");
	fprintf(out, "global_settings { assumed_gamma 1.0 }\n");
	fprintf(out, "camera {  location  <0.0, 0.5, -3.0>  direction 1.5*z  right     400/300*x  look_at   <%lf, %lf, %lf> }\n",
				(OldCamera[X]+OldCamera[X])/2.0, (OldCamera[Y]+OldCamera[Y])/2.0, (OldCamera[Z]+OldCamera[Z])/2.0);
	fprintf(out, "sky_sphere{  pigment  {    gradient y    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }  }}\n");
	fprintf(out, "light_source{  0*x // light's position (translated below)\n");
	fprintf(out, " color red 1.0  green 1.0  blue 1.0  // light's color\n");
	fprintf(out, " translate <-30, 30, -30>}\n");
//	fprintf(out, "plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}\n");
	fprintf(out, " plane { y, -0.99  hollow off    pigment {color rgb <0.7,0.5,0.3>}   finish {reflection 0.0 ambient 0.0} \n");
	fprintf(out, " 	 interior { ior 1.33 caustics 1.0 }    translate <5, 0, -10-20+clock>   normal { bumps 0.5 }}\n");
	fprintf(out, " fog {distance 45 color rgb<0.05, 0.1, 0.2> fog_type 2 fog_offset 4 fog_alt 1 }\n");


//* Metal...
#define MATERIAL "pigment { SteelBlue } finish {        reflection 0.9        diffuse 0        ambient 0.1        phong 1 phong_size 30    }"


//* Dull copper?
//#define MATERIAL "texture { T_Copper_3C }"
	fprintf(out, "default { %s }\n", MATERIAL);


	//=== Render fishes to POV src...
	for (f=0;  f<NFISH;  f++) {
		/* Output a sphere description... */
		if (NAXIS == 2) {
			fprintf(out, "\tsphere { <%f,%f>, %f}\n",
				fish[f].pos[X],
				fish[f].pos[Y],
				THRESHOLD_DIST / 4.0  );
		} else if (NAXIS == 3) {
/*			fprintf(out, "\tsphere { <%f,%f,%f>, %f}\n",
				fish[f].pos[X],
				fish[f].pos[Y],
				fish[f].pos[Z],
				THRESHOLD_DIST / 10.0  );*/
			/*vel_len = vlen(fish[f].vel[X]+fish[f].velold[X], fish[f].vel[Y]+fish[f].velold[Y], fish[f].vel[Z]+fish[f].velold[Z]);*/
			vel_len = vlen(fish[f].velavg[X]/(double)STEPS_PER_FRAME, fish[f].velavg[Y]/(double)STEPS_PER_FRAME, fish[f].velavg[Z]/(double)STEPS_PER_FRAME);
			vel_len2= vlen(fish[f].velavg[X]+fish[f].veloldavg[X]/(double)STEPS_PER_FRAME,
								fish[f].velavg[Y]+fish[f].veloldavg[Y]/(double)STEPS_PER_FRAME,
								fish[f].velavg[Z]+fish[f].veloldavg[Z]/(double)STEPS_PER_FRAME);



#define MID_DIVISOR 32.0

			//== Front...
			fprintf(out, "\tcone { <%f,%f,%f>, %f, <%f,%f,%f>, %f}\n",
				fish[f].pos[X],
				fish[f].pos[Y],
				fish[f].pos[Z],
				THRESHOLD_DIST / 30.0,
				fish[f].pos[X] - (/*fish[f].vel[X]+fish[f].velold[X]+*/fish[f].velavg[X]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR,
				fish[f].pos[Y] - (/*fish[f].vel[Y]+fish[f].velold[Y]+*/fish[f].velavg[Y]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR,
				fish[f].pos[Z] - (/*fish[f].vel[Z]+fish[f].velold[Z]+*/fish[f].velavg[Z]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR,
				THRESHOLD_DIST / 20.0  );
			//== Back...
			fprintf(out, "\tcone { <%f,%f,%f>, %f, <%f,%f,%f>, %f}\n",
				fish[f].pos[X] - (/*fish[f].vel[X]+fish[f].velold[X]+*/fish[f].velavg[X]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR,
				fish[f].pos[Y] - (/*fish[f].vel[Y]+fish[f].velold[Y]+*/fish[f].velavg[Y]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR,
				fish[f].pos[Z] - (/*fish[f].vel[Z]+fish[f].velold[Z]+*/fish[f].velavg[Z]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR,
				THRESHOLD_DIST / 20.0,
				fish[f].pos[X] - (fish[f].velavg[X]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR - (/*fish[f].vel[X]+/*/fish[f].velavg[X]+fish[f].veloldavg[X]/(double)STEPS_PER_FRAME)/vel_len2/20.0,
				fish[f].pos[Y] - (fish[f].velavg[Y]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR - (/*fish[f].vel[Y]+/*/fish[f].velavg[Y]+fish[f].veloldavg[Y]/(double)STEPS_PER_FRAME)/vel_len2/20.0,
				fish[f].pos[Z] - (fish[f].velavg[Z]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR - (/*fish[f].vel[Z]+/*/fish[f].velavg[Z]+fish[f].veloldavg[Z]/(double)STEPS_PER_FRAME)/vel_len2/20.0,
				THRESHOLD_DIST / 45.0  );


			//== Mid...
			fprintf(out, "\tsphere { <%f,%f,%f>, %f}\n",
				fish[f].pos[X] - (/*fish[f].vel[X]+fish[f].velold[X]+*/fish[f].velavg[X]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR,
				fish[f].pos[Y] - (/*fish[f].vel[Y]+fish[f].velold[Y]+*/fish[f].velavg[Y]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR,
				fish[f].pos[Z] - (/*fish[f].vel[Z]+fish[f].velold[Z]+*/fish[f].velavg[Z]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR,
				THRESHOLD_DIST / 20.0  );
			//== Head...
			fprintf(out, "\tsphere { <%f,%f,%f>, %f}\n",
				fish[f].pos[X],
				fish[f].pos[Y],
				fish[f].pos[Z],
				THRESHOLD_DIST / 30.0  );
			//== Tail...
			fprintf(out, "\tsphere { <%f,%f,%f>, %f}\n",
				fish[f].pos[X] - (fish[f].velavg[X]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR - (/*fish[f].vel[X]+/*/fish[f].velavg[X]+fish[f].veloldavg[X]/(double)STEPS_PER_FRAME)/vel_len2/20.0,
				fish[f].pos[Y] - (fish[f].velavg[Y]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR - (/*fish[f].vel[Y]+/*/fish[f].velavg[Y]+fish[f].veloldavg[Y]/(double)STEPS_PER_FRAME)/vel_len2/20.0,
				fish[f].pos[Z] - (fish[f].velavg[Z]/(double)STEPS_PER_FRAME)/vel_len/MID_DIVISOR - (/*fish[f].vel[Z]+/*/fish[f].velavg[Z]+fish[f].veloldavg[Z]/(double)STEPS_PER_FRAME)/vel_len2/20.0,
				THRESHOLD_DIST / 45.0  );



		} else {
			fprintf(stderr, "write_fish: Not implemented in this # dimensions.\n");
			exit(1);
		}

		//== Copy velocity vectors
		for (a=0;  a<NAXIS;  a++)
			fish[f].veloldavg[a] = fish[f].velavg[a];

		//== Reset avg velocity vectors
		for (a=0;  a<NAXIS;  a++)
			fish[f].velavg[a] = 0.0;

/*		//== Copy velocity vectors
		for (a=0;  a<NAXIS;  a++)
			fish[f].velold[a] = fish[f].vel[a];
*/
	}



	fclose(out);


	//== Update old camera...
	for (a=0;  a<NAXIS;  a++)
		OldCamera[a] = 0.75*OldCamera[a] + 0.25*camera[a];

}


void save_state()
{
	FILE *out;

	int a, f;



	//=== Open state file...
	if ((out = fopen("\\ramdisk\\fish.sta", "wb")) == NULL)
	{
		fprintf(stderr, "Cannot open state file.\n");
		exit(1);
	}

	//=== Write fish...
	for (f=0;  f<NFISH;  f++)
		fwrite(&fish[f], sizeof(fish[f]), 1, out);
	//=== Write Camera
	for (a=0;  a<NAXIS+3;  a++)
		fwrite(&OldCamera[a], sizeof(OldCamera[a]), 1, out);

	fclose(out);
}
void load_state()
{
	FILE *in;

	int a, f;


	//=== Open state file...
	if ((in = fopen("\\ramdisk\\fish.sta", "rb")) == NULL)
	{
		fprintf(stderr, "Cannot open state file.\n");
		exit(1);
	}

	//=== Read fish...
	for (f=0;  f<NFISH;  f++)
		fread(&fish[f], sizeof(fish[f]), 1, in);
	//=== Read Camera
	for (a=0;  a<NAXIS+3;  a++)
		fread(&OldCamera[a], sizeof(OldCamera[a]), 1, in);

	fclose(in);
}

