
	Comment & -------------------------------------------------

	(C) 1996, 1999 Michael Devine

	gfx, a graphics package

	To use with c programs, rename the c program's code segment
	to CPROG_TEXT.  (This file contains near procs.)

	Contents :
	 - misc + far routines
	 - palette routines
	 - sprite routines

	--------------------------------------------------------- &


	.Model Small
	.386


	; Near procs...

	public _sync
	public _setpal_black, _setpal, _fade, _fade_n; _fadeout, _palette
	public _slowfade
	public _palette
	public _xmaskbitblt, _xbitblt, _xgetbitmap
	public _xfbitblt, _xfgetmap, _xftbitblt


	public _lseg, _lofs
	public _paltab, _paltmp


_DATA segment word public 'DATA'

_paltab	label byte
	db	768 dup (0)
_paltmp	label byte
	db	768 dup (0)
_lseg	label byte
	dw	800 dup (0)		;  Line segment lookup table.
_lofs	label byte
	dw	800 dup (0)		;  Line offset lookup table.



_DATA EndS


;CPROG_TEXT segment byte public 'CODE'
;assume cs:CPROG_TEXT
;**************************
;	near code.
;**************************
.code

;***************************************************************
;
;			Misc & far routines
;
;***************************************************************


Proc _sync near
	mov	dx, 03dah		; VGA retrace reg

@@wait1:
	in	al, dx
	and	al, 00001000b		; Mask vertical retrace bit
	jz	short @@wait1
@@wait2:
	in	al, dx
	and	al, 00001000b
	jnz 	short @@wait2

;	mov	ax, 00600h
;	mov	dl, 021h
;	int	21h

	ret
_sync	EndP


;***************************************************************
;
;			Palette routines
;
;***************************************************************

Proc _palette near
	arg	n:byte, r:byte, g:byte, b:byte
	push	bp
	mov	bp, sp
	mov	dx, 03c8h		; Palette write index
	mov	al, n			; n = ss:[sp+0] = [bp+0]
	out	dx, al
	inc	dx

	mov	al, r
	out	dx, al
	mov	al, g
	out	dx, al
	mov	al, b
	out	dx, al

	pop	bp
	ret
_palette	EndP



Proc _setpal near
	lea	si, _paltab		; Dest
	mov	cx, 768			; Count
	call	_sync

	mov	dx, 003c8h
	out	dx, al			; <- This bug is left in...
					; sync() clears al, anyway.

	inc	dx
	rep	outsb			; Blit palette

	ret
EndP _setpal



Proc _setpal_black near
;	push	ds
;	pop	es
	mov	ax, ds
	mov	es, ax

	lea	di, _paltmp		; Dest, data, count...
	xor	ax, ax
	mov	cx, 768 / 4

	mov	si, di			; Source
	rep	stosd			; Blank out buffer

	mov	cx, 768			; Count
	call	_sync

	mov	dx, 003c8h
	out	dx, al			; <- This bug is left in...
					; sync() clears al, anyway.

	inc	dx
	rep	outsb			; Blit palette

	ret
EndP _setpal_black



Proc _fadein near
;		Inc the temp pal according to the real pal.
;		Then sync, and blit the temp pal.

	arg	n:byte
	push	bp
	mov	bp, sp

	mov	bx, si			; save si

	mov	ah, n			; ...for speed
	neg	ah
	add	ah, 63

	lea	di, _paltmp		; Dest, src...
	lea	si, _paltab

	mov	cx, 768			; Count

incloop:
	mov	al, [si]		; get entry
	cmp	ah, al			; Does entry need to be inc'd?
	jg	short noinc
	inc	byte ptr [di]
noinc:
	inc	di
	inc	si
	dec	cx
	jnz	short incloop



	lea	si, _paltmp		; Source

	mov	cx, 768			; Count
	call	_sync

	mov	dx, 003c8h
	out	dx, al			; <- This bug is left in...
					; sync() clears al, anyway.

	inc	dx
	rep	outsb			; Blit palette

	mov	si, bx

	pop	bp
	ret
EndP _fadein


Proc _fade near
;		Multiply the temp pal according to the real pal.
;		Then sync, and blit the temp pal.

	arg	n:byte
	push	bp
	mov	bp, sp

	mov	bx, si			; save si

	mov	dl, n			; ...for speed

	lea	di, _paltmp		; Dest, src...
	lea	si, _paltab

	mov	cx, 768			; Count

mulloop:
	mov	al, [si]		; get entry
	mul     dl
	shr	ax, 6			; divide by 64
	mov	[di], al

	inc	di
	inc	si
	dec	cx
	jnz	short mulloop



	lea	si, _paltmp		; Source

	mov	cx, 768			; Count
	call	_sync

	mov	dx, 003c8h
	out	dx, al			; <- This bug is left in...
					; sync() clears al, anyway.

	inc	dx
	rep	outsb			; Blit palette

	mov	si, bx

	pop	bp
	ret
EndP _fade

Proc _slowfade near
;		Multiply the temp pal according to the real pal.
;		Then sync, and blit the temp pal.

; This stupid waste of bytes has a 1, yes 1, character difference from _fade.

	arg	n:byte
	push	bp
	mov	bp, sp

	mov	bx, si		; save si

	mov	dl, n			; ...for speed

	lea	di, _paltmp		; Dest, src...
	lea	si, _paltab

	mov	cx, 768		; Count

mulloops:
	mov	al, [si]		; get entry
	mul	dl
	shr	ax, 7			; divide by 128
	mov	[di], al

	inc	di
	inc	si
	dec	cx
	jnz	short mulloops



	lea	si, _paltmp		; Source

	mov	cx, 768			; Count
	call	_sync

	mov	dx, 003c8h
	out	dx, al			; <- This bug is left in...
					; sync() clears al, anyway.

	inc	dx
	rep	outsb			; Blit palette

	mov	si, bx

	pop	bp
	ret
EndP _slowfade


Proc _fade_n near

;		Cheap cut'n'paste proc for a max color M.

;		Multiply the temp pal according to the real pal.
;		Then sync, and blit the temp pal.


	arg	n:byte, m:word
	push	bp
	mov	bp, sp

	push	si

	mov	dl, n			; ...for speed

	lea	di, _paltmp		; Dest, src...
	lea	si, _paltab

	mov	ax, m
	mov	cx, ax
	add	ax, ax
	add	cx, ax		; Count
	mov	bx, cx

mulloopn:
	mov	al, [si]		; get entry
	mul     dl
	shr	ax, 6			; divide by 64
	mov	[di], al

	inc	di
	inc	si
	dec	cx
	jnz	short mulloopn



	lea	si, _paltmp		; Source

	mov	cx, bx			; Count
	call	_sync

	mov	dx, 003c8h
	out	dx, al			; <- This bug is left in...
					; sync() clears al, anyway.

	inc	dx
	rep	outsb			; Blit palette

	pop	si
	pop	bp
	ret
EndP _fade_n


Proc _fadeout near
;		Dec the temp pal according to _itself_.
;		Then sync, and blit the temp pal.

	mov	bx, si			; save bx

	lea	si, _paltmp
	mov	cx, 768			; Count

decloop:
	sub	byte ptr [si], 1
	adc	byte ptr [si], 0
	inc	si
	dec	cx
	jnz	short decloop


	lea	si, _paltmp		; Source

	mov	cx, 768			; Count
	call	_sync

	mov	dx, 003c8h
	out	dx, al			; <- This bug is left in...
					; sync() clears al, anyway.

	inc	dx
	rep	outsb			; Blit palette

	mov	si, bx

	ret
EndP _fadeout

;***************************************************************
;
;			Sprite routines
;
;***************************************************************



Proc	_xbitblt	near
;
;	Primary use is to restore background.  But it can easily
;	be used to blit a tmp/mask/data bitmap by providing a
;	pointer offset by 8 bytes (4 tmp + 4 mask).

; Sequence:
;  Set up stack frame
;  Set up data destination, data source.	es:di, ds:si
;  Set up counters and "plane enable" byte.	cx, [ys]
;  Set up skip values.				bx
;  Then do blitter loops.

	PLN_EN	EQU ys
	PLN_C	EQU lxs
	SCN_OFS	EQU bitmap		; <- This is sooo dumb. CHANGE IT PLZ
;	assume	ds:_DATA		; <- guess it's not true?

	arg	x:word, y:word, xs:byte, ys:byte, lxs:byte, bitmap:dword


	push	bp			; Save regs & set up stack frame
	mov	bp, sp
	push	si
	push	di

	mov	ax, 0a000h		; Set up destination...
	mov	es, ax

	mov	di, x
	shr	di, 2
	mov	bx, y
	add	bx, bx
;	add	di, word ptr _DATA:_lofs[bx]	; ...done
	add	di, word ptr _lofs[bx]	; ...done


	push	ds			; Set up source... ;*********
	lds	si, dword ptr bitmap

	mov	word ptr SCN_OFS, di


	;Counters... (continued later)
	mov	ch, ys

	; Temporarily use cl to find plane data...
	; Which we store in ys since we're too lazy to increment sp.
	mov	cl, byte ptr x
	and	cl, 003h		; x mod 4.  This is first plane.
	mov	al, 1
	shl	al, cl			; al is data to send to plane enable.
	mov     PLN_EN, al

	mov	al, lxs			; cl = xcount = ceiling(lxs/16)
	mov	ah, al
	shr	al, 4
	and	ah, 0Fh
	jz	short skip_ceiling2
	inc	al
skip_ceiling2:
	mov	cl, al

	mov	bl, xs
	sub	bl, cl
	shr	bl, 4			; bl = "sprite skip" amount

	mov	bh, cl                  ; bh = "screen skip"
	shl	bh, 2
	neg	bh
	add	bh, 80


	mov	PLN_C, 4



	mov	ah, PLN_EN
xb_plnloop:

	mov	dx, 003c4h		; Set plane...
	mov	al, 002h
	out	dx, ax


	mov	dh, ch
xb_yloop:
	mov	dl, cl
xb_innerloop:
	mov	eax, [si]		; "Restore"
	add	si, 12			; Skip to next dword

	mov	es:[di], eax		; Write it
	add	di, 4

	dec	dl
	jnz	short xb_innerloop

	xor	ah, ah			; Yuck, kludge.
	mov	al, bl
	add	si, ax
	mov	al, bh
	add	di, ax

	dec	dh
	jnz	short xb_yloop


	mov	di, word ptr SCN_OFS
	mov	ah, PLN_EN
	shl	ah, 1			; ... next plane.
	and	ah, 0Fh
	jnz	short skip_planewrap2
	inc	ah
skip_planewrap2:
	mov	PLN_EN, ah
	dec	PLN_C
	jnz	short xb_plnloop

	pop	ds
	pop	di
	pop	si
	pop	bp
	ret

EndP	_xbitblt


Proc	_xfbitblt	near
;
;	Fast rep/non interlaced version bit blitter.

; Sequence:
;  Set up stack frame
;  Set up data destination, data source.	es:di, ds:si
;  Set up counters and "plane enable" byte.	cx, [ys]
;  Set up skip values.				bx
;  Then do blitter loops.

	COUNTH	EQU xs
	COUNTL	EQU y
	PLN_EN	EQU ys
	PLN_C	EQU lxs
	SCN_OFS	EQU bitmap		; <- This is sooo dumb. CHANGE IT PLZ

;	assume	ds:_DATA		; <- guess it's not true?

	arg	x:word, y:word, xs:byte, ys:byte, lxs:byte, bitmap:dword


	push	bp			; Save regs & set up stack frame
	mov	bp, sp
	push	si
	push	di

	mov	di, x			; Dest (screen)...
	shr	di, 2
	mov	bx, y
	add	bx, bx
	add	di, word ptr _lofs[bx]	; ...done


	push	ds
	mov	ax, 0a000h
	mov	es, ax

	lds	si, dword ptr bitmap	; Source

	mov	word ptr SCN_OFS, di



	;Counters... (continued later)
	mov	ch, ys

	; Temporarily use cl to find plane data...
	; Which we store in ys since we're too lazy to increment sp.
	mov	cl, byte ptr x
	and	cl, 003h		; x mod 4.  This is first plane.
	mov	al, 1
	shl	al, cl			; al is data to send to plane enable.
	mov	PLN_EN, al

	mov	al, lxs			; cl = xcount = ceiling(lxs/16)
	mov	ah, al
	shr	al, 4
	and	ah, 0Fh
	jz	short skip_ceilingf
	inc	al
skip_ceilingf:
	mov	cl, al

	mov	bl, xs
	sub	bl, lxs
;	sub	bl, cl
	shr	bl, 2			; bl = "sprite skip" amount.  Don't think this works.
;	xor	bl, bl		; XXX remove all this buggy code.

	mov	bh, cl			; bh = "screen skip"
	shl	bh, 2
	neg	bh
	add	bh, 80


	mov	PLN_C, 4


	mov	COUNTH, ch
	xor	ch, ch
	mov	COUNTL, cx

	mov	ah, PLN_EN
xfb_plnloop:

	mov	dx, 003c4h		; Set plane...
	mov	al, 002h
	out	dx, ax


	mov	dh, COUNTH
xfb_yloop:
	mov	cx, COUNTL

	rep	movsd

	xor	ah, ah			; Yuck, kludge.
	mov	al, bl
	add	si, ax
	mov	al, bh
	add	di, ax

	dec	dh
	jnz	short xfb_yloop


	mov	di, word ptr SCN_OFS
	mov	ah, PLN_EN
	shl	ah, 1			; ... next plane.
	and	ah, 0Fh
	jnz	short skip_planewrapf
	inc	di
	inc	word ptr SCN_OFS
	inc	ah
skip_planewrapf:
	mov	PLN_EN, ah
	dec	PLN_C
	jnz	short xfb_plnloop

	pop	ds
	pop	di
	pop	si
	pop	bp
	ret

EndP	_xfbitblt

Proc	_xftbitblt	near
;
;	Fast rep/non interlaced version of the (masked) bit blitter.

; Sequence:
;  Set up stack frame
;  Set up data destination, data source.	es:di, ds:si
;  Set up counters and "plane enable" byte.	cx, [ys]
;  Set up skip values.				bx
;  Then do blitter loops.

	COUNTH	EQU xs
	COUNTL	EQU y
	PLN_EN	EQU ys
	PLN_C	EQU lxs
	SCN_OFS	EQU bitmap		; <- This is sooo dumb. CHANGE IT PLZ

;	assume	ds:_DATA		; <- guess it's not true?

	arg	x:word, y:word, xs:byte, ys:byte, lxs:byte, bitmap:dword


	push	bp			; Save regs & set up stack frame
	mov	bp, sp
	push	si
	push	di

	mov	di, x			; Dest (screen)...
	shr	di, 2
	mov	bx, y
	add	bx, bx
	add	di, word ptr _lofs[bx]	; ...done


	push	ds
	mov	ax, 0a000h
	mov	es, ax

	lds	si, dword ptr bitmap	; Source

	mov	word ptr SCN_OFS, di



	;Counters... (continued later)
	mov	ch, ys

	; Temporarily use cl to find plane data...
	; Which we store in ys since we're too lazy to increment sp.
	mov	cl, byte ptr x
	and	cl, 003h		; x mod 4.  This is first plane.
	mov	al, 1
	shl	al, cl			; al is data to send to plane enable.
	mov     PLN_EN, al

	mov	al, lxs			; cl = xcount = ceiling(lxs/16)
	mov	ah, al
	shr	al, 4
	and	ah, 0Fh
	jz	short skip_ceilingft
	inc	al
skip_ceilingft:
	mov	cl, al

	mov	bl, xs
	sub	bl, lxs
;	sub	bl, cl
	shr	bl, 2			; bl = "sprite skip" amount.  Don't think this works.
;	xor	bl, bl		; XXX remove all this buggy code.

	mov	bh, cl			; bh = "screen skip"
	shl	bh, 2
	neg	bh
	add	bh, 80

	add	cl, cl			; dealing with words here, !dwords.
	inc	cl				; ... plus we break from top of loop. :I

	mov	PLN_C, 4


	mov	COUNTH, ch
	xor	ch, ch
	mov	COUNTL, cx

	mov	ah, PLN_EN
xft_plnloop:

	mov	dx, 003c4h		; Set plane...
	mov	al, 002h
	out	dx, ax


	mov	dh, COUNTH
xft_yloop:
	mov	cx, COUNTL

;	mov	eax, 0FFFFFFFFh
;	rep	stosd

;--------------------
;
;	The following mess I wrote to avoid word misalignment faults
;	as often as possible.  I don't know if this succeeds (are there
;	even word misalignment faults with string commands?), but
;	it has at most 2 jmps per byte (no loss, no gain), and while
;	the chance of 2 jumps is greater, this method
;	often puts 2 byte ops into 1 word op... so it's at least doubtful
;	that this is slower than doing a simple stosb approach.
;	Thank you.  End of speech.
;
;	But wait!  Don't word misalignment faults only occur when
;	using words, meaning this actually causes them?

	jmp	short xft_xloop
xft_xsto:
	stosw
	sub	di, 2
xft_xinc:
	add	di, 2
xft_xloop:

	dec	cx
	jz	short xft_break

	lodsw
;	mov	es:[di], word ptr 0FFFFh

	test	ah, ah
	jnz	short chek_al

	test	al, al
	jz	short xft_xinc

	stosb
	inc	di
	jmp	short xft_xloop

chek_al:
	; Must write ah...
	test	al, al
	jnz	short xft_xsto

	inc	di
	mov	al, ah
	stosb
	jmp	short xft_xloop
;--------------------

;	rep	movsd
;	mov	eax, ds:[si]
;	mov	es:[di], eax
;	add	di, 4
;	add	si, 12
;	dec	cx
;	jnz	test78

xft_break:
	xor	ah, ah			; Yuck, kludge.
	mov	al, bl
	add	si, ax
	mov	al, bh
	add	di, ax

	dec	dh
	jnz	short xft_yloop


	mov	di, word ptr SCN_OFS
	mov	ah, PLN_EN
	shl	ah, 1			; ... next plane.
	and	ah, 0Fh
	jnz	short skip_planewrapft
	inc	di
	inc	word ptr SCN_OFS
	inc	ah
skip_planewrapft:
	mov	PLN_EN, ah
	dec	PLN_C
	jnz	short xft_plnloop

	pop	ds
	pop	di
	pop	si
	pop	bp
	ret

EndP	_xftbitblt




Proc	_xmaskbitblt	near
;
;	Limitations:  Lots o' memory waste, not too flexible.
;	Screen width must be < 1024 if sprite is small.
;	Watch for sprite skip val on large sprites.
;	No 'lys' exists.
;	Tmp'ly locked into 320 byte scn width.
;	NOTE: You cannot put the same sprite down twice and then restore
;	both... the background of the first will be overwritten.  Kludge
;	is to use xgetbitmap to pick up the background of the first into
;	another area, however this is slow and makes the massive memory
;	use even less attractive.  Better to cut'n'paste these routines
;	into a new specialized routine.  Possibly it could use fs:si to
;	save the data???
;
;	Right now it's kind of "big n dumb."  Big on memory usage
;	(wastage), that is.  However, the absence of time spent
;	'thinking' makes it ungod-ly fast.

; Sequence:
;  Set up data destination, data source.	es:di, ds:si
;  Set up counters and "plane enable" byte.	cx, [ys]
;  Set up skip values.				bx
;  Then do blitter loops.

	PLN_EN	EQU ys
	PLN_C	EQU lxs
	SCN_OFS	EQU bitmap
;	assume	ds:_DATA		; <- guess it's not true?

	arg	x:word, y:word, xs:byte, ys:byte, lxs:byte, bitmap:dword


	push	bp			; Save regs & set up stack frame
	mov	bp, sp
	push	si
	push	di

	mov	ax, 0a000h		; Set up destination...
	mov	es, ax

	mov	di, x
	shr	di, 2
	mov	bx, y
	add	bx, bx
	add	di, word ptr _lofs[bx]	; ...done


	push	ds			; Set up source... ;*********
	lds	si, dword ptr bitmap

	mov	word ptr SCN_OFS, di


	;Counters... (continued later)
	mov	ch, ys

	; Temporarily use cl to find plane data...
	; Which we store in ys since we're too lazy to increment sp.
	mov	cl, byte ptr x
	and	cl, 003h		; x mod 4.  This is first plane.
	mov	byte ptr x, cl		; XXX TEST - Plane read val
	mov	al, 1
	shl	al, cl			; al is data to send to plane enable.
	mov     PLN_EN, al

	mov	al, lxs			; cl = xcount = ceiling(lxs/16)
	mov	ah, al
	shr	al, 4
	and	ah, 0Fh
	jz	short skip_ceiling
	inc	al
skip_ceiling:
	mov	cl, al

	mov	bl, xs
	sub	bl, cl
	shr	bl, 4			; bl = "sprite skip" amount

	mov	bh, cl                  ; bh = "screen skip"
	shl	bh, 2
	neg	bh
	add	bh, 80


	mov	PLN_C, 4



	mov	ah, PLN_EN
xmb_plnloop:

	mov	dx, 003c4h		; Set plane...
	mov	al, 002h
	out	dx, ax

	mov	dx, 003ceh		; Set plane to read...
	mov	al, 04h
	mov	ah, byte ptr x
	out	dx, ax
	inc	byte ptr x
	and	x, 03h


	mov	dh, ch
xmb_yloop:
	mov	dl, cl
xmb_innerloop:
	mov	eax, es:[di]
	mov	[si], eax		; "Save"
	add	si, 4

	and	eax, [si]               ; Mask
;	mov	eax, [si]               ; Mask		<- erase
	add	si, 4
;	mov	eax, [si]               ; Mask		<- erase
	or	eax, [si]               ; Add tile
	add	si, 4
;	mov	eax, [si]               ; Mask		<- erase

;	mov	eax, 05d5d5d5dh
	mov	es:[di], eax		; Write it
	add	di, 4

	dec	dl
	jnz	short xmb_innerloop

	xor	ah, ah			; Yuck, kludge.
	mov	al, bl
	add	si, ax
	mov	al, bh
	add	di, ax

	dec	dh
	jnz	short xmb_yloop


	mov	di, word ptr SCN_OFS
	mov	ah, PLN_EN
	shl	ah, 1			; ... next plane.
	and	ah, 0Fh
	jnz	short skip_planewrap
	inc	ah
skip_planewrap:
	mov	PLN_EN, ah
	dec	PLN_C
	jnz	short xmb_plnloop

	pop	ds
	pop	di
	pop	si
	pop	bp
	ret
EndP	_xmaskbitblt




Proc	_xgetbitmap	near
;
;	Limitations:  See _xmaskbitblt

;	Data required for this proc = ys * 3 * ceiling(xs/16)*16  bytes

; Sequence:
;  Set up source (screen), dest (data).	es:di, ds:si	; <- yes, reversed.
;  Set up counters.			cx
;  Set up skip values.			bx
;  Then do blitter loops.

	PLN_C	EQU lxs
	SCN_OFS	EQU bitmap
;	assume	ds:_DATA		; <- guess it's not true?
;	assume nothing

	arg	x:word, y:word, xs:byte, ys:byte, lxs:byte, bitmap:dword


	push	bp			; Save regs & set up stack frame
	mov	bp, sp
	push	si
	push	di

	mov	ax, 0a000h		; Set up destination...
	mov	es, ax

	mov	di, x
	shr	di, 2
	mov	bx, y
	add	bx, bx
	add	di, word ptr _lofs[bx]	; ...done


	push	ds			; Set up source... ;*********
	lds	si, dword ptr bitmap

	mov	word ptr SCN_OFS, di


	;Counters... (continued later)
	mov	ch, ys


	; Temporarily use cl to find plane data...
	; Which we store in ys since we're too lazy to increment sp.
	mov	cl, byte ptr x
	and	cl, 003h		; x mod 4.  This is first plane.
	mov	byte ptr x, cl		; XXX TEST - Plane read val


	mov	al, lxs			; cl = xcount = ceiling(lxs/16)
	mov	ah, al
	shr	al, 4
	and	ah, 0Fh
	jz	short skip_ceiling3
	inc	al
skip_ceiling3:
	mov	cl, al

	mov	bl, xs
	sub	bl, cl
	shr	bl, 4			; bl = "sprite skip" amount

	mov	bh, cl			; bh = "screen skip"
	shl	bh, 2
	neg	bh
	add	bh, 80


	mov	PLN_C, 4



xgm_plnloop:

	mov	dx, 003ceh		; Set plane to read...
	mov	al, 04h
	mov	ah, byte ptr x
	out	dx, ax

	inc	ah
	and	ah, 03h
	mov	byte ptr x, ah


	mov	dh, ch
xgm_yloop:
	mov	dl, cl
	push	cx
xgm_innerloop:
	mov	eax, es:[di]
;	mov	ds:[si], dword ptr 0	; Clear "Save" space. Not needed.
	add	si, 8			; move to data space

	mov	ds:[si], eax		; Save tile in data space.
	sub	si, 4			; move to mask space

	; For each of the 4 bytes in eax, it becomes 255 (mask nothing)
	; iff it is 0, otherwise it becomes 0 (mask everything).

	mov	cx, 4
xgm_maskloop:
	or	al, al
	jnz	short xgm_clear
xgm_set:
	mov	al, 0FFh
	jmp	short xgm_cont
xgm_clear:
	xor	al, al
xgm_cont:
	rol	eax, 8
	dec	cx
	jnz	short xgm_maskloop

	mov	[si], eax		; Save mask
;	mov	ds:[si], dword ptr 001010101h
	add	si, 8

	add	di, 4

	dec	dl
	jnz	short xgm_innerloop

	pop	cx

	xor	ah, ah			; Yuck, kludge.
	mov	al, bl
	add	si, ax
	mov	al, bh
	add	di, ax

	dec	dh
	jnz	short xgm_yloop


	mov	di, word ptr SCN_OFS
	dec	PLN_C
	jnz	short xgm_plnloop

	pop	ds
	pop	di
	pop	si
	pop	bp
	ret
EndP	_xgetbitmap


Proc	_xfgetmap	near
;
;	Limitations:  See _xmaskbitblt

;	Data required for this proc = ys * 3 * ceiling(xs/16)*16  bytes

; Sequence:
;  Set up source (screen), dest (data).	es:di, ds:si	; <- yes, reversed.
;  Set up counters.			cx
;  Set up skip values.			bx
;  Then do blitter loops.
	COUNTH	EQU xs
	COUNTL	EQU y
	PLN_EN	EQU ys
	PLN_C	EQU lxs
	SCN_OFS	EQU bitmap		; <- This is sooo dumb. CHANGE IT PLZ

;	assume	ds:_DATA		; <- guess it's not true?

	arg	x:word, y:word, xs:byte, ys:byte, lxs:byte, bitmap:dword


	push	bp			; Save regs & set up stack frame
	mov	bp, sp
	push	si
	push	di

	mov	si, x			; Source (screen)...
	shr	si, 2
	mov	bx, y
	add	bx, bx
	add	si, word ptr _lofs[bx]	; ...done


	push	ds

	sub	sp, 10

	mov	ax, 0a000h
	mov	ds, ax

	les	di, dword ptr bitmap	; Dest

	mov	word ptr SCN_OFS, si


	;Counters... (continued later)
	mov	ch, ys

	; Temporarily use cl to find plane data...
	; Which we store in ys since we're too lazy to increment sp.
	mov	cl, byte ptr x
	and	cl, 003h		; x mod 4.  This is first plane.
	mov	al, 1
	shl	al, cl			; al is data to send to plane enable.
	mov     PLN_EN, al

	mov	al, lxs			; cl = xcount = ceiling(lxs/16)
	mov	ah, al
	shr	al, 4
	and	ah, 0Fh
	jz	short skip_ceilingfg
	inc	al
skip_ceilingfg:
	mov	cl, al

	mov	bl, xs
	sub	bl, cl
	shr	bl, 4			; bl = "sprite skip" amount.  Don't think this works.
	xor	bl, bl


	mov	bh, cl			; bh = "screen skip"
	shl	bh, 2
	neg	bh
	add	bh, 80


	mov	PLN_C, 4


	mov	COUNTH, ch
	xor	ch, ch
	mov	COUNTL, cx
;	mov	byte ptr x, 0

xfgm_plnloop:

	mov	dx, 003ceh		; Set plane to read...
	mov	al, 04h
	mov	ah, byte ptr x
	out	dx, ax

	inc	ah
	and	ah, 03h
	jnz	short xfgskip_plnwrap
	inc	SCN_OFS
xfgskip_plnwrap:
	mov	byte ptr x, ah


	mov	dh, COUNTH
xfg_yloop:
	mov	cx, COUNTL

	rep	movsd


	xor	ah, ah			; Yuck, kludge.
	mov	al, bh
	add	si, ax

	mov	al, bl
	add	di, ax

	dec	dh
	jnz	short xfg_yloop


	mov	si, word ptr SCN_OFS

	dec	PLN_C
	jnz	short xfgm_plnloop


	add	sp, 10
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret
EndP	_xfgetmap

;CPROG_TEXT	EndS


End