//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/************************************/
/*** Avion qui passe sous l'arche ***/
/************************************/

#include "colors.inc"
#include "skies.inc"

#include "ile.inc"

#declare cl1=ppcl;

/*** Definis la position de l'avion ***/
/**************************************/

#declare Px=660+(cos(cl1*pi)-1)/2*180*2-cl1*cl1*280;
#declare Py=140-sin(cl1*pi*1.2)*133;
#declare Pz=176+sin(cl1*pi)*260+(Px*-0.18+450*.18);

/*** Dfinition de la scne ***/
/******************************/
#if(cl1<=0.45)
	camera {
		location <510,5,430>
		look_at <Px,Py,Pz>
	}
#else
	#local cl3=(cl1-0.45)/0.55;
	#local cl2=cl1-0.09+cl3*0.074;
	#local Pcx=660+(cos(cl2*pi)-1)/2*180*2-cl2*cl2*280;
	#local Pcy=140-sin(cl2*pi*1.2)*133+cl3*cl3*4;
	#local Pcz=176+sin(cl2*pi)*260+(Pcx*-0.18+450*0.18);

	
	#local cl4=cl3*3;
	#if(cl4>1) #local cl4=1; #end
	#local Pcx=510-(510-Pcx)*cl4;
	#local Pcy=5-(5-Pcy)*cl4*cl4*cl4*cl4;
	#local Pcz=430-(430-Pcz)*sqrt(cl4)-sin(cl3*pi)*6;

	camera {
		location <Pcx,Pcy,Pcz>
		look_at <Px,Py-cl3*2.4,Pz>
	}
#end

light_source { <15000,33000,-10000> White }

sky_sphere { S_Cloud1 }

global_settings { assumed_gamma 2.2
		ambient_light White*2
}

/*** Dfinition des objets ***/
/*****************************/

object { Ile }

/*** Fait l'arriv de l'avion ***/
/********************************/
#declare cloF=cl1*2;		// clock pour mouvement des reacteurs

#declare Aileron = cos(cl1*2*pi)/2+0.5;
#declare ADerive = -cos(cl1*pi*1.2);
#declare PReacteur = 0.9-cl1*0.43;	// Puissance du reacteur (0  1)

#declare D_Missile = 110;	// Distance de fin du Missil
#declare C_Missile = 0; 	// Clock du missil pour arriver  D_Missil
#if(cl1>=0.75)
	#declare C_Missile=(cl1-0.75)/0.2;
#end

#include "avion.inc"

object { Avion
	translate <0,0,-60>
	scale 0.15
	rotate z*(sin(cl1*2*pi*5)*1.1) // Fait tanguer
	rotate z*(cos(cl1*2*pi)/2+0.5)*-35
	rotate x*(-(cos(cl1*pi*1.55)*15)-5)
	rotate y*-(180+cl1*173)
	translate <Px,Py,Pz>
}
