//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/************************************/
/*** Dfinition des object divers ***/
/************************************/

#include "colors.inc"
#include "woods.inc"
#include "metals.inc"

#declare Font="crystal.ttf"

/*** Dfinition des Textures ***/
/*******************************/

#declare BoisPanneau = texture {
	T_Wood8
	scale 7
	normal {
		bumps 0.9
		scale 0.8
		bump_size 0.25
		turbulence 0.2
	}
}

#declare T_Clous = texture {
	T_Copper_3A
	normal {
		bumps 0.12
	}
}

#declare F_Peinture = finish {
	ambient 0.4
	diffuse 0.9
	specular 0.3
}

/*** Dfinition des Objets ***/
/*****************************/

#declare Clous = cylinder {
	<0,0,0> <0,0,-0.1> 0.22
	texture { T_Clous }
}

#declare AfficheP = union {
	box { <-26,0,0> <26,20,-2.5>
		texture { BoisPanneau
			rotate y*92.08
			rotate x*95.12
			translate <6,-4,-18>
		}
	}
	text { ttf Font "DANGER",0.1,0
		scale 9
		translate <-12,12,-2.501>
		pigment { Red }
		finish { F_Peinture }
	}
	text { ttf Font "HUMAN CREATURES",0.1,0
		scale 6
		translate <-23,5,-2.501>
		pigment { White }
		finish { F_Peinture }
	}
}


#declare Panneau = union {
	box { <0,-20,0> <5,41.23,5>
		texture { BoisPanneau
			rotate x*90.12
		}
	}
	object { AfficheP
		rotate z*3.12
		translate <2.5,20,0>
	}
	object { Clous translate <2.2,24,-2.5> }
	object { Clous translate <2.9,36,-2.5> }
}
