//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/***************************/
/*** Dfinition de l'ile ***/
/***************************/

#include "colors.inc"
#include "skies.inc"
#include "metals.inc"

/*** Dfinition des Textures ***/
/*******************************/

#declare T_Eau = texture {
	T_Chrome_2D
	normal {
		waves 1.5
		frequency 1500
		scale <1700,2,1700>
		translate <160,-80,-1990>
		rotate x*2.9
	}
}

#declare C_Terre1 = rgb <206/255,186/255,138/255>;
#declare C_Terre2 = rgb <119/255,115/255,97/255>;
#declare C_Gazon = rgb <123/255,155/255,59/255>;
#declare C_GazonF = rgb <76/255,135/255,48/255>;

#declare T_Ile = texture {
	pigment { marble
		color_map {
			[ 0.0 0.15 color C_Terre1 color C_Terre2 ]
			[ 0.15 0.35 color C_Terre2 color C_Gazon ]
			[ 0.35 0.6 color C_Gazon color C_GazonF ]
			[ 0.6 0.8 color C_GazonF color C_Terre1 ]
			[ 0.8 1.0 color C_Terre1 color C_Terre2 ]
		}
		phase 1
		turbulence 0.145
		rotate z*-90
	}
	finish { specular 0.25
		diffuse 0.5
		roughness 0.995
//		crand 0.29
		ambient 0.2
	}
	scale <10,120,10>
	normal { bumps
		phase 1
		bump_size 15.8
		scale 28.5
		turbulence 0.35
		rotate x*30
		rotate z*12
	}
	normal { wood
		phase 1
		bump_size 50
		scale 20
		turbulence 0.2
	}
	normal { crackle
		phase 1
		bump_size 9
		scale 19
		turbulence 0.15
		rotate x*45.9
	}
	rotate y*31.25
}

/*** Definition des Objets ***/
/*****************************/

#declare F_Ile = height_field {
	ppm "im_ile.ppm"
	water_level 0.39
	smooth
	translate <-0.5,-0.39,-0.5>
	scale <1000,130,1000>
}

#declare Trous = cylinder {
	<0,-10,480> <500,0,370>,15
	scale <1,1.6,1>
}

#declare IleF = difference {
	object { F_Ile }
	object { Trous translate <0,-6,0> }
	texture { T_Ile translate <0,130*0.40,0> }
}

#declare Eau = plane {
	y,0
	texture { T_Eau }
	translate <clock*-50,0,clock*-20>
}

#declare Axes = union {
	cylinder { <-500,200,0> <500,200,0>,5 pigment { color Red } }
	cylinder { <0,200,-500> <0,200,500>,5 pigment { color Blue } }
}

#declare Ile = union {
	object { IleF }
	object { Eau }
	scale (5.5/5) 	// Histoir d'avoir le mme echelle sur mon impression :-)
}
