//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/******************************/
/*** Dsciption du papillon ***/
/******************************/

#include "colors.inc"
#include "finish.inc"

/*** Varialbe du Battement d'aile ***/
/************************************/

// P_Aile = clock;	// 0 = ferme, de 0  1 fait un battement

/*******************************/
/*** Dfinition des Textures ***/
/*******************************/

#declare T_Corps_Papi = texture {
	pigment { color rgb <188/255,158/255,37/255> }
	finish {
		specular 0.3
		diffuse 0.85
	}
	normal {
		marble 0.3
		scale <0.3,1,1>
		rotate y*90
		turbulence 0.2
	}
}

#declare T_Tete_Papi = texture {
	pigment { color rgb <175/255,152/255,58/255> }
	finish { specular 0.25
		diffuse 0.25
	}
	normal { bumps 0.6
		scale 0.1
	}
}

#declare T_AntenneP = texture {
	pigment { color Black }
	finish { specular 0.5
		diffuse 0.8
	}
}

#declare T_Bout_Antenne = texture {
	pigment { color Yellow }
	finish { Luminous }
}

#declare T_AileP = texture {
	pigment { bozo
		color_map { [0.0 Red] [0.3 Cyan] [0.5 Yellow] [0.8 Blue] }
		scale 0.9
		turbulence 0.2
	}
	finish { specular 0.5
		diffuse 0.85
	}
	translate <-2.5,0,1.4>
}

/*****************************/
/*** Dfinition des Objets ***/
/*****************************/

#declare Corps_Papi = union {
	cylinder {
		<0,0,0> <0,0,5> 0.3
	}
	sphere { <0,0,0> 0.3
		scale <1,1,2>
		translate <0,0,5>
	}
	texture { T_Corps_Papi }
}

#declare Oeil_Papi = sphere {
	<0,0,0> 0.10
	pigment { color White }
	finish { ambient 0.8
		reflection 0.25
		diffuse 0.98
	 }
}

#declare Tete_Papi = union {
	sphere {
		<0,0,0> 0.35
		texture { T_Tete_Papi }
	}
	object { Oeil_Papi translate <-0.2,0.1,-0.2> }
	object {Oeil_Papi translate <0.2,0.1,-0.2> }
}

//#declare Bout_Lumineu = light_source {
//	<0,-0.04,-0.04> Yellow*0.3
//	fade_distance 4
//	fade_power 1
//	jitter
//	looks_like {
//		sphere { <0,0,0> 0.08 texture { T_Bout_Antenne } }
//	}
//}

#declare Bout_Lumineu = sphere {
	<0,0,0> 0.08
	texture { T_Bout_Antenne }
}

#declare Antenne_Papi = union {
	difference {
		torus { 1.4 0.035
			texture { T_AntenneP }
			rotate z*90
			translate <0,0,-1.4>
		}
		plane { y, 0 texture { T_AntenneP } }
		plane { z, -1.4 texture { T_AntenneP } }
	}
	object { Bout_Lumineu translate <0,1.4,-1.4> }
}

#declare Aile_Papi = difference {
	union {
		cylinder { <0,0,0> <0,0.001,0> 3
			scale <2,1,0.6>
			rotate y*-40
			translate <0,0,3>
		}
		cylinder { <0,0,0> <0,0.001,0> 1.5
			scale <1,1,3.5>
			rotate y*-35
			translate <0,0,2.5>
		}
		scale <1.3,1,1>
		texture { T_AileP }
		translate <-0.2,0.2,0>
	}
	plane { x,0 inverse texture { T_AileP } }
	rotate z*-89
}

#local AngleAile = (cos(P_Aile*2*pi)-1)*55;

#declare Papillon = union {
	object { Corps_Papi }
	object { Tete_Papi }
	object { Antenne_Papi rotate z*25 rotate x*-15 }
	object { Antenne_Papi rotate z*-25 rotate x*-15 }
	object { Aile_Papi rotate z*-AngleAile translate <-0.15,0.15,0> } 
	object { Aile_Papi rotate z*-AngleAile scale <-1,1,1> translate <0.15,0.15,0> }
	translate <0,0.4,0>
}
