//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/******************************/
/*** Dsciption des plantes ***/
/******************************/

#include "colors.inc"

//	FleurR = Fleur Rouge
//	FleurJ = Fleur Jaune
//	FleurB = Fleur Bleue
//	Nenuphare = Nenuphare
//	Papier_Russe = Papier Russe


/*** Dfinition des Textures ***/
/*******************************/

#declare C_Vert_Fonce = rgb <32/255,135/255,16/255>;

#declare T_Tige = texture {
	pigment { color C_Vert_Fonce }
	finish {
		specular 0.45
		diffuse 0.6
	}
}

#declare T_Feuille = texture {
	pigment { color C_Vert_Fonce
		filter 0.1
	}
	finish {
		specular 0.45
		diffuse 0.6
	}
	normal {
		marble 0.25
		scale 0.3
	}
}

#declare T_Coeur = texture {
	pigment { color White*0.75 }
	finish {
		specular 0.15
		diffuse 0.95
	}
	normal {
		bumps
		bump_size 4
		scale 0.15
	}
}

#declare T_Nenuphare = texture {
	pigment { color C_Vert_Fonce }
	finish { specular 0.45
		diffuse 0.65
	}
	normal { radial 0.1
		frequency 80
	}
}

#declare T_PetaleR = texture {
	pigment { color rgb <255/255,86/255,148/255> filter 0.1 }
	finish { specular 0.3
		diffuse 0.7
	}
}

#declare T_PetaleJ = texture {
	pigment { color rgb <226/255,216/255,27/255> filter 0.1 }
	finish { specular 0.3
		diffuse 0.7
	}
}

#declare T_PetaleB = texture {
	pigment { color rgb <54/255,185/255,237/255> filter 0.1 }
	finish { specular 0.3
		diffuse 0.7
	}
}

#declare T_CoeurFleur = texture {
	pigment { color Yellow }
	finish { specular 0.4
		diffuse 0.75
	}
	normal { bumps 0.8
		scale 0.07
		bump_size 0.9
	}
}

/*****************************/
/*** Dfinition des Objets ***/
/*****************************/

#declare TigePR = cylinder {
	<0,0,0> <0,-70,0> 0.35
	texture { T_Tige }
}

#declare FeuillePR = triangle {
	<-0.5,0,0.4> <0.5,0,0.4> <0,0,-30>
	texture { T_Feuille }
}

#declare CoeurPR = sphere {
	<0,0,0> 0.35
	scale <1,6,1>
	texture { T_Coeur }
}

#declare Papier_Russe = union {
	object { TigePR }
	object { CoeurPR }

	#local AngleC=(360/3);
	#local NNiveau=6;	// Fait tous les niveaux
	#while (NNiveau>0)
		union {
			#local Ang=NNiveau*(360/6+13);
			object { FeuillePR rotate x*(4*NNiveau-10) rotate y*(AngleC+Ang) }
			object { FeuillePR rotate x*(4*NNiveau-10) rotate y*(2*AngleC+Ang) }
			object { FeuillePR rotate x*(4*NNiveau-10) rotate y*(3*AngleC+Ang) }
			translate <0,NNiveau*0.2,0>
		}
	#local NNiveau=NNiveau-1;
	#end
}

#declare Bord_Nenu = difference {
	cylinder { <0,0,-8> <0,0,-7.95> 1 texture { T_Nenuphare } }
	plane { y,0 pigment { color C_Vert_Fonce } }
}

#declare Nenuphare = union {
	cylinder { <0,0,0> <0,0.1,0> 8 texture { T_Nenuphare } }
	object { TigePR }

	#local NBord=40;
	#local Compt=0;
	#while (Compt<NBord)
		object { Bord_Nenu rotate y*(Compt*360/NBord) }
		#local Compt=Compt+1;
	#end
}

#declare PetaleR = difference {
	sphere { <0,0,0> 3 texture { T_PetaleR } }
	sphere { <0,0,0> 2.98 texture { T_PetaleR } }
	cylinder { <0,0,0> <10,0,0> 1 scale <1,2,1.7> translate <0,-1,0>
		texture { T_PetaleR } inverse
	}
	translate <0,3,0>
}

#declare PetaleJ = difference {
	sphere { <0,0,0> 3 texture { T_PetaleJ } }
	sphere { <0,0,0> 2.98 texture { T_PetaleJ } }
	cylinder { <0,0,0> <10,0,0> 1 scale <1,2,1.7> translate <0,-1,0>
		texture { T_PetaleJ } inverse
	}
	translate <0,3,0>
}

#declare PetaleB = difference {
	sphere { <0,0,0> 3 texture { T_PetaleB } }
	sphere { <0,0,0> 2.98 texture { T_PetaleB } }
	cylinder { <0,0,0> <10,0,0> 1 scale <1,2,1.7> translate <0,-1,0>
		texture { T_PetaleB } inverse
	}
	translate <0,3,0>
}

#declare CoeurFleur = sphere {
	<0,0,0> 0.35
	scale <1,8,1>
	texture { T_CoeurFleur }
}

#declare FleurR = union {
	object { TigePR }
	object { CoeurFleur }
	object { PetaleR rotate z*-13.9 }
	object { PetaleR rotate z*-14 rotate y*(360/3) }
	object { PetaleR rotate z*-14.1 rotate y*(360/3*2) }
	object { PetaleR translate <0,-0.2,0> rotate z*-18.1 rotate y*(360/12) }
	object { PetaleR translate <0,-0.2,0> rotate z*-18 rotate y*(360/3+360/9) }
	object { PetaleR translate <0,-0.2,0> rotate z*-17.9 rotate y*(360/3*2+360/9) }
	object { PetaleR translate <0,-0.4,0> rotate z*-21.1 rotate y*(360/9*2) }
	object { PetaleR translate <0,-0.4,0> rotate z*-21 rotate y*(360/3+360/9*2) }
	object { PetaleR translate <0,-0.4,0> rotate z*-20.9 rotate y*(360/3*2+360/9*2) }
} 

#declare FleurJ = union {
	object { TigePR }
	object { CoeurFleur }
	object { PetaleJ rotate z*-6.9 }
	object { PetaleJ rotate z*-7 rotate y*(360/3) }
	object { PetaleJ rotate z*-7.1 rotate y*(360/3*2) }
	object { PetaleJ translate <0,-0.4,0> rotate z*-13.1 rotate y*(360/12) }
	object { PetaleJ translate <0,-0.4,0> rotate z*-13 rotate y*(360/3+360/9) }
	object { PetaleJ translate <0,-0.4,0> rotate z*-12.9 rotate y*(360/3*2+360/9) }
	object { PetaleJ translate <0,-0.2,0> rotate z*-10.1 rotate y*(360/9*2) }
	object { PetaleJ translate <0,-0.2,0> rotate z*-10 rotate y*(360/3+360/9*2) }
	object { PetaleJ translate <0,-0.2,0> rotate z*-9.9 rotate y*(360/3*2+360/9*2) }
} 

#declare FleurB = union {
	object { TigePR }
	object { CoeurFleur }
	object { PetaleB rotate z*-24.9 }
	object { PetaleB rotate z*-25 rotate y*(360/3) }
	object { PetaleB rotate z*-25.1 rotate y*(360/3*2) }
	object { PetaleB translate <0,-0.2,0> rotate z*-30.1 rotate y*(360/12) }
	object { PetaleB translate <0,-0.2,0> rotate z*-30 rotate y*(360/3+360/9) }
	object { PetaleB translate <0,-0.2,0> rotate z*-29.9 rotate y*(360/3*2+360/9) }
	object { PetaleB translate <0,-0.4,0> rotate z*-35.1 rotate y*(360/9*2) }
	object { PetaleB translate <0,-0.4,0> rotate z*-35 rotate y*(360/3+360/9*2) }
	object { PetaleB translate <0,-0.4,0> rotate z*-34.9 rotate y*(360/3*2+360/9*2) }
} 
