//      (_||_/
//      (    )       Animation POUIPOUIC Story
//     ( o  0 )
//-OOO--(_)---OOO---------------------------------------
//                   Dominique Roux-Serret  1999
// .OOOo      oOOO.  roux-serret@ifrance.com
//-(   )------(   )---------------------------------------
//  ( (        ) /  
//   (_)      (_/

/********************************/
/*** Course aprs le papillon ***/
/********************************/

#include "colors.inc"
#include "skies.inc"

#include "ile_ar.inc"
#include "move_pou.inc"
#include "plantes.inc"

#declare cl1=ppcl;

/*** Dfinition de la scne ***/
/******************************/
camera {
	location <-150,93,-165>
	look_at <-180,90,-130>
}

light_source { <15000,33000,-10000> White }

sky_sphere { S_Cloud1 }

global_settings { assumed_gamma 2.2
		ambient_light White*2
}

/*** Dfinition des objets ***/
/*****************************/

object { Ile }
object { Papier_Russe
	scale 0.8
	translate <0,15,0>
	rotate x*(12+sin(cl1*3*pi)*2)
	rotate z*(4+sin(cl1*4*pi)*3)
	translate <-205,83-15,-149>
}

/*** Fait l'arrive du poussin ***/
/*********************************/

#local F_Arrive=0.55;

#local XPFin=40;
#local YPFin=120;
#local PPou=<-180,84,-124>;

#if(cl1<F_Arrive)
	#declare cl2=1-cl1/F_Arrive;

	#declare N_Pas=4;
	#declare OuverturePaupiere=0.7;
	#declare DistanceFixe=750;	// Distance de l'object regard
	#declare FixeAngleX=0;        	// Angle de l'objet regard en X (+ = Gauche)
	#declare FixeAngleY=14;        	// Angle de l'objet regard en Y (+ = Haut)
	#declare TeteAngleX=0;		// Angle de la teste en X (+ = Droite)
	#declare TeteAngleY=0;		// Angle de la teste en Y (+ = Haut )
	#declare PatteG=sin(cl2*pi*N_Pas)*sqrt(cl2);
	#declare PatteD=-sin(cl2*pi*N_Pas)*sqrt(cl2);
	Bas_Aile(cl2*N_Pas)
	BougeCoup(cl2*N_Pas)	

	#include "poussin.inc"

	object { Poussin
		rotate y*18.435
		rotate z*sin(cl2*2*pi*N_Pas)*5
		scale 2.5
		translate PPou
		translate <cl2*cl2*XPFin,sin(cl2*2*pi*N_Pas)*cl2*2.5+cl2*3,cl2*cl2*YPFin>
	}
#end

/*** Fait le poussin qui regarde ***/

#if(cl1>=F_Arrive)
	#declare cl2=(cl1-F_Arrive)/(1-F_Arrive);

	#declare Grosseur_Joues=0.3+0.2*cl2; 	// Entre 0 et 1 (0=Pas de Joues)
	#declare Dim_Pupille=0.3;    	// Entre 0 et 1 (0=Petit)
	#declare Ouverture_Bec=0.25+cl2*0.45;  	// Entre 0 et 1 (1=ouvert)
	#declare OuverturePaupiere=0.7+cl2*0.1; // Entre 0 et 1 (0=Ferme)
	#declare DistanceFixe=1700;	// Distance de l'object regard
	#declare FixeAngleX=sin(cl2*0.5*pi)*5;
	#declare FixeAngleY=cl2*4;
	#declare TeteAngleX=sin(cl2*0.5*pi)*-55;
	#declare TeteAngleY=cl2*16;
	#declare AngleCoup=-6+cl2*15;	// Angle du Coup (+ = Avant )
	#declare PatteG=0;		// Entre -1 et 1 ( Angle de la patte Gauche )
	#declare PatteD=0;		// Entre -1 et 1 ( Angle de la patte Droite )
	Agite_Aile(cl2*2)

	#if(cl2>0.5)
	#if(cl2<0.75)
		ClinYeux( (cl2-0.5)/0.25 , 0.7+cl2*0.1 )
	#end
	#end

	#include "poussin.inc"

	object { Poussin
		rotate y*18.435
		scale 2.5
		translate PPou
	}
#end


/*** Dfinition du Mouvement du Papillon ***/
/*******************************************/

#local PPapi=<-180,94,-130>;

#declare clp=cl1-0.25;
#declare P_Aile=(clp*12);

#local XFin=-40;
#local YFin=-90;

#include "papillon.inc"

object { Papillon
	rotate y*18.435
	rotate <0,sin(clp*6*2*pi)*5,0>
	translate PPapi
	translate <XFin*clp,sin(clp*2*pi*5)*3,YFin*clp>
}
