//third clip - render 144 frames at 320x240, no antialiasing          

#include "colors.inc"

#declare dlock = clock*2+1; //continue clock count from previous clip

#if (clock<.25)
        #declare zco = -cos ( clock * 12.5663706 ) * 4; //z-coordinate for bug's head and focal point
        #declare xco = -5*clock*sin(12.5663706*clock);
        #declare yco = -clock*cos(12.5663706*clock)+(2.5-3*clock);
        #declare theta = -760*clock;
#else 
      #if (clock<.75)
        #declare zco = 4;
        #declare xco = 0;
        #declare yco = 2;
        #declare theta = -180-(clock*40);
      #else
        #declare zco = -cos ( clock * 12.5663706 ) * 2 + 2;
        #declare xco = -5*(clock-.5)*sin(12.5663706*clock);
        #declare yco = -(clock-.5)*cos(12.5663706*clock)+(2.5-3*(clock-.5));
        #declare theta = -760*clock;
      #end
#end

camera {
       location <0,2,0>
       right 2*x
       up 1.5*y
       look_at <0,3,10>
       aperture .8/(5+zco)
       blur_samples 3
       focal_point <xco,yco,5.1-zco>  
       }

light_source { <6000,10000,-12000> color White }

background { SkyBlue }

sphere { <0,-800000,0>,800000
        pigment {Green}
        normal { bumps turbulence .4 scale <.05,1,.05> }
        finish { ambient .1 diffuse .8 specular .2 }
        
        }

sphere { 0,800500
        hollow
        pigment { bozo turbulence .4
                color_map {
                        [0.0 rgbf 1.0]
                        [0.8 rgbf 1.0]
                        [0.99 rgbf <1.0,1.0,1.0,0.4>]
                        [1.0 rgbf <.95,.95,.95,.4>]
                        }
                scale 800
                }
        rotate -10*x
        rotate z*dlock*.006 
        translate <0,-800000,0>
        finish {ambient 1 diffuse 0}
     }

sphere { 0,800600
        hollow
        pigment { bozo turbulence .9
                color_map {
                        [0.0 rgbf 1.0]
                        [0.94 rgbf 1.0]
                        [0.99 rgbf <1.0,1.0,1.0,0.4>]
                        [1.0 rgbf <.95,.95,.95,.4>]
                        }
                scale 1000
                }
        rotate -60*x
        rotate z*dlock*.005 
        translate <0,-800000,0>
        finish {ambient 1 diffuse 0}
     }

#declare Shrub = blob {
        threshold .4
        #declare Count = 0;
        #while (Count < 18 )
                #declare Count2 = 0;
                #while (Count2 < 10)
                        cylinder { <0,3,0>,<3,.5,0>,1.5,1 rotate (Count2*34+Count*141)*y translate (Count-9)*5.7*x }
                        cylinder { <0,3.8,0>,<2.5,2,0>,1.5,1 rotate (Count2*37+Count*139)*y translate (Count-9)*5.7*x }
                        cylinder { <0,5,0>,<2.3,3.5,0>,1.1,1 rotate (Count2*31+Count*140)*y translate (Count-9)*5.7*x }
                        #declare Count2 = Count2 + 1;
                #end
                #declare Count = Count + 1;
        #end
        rotate 14*y
        pigment { agate turbulence .1
                color_map
                {[0.0 MediumForestGreen]
                [1.0 rgb <0,.2,0>] }
                scale .1
                 }
        normal { bumps scale .1}
        finish { diffuse .5 specular .4 roughness .8 }
        }
        
object { Shrub translate <-10,0,50> }

#declare Metal = texture{
        pigment { Gray85 }
        finish { diffuse .3 specular .9 roughness .03 metallic reflection .1}
        }

#declare Saucer = blob{
        threshold .5
                sphere { 0,2.5,1 scale <1,.7,1> }
                sphere { 0,.5,1 scale <12,.65,12> translate <0,-.15,0> }
                #declare Count = 0;
                #while (Count < 7)
                        cylinder { <0,-.04,0>,<2.5,-.14,0>,.6,.3 rotate y*51.4285*Count }
                        cylinder { <1.5,-.04,0>,<2.4,-.14,0>,.3,.3 rotate y*51.4285*(Count+.5) }
                        sphere { <2.5,-.14,0>,.2,.3 rotate y*51.4285*(Count+.3) }
                        sphere { <2.5,-.14,0>,.2,.3 rotate y*51.4285*(Count+.7) }
                        sphere { <2.8,-.11,0>,.2,-.3 rotate y*51.4285*(Count+.3) }
                        sphere { <2.8,-.11,0>,.2,-.3 rotate y*51.4285*(Count+.7) }
                        sphere { <2.8,-.14,0>,.2,.3 rotate y*51.4285*(Count+.5) }
                        cylinder { <2.55,-.08,0>,<2.45,-.14,0>,.2,.8 rotate y*51.4285*(Count+.5) }
                        cylinder { 0,<1.5,.14,0>,.2,.55 rotate y*51.4285*(Count+.5) }
                        #declare Count = Count + 1;
                #end
        rotate dlock*y*-864 
        rotate -30*x
        texture {Metal}
        }

#declare Legs = union {
        #if (clock>.9)
                #declare legmove = (clock - .9)*2;
             #else
                #declare legmove = 0;
        #end
        cone { <0.9,0,0>,.06,<1.1-legmove,-.1,.6>,.045 }
        cone { <1.1-legmove,-.1,.6>,.045,<1.08-legmove,-.52,.8>,.03 }
        cone { <0.9,0,0>,.06,<1.1-legmove,-.1,-.6>,.045 }
        cone { <1.1-legmove,-.1,-.6>,.045,<1.08-legmove,-.52,-.8>,.03 }
        cone { <1.2,0,0>,.06,<1.4,-.1,.7>,.045 }
        cone { <1.4,-.1,.7>,.045,<1.38,-.52,.88>,.03 }
        cone { <1.2,0,0>,.06,<1.4,-.1,-.7>,.045 }
        cone { <1.4,-.1,-.7>,.045,<1.38,-.52,-.88>,.03 }
        sphere { <1.1-legmove,-.1,.6>,.045 }
        sphere { <1.1-legmove,-.1,-.6>,.045 }
        sphere { <1.4,-.1,.7>,.045 }
        sphere { <1.4,-.1,-.7>,.045 }
        }

#declare Bugxture = texture{
        pigment { bozo turbulence .7
                color_map {
                        [0.0 Gray55]
                        [0.5 Tan]
                        [1.0 Wheat]
                        }
                scale .14
                }
        finish { specular .9 roughness .2 reflection .01}
        }

#if (clock<.25)
        #declare Head = <0,0,0>;
#else
        #if (clock>.75)
                #declare Head = <0,0,0>;
        #else
                #if (clock<.275)
                        #declare Head = <(clock-.25)*400,(clock-.25)*1300,0>;
                #else
                    #if (clock<.375)
                        #declare Head = <10,32.5,0>;
                    #else
                        #if (clock<.40)
                            #declare Head = <(clock-.35)*400,(clock-.35)*1300,0>;
                        #else
                            #if (clock>.70)
                                #declare Head = <-400*(clock-.75),-1300*(clock-.75),0>;
                            #else
                                #declare Head = <20,65,0>;
                            #end
                        #end
                    #end
                #end
        #end
#end

#declare Bug = union {
  union{
        blob {
                threshold .4
                sphere {0,.7,1.2 scale <1.10,1,1> translate <0,0,0>}
                cylinder {<-.6,.4,.4>,<.4,.4,.4>,.3,-.3}
                cylinder {<-.6,.4,-.4>,<.4,.4,-.4>,.3,-.3}
                cylinder {<.2,-.3,.45>,<.4,-.3,.45>,.3,-.3}
                cylinder {<.2,-.3,-.45>,<.4,-.3,-.45>,.3,-.3}
                #declare Count = 0;
                #while (Count<20)
                        sphere { <-.3+(Count/160),.3+(Count/120),.16+(Count*Count/200)>,.3-(Count/70),.3}
                        sphere { <-.3+(Count/160),.3+(Count/120),-.16-(Count*Count/200)>,.3-(Count/70),.3}
                        #declare Count = Count + 1;
                #end
                texture { Bugxture }
                rotate Head
              }
         blob
                {threshold .4
                cylinder {<.25,0,0>,<1,0,0>,.35,1}
                sphere {0,.7,1.2 scale <1.15,1,1> translate <1,0,0>}
                sphere {0,.7,1.1 scale <1.20,1,1> translate <2,0,0>}
                cylinder {<2,0,0>,<2.6,-.2,0>,.6,.7}
                cylinder {<.6,.4,.4>,<1.4,.4,.4>,.3,-.3}
                cylinder {<1.6,.4,.4>,<2.6,.4,.4>,.3,-.3}
                cylinder {<.6,.4,-.4>,<1.4,.4,-.4>,.3,-.3}
                cylinder {<1.6,.4,-.4>,<2.6,.4,-.4>,.3,-.3}
                cylinder {<.6,-.3,.45>,<1.4,-.3,.45>,.3,-.3}
                cylinder {<1.6,-.3,.45>,<2.6,-.3,.45>,.3,-.3}
                cylinder {<.6,-.3,-.45>,<1.4,-.3,-.45>,.3,-.3}
                cylinder {<1.6,-.3,-.45>,<2.6,-.3,-.45>,.3,-.3}
                texture { Bugxture }
                } 
        blob {
                threshold .4
                cylinder {<0,-.45,0>,<.1,-.6,.1>,.13,.6}     
                cylinder {<0,-.45,0>,<-.1,-.6,.1>,.13,.6}     
                cylinder {<0,-.45,0>,<.1,-.6,-.1>,.13,.6}     
                cylinder {<0,-.45,0>,<-.1,-.6,-.1>,.13,.6}
                sphere {<0,-5.5,0>,.3,-.6}     
                rotate -45*z
                texture { Bugxture }
                rotate Head
                }
        object { Legs
                texture { Bugxture }
         }
      }
        sphere { 0, 1
                pigment { rgbf 1 }
                finish { specular .1 }
                hollow on
                interior{
                        media { absorption .6
                                density { spherical
                                        color_map{
                                                [0.0 rgb 0]
                                                [0.3 rgb 0.9]
                                                [1.0 rgb 1]
                                                }       
                                         }       
                                density { bozo turbulence .4
                                        color_map{
                                                [0.0 rgb 0]
                                                [0.3 rgb 0.1]
                                                [1.0 rgb 1]
                                                }
                                         scale .3       
                                         }       
                              }
                        
                        }  
                scale <.6,.2,1.5> translate <1,0,1.9> rotate -160*x
                }
        sphere { 0, 1
                pigment { rgbf 1 }
                finish { specular .1 }
                hollow on
                interior{
                        media { absorption .6
                                density { spherical
                                        color_map{
                                                [0.0 rgb 0]
                                                [0.3 rgb 0.9]
                                                [1.0 rgb 1]
                                                }       
                                         }       
                                density { bozo turbulence .4
                                        color_map{
                                                [0.0 rgb 0]
                                                [0.3 rgb 0.1]
                                                [1.0 rgb 1]
                                                }
                                         scale .3       
                                         }       
                              }
                        
                        }  
                scale <.6,.2,1.5> translate <1,0,1.9> rotate -20*x
                }               
        sphere { <-.3,.2,.3>,.2
                pigment { agate turbulence .4
                        color_map {
                        [0.0 Red]
                        [0.6 White]
                        [1.0 Blue]
                        }
                        scale .04 
                        }
                finish { specular .9 }
                rotate Head
                }
        sphere { <-.3,.2,-.3>,.2
                pigment { agate turbulence .4
                        color_map {
                        [0.0 Red]
                        [0.6 White]
                        [1.0 Blue]
                        }
                        scale .04 
                        }
                finish { specular .9 }
                rotate Head
                }
        }
               
object {
  Saucer
  texture {Metal}
  translate <0,4-sin(dlock*20-4)/8,10>
  }

object {
  Bug scale .4  
  rotate theta*y
  translate <xco,yco,5.1-zco>
  }
