//sixth clip - render 24 frames at 320x240, no antialiasing          

#include "colors.inc"

#declare elock = clock/3+13/3; //continue elock count from previous clip
#declare dlock = clock/6+13/6; //continue dlock count from previous clip

camera {
       location <0,2,0>
       right 2*x
       up 1.5*y
       look_at <0,3,10>
       aperture .16
       blur_samples 4
       focal_point <0,.5,5.1>  
       }

light_source { <6000,10000,-12000> color White }

background { SkyBlue }


#declare Shoeleather =  texture {
          pigment { bozo turbulence .4
                color_map {
                [0.0 Wheat]
                [0.1 White]
                [0.9 White]
                [0.99 rgb <.95,1,.9>]
                [1.0 rgb <.8,.9,.7>] 
                }
                scale <.2,.1,.2>
              }
          normal { dents turbulence .2 scale .3 }
          finish { diffuse .8 specular .2 }
        }
                
#declare Shoe = union {
        difference {
          blob {  threshold .3
                sphere { 0,1.25,1 scale <1.2,1,1> rotate 25*y scale <1.1,.8,1> translate <-.75,0,0> }
                sphere { 0,1.2,1 scale <1.1,1,.9> translate <1,.1,0> }
                }
          box { <100,-.4,100>,<-100,-5,-100> }
          texture { Shoeleather }
          }
        difference {
          blob {  threshold .3
                sphere { 0,1.25,1 scale <1.2,1,1> rotate 25*y scale <1.1,.8,1> translate <-.75,0,0> }
                sphere { 0,1.2,1 scale <1.1,1,.9> translate <1,.1,0> }
                scale <.92,5,.92>
                }
          box { <100,-.3,100>,<-100,5,-100> rotate 4*z}
          box { <100,-.5,100>,<-100,-5,-100> }
          #declare Count = 0;
          #while (Count < 20)
                cylinder { <2-Count/5,-.5,-100>,<2-Count/5,-.5,100>,.04 }
                #declare Count = Count + 1;
          #end
          pigment { Gray30 }
          finish { diffuse .6 specular .4 }
          }
        intersection {
          difference {
            cylinder { <0,0,-1>,0, .1 scale <2,1,1> rotate -20*z translate <.32,0,0>}
            cylinder { 0,<0,0,-2>, .07 scale <2,1,1> rotate -25*z translate <.3,.06,0> }
            }
          blob {  threshold .3
                sphere { 0,1.25,1 scale <1.2,1,1> rotate 25*y scale <1.1,.8,1> translate <-.75,0,0> }
                sphere { 0,1.2,1 scale <1.1,1,.9> translate <1,.1,0> }
                scale 1.015
                }
            pigment { NewMidnightBlue }
          finish { diffuse .8 specular .2 }
          }
        intersection {
          sphere { <-2,-2.8,0>,3.45 }
          box { <100,-.4,100>,<-100,5,-100> }
          blob {  threshold .3
                sphere { 0,1.25,1 scale <1.2,1,1> rotate 25*y scale <1.1,.8,1> translate <-.75,0,0> }
                sphere { 0,1.2,1 scale <1.1,1,.9> translate <1,.1,0> }
                scale 1.07
                }
          texture { Shoeleather }
          finish { diffuse .8 specular .2 }
          }
        scale 4.4  translate <-1.6,3,0>
        }
#if (clock<.15)
        #declare Shoeheight = clock*37;
        cylinder { <5,Shoeheight+3,7>,<30,8,11>,2 pigment {Black} finish {diffuse .1} }
        object { Shoe translate <0,Shoeheight,5.1>}
#else
        #declare Shoeheight = 0;
#end          

sphere { <0,-800000,0>,800000
        pigment {Green}
        normal { bumps turbulence .4 scale <.05,1,.05> }
        finish { ambient .1 diffuse .8 specular .2 }
        
        }
     
sphere { 0,800500
        hollow
        pigment { bozo turbulence .4
                color_map {
                        [0.0 rgbf 1.0]
                        [0.8 rgbf 1.0]
                        [0.99 rgbf <1.0,1.0,1.0,0.4>]
                        [1.0 rgbf <.95,.95,.95,.4>]
                        }
                scale 800
                }
        rotate -10*x
        rotate z*elock*.006 
        translate <0,-800000,0>
        finish {ambient 1 diffuse 0}
     }

sphere { 0,800600
        hollow
        pigment { bozo turbulence .9
                color_map {
                        [0.0 rgbf 1.0]
                        [0.94 rgbf 1.0]
                        [0.99 rgbf <1.0,1.0,1.0,0.4>]
                        [1.0 rgbf <.95,.95,.95,.4>]
                        }
                scale 1000
                }
        rotate -60*x
        rotate z*elock*.005 
        translate <0,-800000,0>
        finish {ambient 1 diffuse 0}
     }

#declare Shrub = blob {
        threshold .4
        #declare Count = 0;
        #while (Count < 18 )
                #declare Count2 = 0;
                #while (Count2 < 10)
                        cylinder { <0,3,0>,<3,.5,0>,1.5,1 rotate (Count2*34+Count*141)*y translate (Count-9)*5.7*x }
                        cylinder { <0,3.8,0>,<2.5,2,0>,1.5,1 rotate (Count2*37+Count*139)*y translate (Count-9)*5.7*x }
                        cylinder { <0,5,0>,<2.3,3.5,0>,1.1,1 rotate (Count2*31+Count*140)*y translate (Count-9)*5.7*x }
                        #declare Count2 = Count2 + 1;
                #end
                #declare Count = Count + 1;
        #end
        rotate 14*y
        pigment { agate turbulence .1
                color_map
                {[0.0 MediumForestGreen]
                [1.0 rgb <0,.2,0>] }
                scale .1
                 }
        normal { bumps scale .1}
        finish { diffuse .5 specular .4 roughness .8 }
        }
        
object { Shrub translate <-10,0,50> }      

#declare Metal = texture{
        pigment { Gray85 }
        finish { diffuse .3 specular .9 roughness .03 metallic reflection .1}
        }

#declare Saucer = blob{
        threshold .5
                sphere { 0,2.5,1 scale <1,.7,1> }
                sphere { 0,.5,1 scale <12,.65,12> translate <0,-.15,0> }
                #declare Count = 0;
                #while (Count < 7)
                        cylinder { <0,-.04,0>,<2.5,-.14,0>,.6,.3 rotate y*51.4285*Count }
                        cylinder { <1.5,-.04,0>,<2.4,-.14,0>,.3,.3 rotate y*51.4285*(Count+.5) }
                        sphere { <2.5,-.14,0>,.2,.3 rotate y*51.4285*(Count+.3) }
                        sphere { <2.5,-.14,0>,.2,.3 rotate y*51.4285*(Count+.7) }
                        sphere { <2.8,-.11,0>,.2,-.3 rotate y*51.4285*(Count+.3) }
                        sphere { <2.8,-.11,0>,.2,-.3 rotate y*51.4285*(Count+.7) }
                        sphere { <2.8,-.14,0>,.2,.3 rotate y*51.4285*(Count+.5) }
                        cylinder { <2.55,-.08,0>,<2.45,-.14,0>,.2,.8 rotate y*51.4285*(Count+.5) }
                        cylinder { 0,<1.5,.14,0>,.2,.55 rotate y*51.4285*(Count+.5) }
                        #declare Count = Count + 1;
                #end
        rotate -30*x
        texture {Metal}
        }     

#declare Legs = union {
        #declare legmove = 0;
        cone { <0.9,0,0>,.06,<1.1-legmove,-.1,.6>,.045 }
        cone { <1.1-legmove,-.1,.6>,.045,<1.08-legmove,-.1,1.1>,.03 }
        cone { <0.9,0,0>,.06,<1.1-legmove,-.1,-.6>,.045 }
        cone { <1.1-legmove,-.1,-.6>,.045,<1.08-legmove,-.1,-1.1>,.03 }
        cone { <1.2,0,0>,.06,<1.4,-.1,.7>,.045 }
        cone { <1.4,-.1,.7>,.045,<1.38,-.1,1.18>,.03 }
        cone { <1.2,0,0>,.06,<1.4,-.1,-.7>,.045 }
        cone { <1.4,-.1,-.7>,.045,<1.38,-.1,-1.18>,.03 }
        }

#declare Bugxture = texture{
        pigment { bozo turbulence .7
                color_map {
                        [0.0 Gray55]
                        [0.5 Tan]
                        [1.0 Wheat]
                        }
                scale .14
                }
        finish { specular .9 roughness .2 reflection .01}
        }

#declare Wing = 
union {
      polygon {4,<0,0,0>,<.8,.4,.3>,<.4,.2,-.5>,<0,0,0>}
      polygon {4,<1,.4,-.65>,<.8,.4,.3>,<.4,.2,-.5>,<1,.4,-.65>}
      polygon {4,<1,.4,-.65>,<.8,.4,.3>,<1.25,.4,.15>,<1,.4,-.65>}
      polygon {4,<1,.4,-.65>,<1.3,.4,-.7>,<1.25,.4,.15>,<1,.4,-.65>}
      polygon {4,<1.7,.4,0>,<1.3,.4,-.7>,<1.25,.4,.15>,<1.7,.4,0>}
      polygon {4,<1.7,.4,0>,<1.3,.4,-.7>,<1.725,.4,-.5>,<1.7,.4,0>}
      polygon {4,<1.7,.4,0>,<2,.4,-.3>,<1.725,.4,-.5>,<1.7,.4,0>}
      cylinder {<.8,.4,.3>,0,.007}
      cylinder {<.8,.4,.3>,<.4,.2,-.5>,.007}
      cylinder {<.8,.4,.3>,<1,.4,-.65>,.007}
      cylinder {<.8,.4,.3>,<1.25,.4,.15>,.007}
      cylinder {<1.7,.4,0>,<1.25,.4,.15>,.007}
      cylinder {<1.7,.4,0>,<1.3,.4,-.7>,.007}
      cylinder {<1.7,.4,0>,<1.725,.4,-.5>,.007}
      cylinder {<1.7,.4,0>,<2,.4,-.3>,.007}  
    rotate <0,0,5>
    translate <0,.14,0>     
    pigment { color rgbt <.8,.75,.95,.8> }
    normal {bumps turbulence .3 scale .2}
    finish { ambient .1 diffuse .2 specular .9}            
    }                    

#declare Bug = union {
  union{
        blob {
                threshold .4
                sphere {0,.7,1.2 scale <1.10,1,1> translate <0,0,0>}
                cylinder {<-.6,.4,.4>,<.4,.4,.4>,.3,-.3}
                cylinder {<-.6,.4,-.4>,<.4,.4,-.4>,.3,-.3}
                cylinder {<.2,-.3,.45>,<.4,-.3,.45>,.3,-.3}
                cylinder {<.2,-.3,-.45>,<.4,-.3,-.45>,.3,-.3}
                #declare Count = 0;
                #while (Count<20)
                        sphere { <-.3+(Count/160),.3+(Count/120),.16+(Count*Count/200)>,.3-(Count/70),.3}
                        sphere { <-.3+(Count/160),.3+(Count/120),-.16-(Count*Count/200)>,.3-(Count/70),.3}
                        #declare Count = Count + 1;
                #end
                texture { Bugxture }
              }
         blob
                {threshold .4
                cylinder {<.25,0,0>,<1,0,0>,.35,1}
                sphere {0,.7,1.2 scale <1.15,1,1> translate <1,0,0>}
                sphere {0,.7,1.1 scale <1.20,1,1> translate <2,0,0>}
                cylinder {<2,0,0>,<2.6,-.2,0>,.6,.7}
                cylinder {<.6,.4,.4>,<1.4,.4,.4>,.3,-.3}
                cylinder {<1.6,.4,.4>,<2.6,.4,.4>,.3,-.3}
                cylinder {<.6,.4,-.4>,<1.4,.4,-.4>,.3,-.3}
                cylinder {<1.6,.4,-.4>,<2.6,.4,-.4>,.3,-.3}
                cylinder {<.6,-.3,.45>,<1.4,-.3,.45>,.3,-.3}
                cylinder {<1.6,-.3,.45>,<2.6,-.3,.45>,.3,-.3}
                cylinder {<.6,-.3,-.45>,<1.4,-.3,-.45>,.3,-.3}
                cylinder {<1.6,-.3,-.45>,<2.6,-.3,-.45>,.3,-.3}
                texture { Bugxture }
                } 
        blob {
                threshold .4
                cylinder {<0,-.45,0>,<.1,-.6,.1>,.13,.6}     
                cylinder {<0,-.45,0>,<-.1,-.6,.1>,.13,.6}     
                cylinder {<0,-.45,0>,<.1,-.6,-.1>,.13,.6}     
                cylinder {<0,-.45,0>,<-.1,-.6,-.1>,.13,.6}
                sphere {<0,-5.5,0>,.3,-.6}     
                rotate -5*z
                texture { Bugxture }
                }
        object { Legs
                texture { Bugxture }
         }
      }
        //object { Wing rotate 90*y scale <-1,8,2>  translate <1,.1,-.17> }      try only one wing
        object { Wing rotate 90*y scale <-1,1,-2> translate <1,.1,.17>}  
        sphere { <-.3,.2,.3>,.2
                pigment { agate turbulence .4
                        color_map {
                        [0.0 Red]
                        [0.6 White]
                        [1.0 Blue]
                        }
                        scale .04 
                        }
                finish { specular .9 }
                }
        sphere { <-.3,.2,-.3>,.2
                pigment { agate turbulence .4
                        color_map {
                        [0.0 Red]
                        [0.6 White]
                        [1.0 Blue]
                        }
                        scale .04 
                        }
                finish { specular .9 }
                }
        }
               
object {
  Saucer
  texture {Metal}
  translate <0,0,10>
  }    

object {
  Saucer
  texture {Metal}
  rotate 33*x
  scale <1.05,.1,1.05>
  translate <0,.1,10>
  }    

object {
  Bug scale .4
  scale <1.05,.1,1.05>  
  rotate -760*y
  translate <0,.1,5.1>
  }
