//camera {
//location <3,3,3>
//   look_at<0,1,0>}
//light_source { <200,200,200> color rgb <1,1,1> }

//#declare bl=0       //body length
//#declare fw = 0    //width of feet
//#declare bbr = 0    //back body rotation
//#declare fbr = 0    //front body rotation
//#declare fl = .01   //length to foot
//#declare ho = <-.2,.15,0> //head offset from body

//#declare hr = <0,0,0>   //head rotation

//#declare rel = <0,0,10>  //eye lid opening
//#declare lel = <0,0,40>

//body positions

#declare fbp = <0,0,0>
#declare bbp = fbp + <-bl,0,0>
//feet positions
#declare lrf = bbp + vrotate(<0,0,fw>,bbr) - <.3,fl,0>
#declare rrf = bbp + vrotate(<0,0,-fw>,bbr)- <.3,fl,0>
#declare lff = fbp + vrotate(<0,0,fw>,fbr)- <-.3,fl,0>
#declare rff = fbp + vrotate(<0,0,-fw>,fbr)- <-.3,fl,0>
#declare hp = fbp + ho

//blob texture
#declare bt = texture {
pigment {granite scale .1}
finish {reflection .2 specular .1}}

#declare creat = union {
blob {
threshold .1
//body parts
sphere {<0,0,0>,1,1 rotate fbr translate fbp}
sphere {<0,0,0>,1,1 rotate bbr translate bbp}
//legs
cylinder {lrf,lrf+<0,fl,0>,.3,1}
cylinder {rrf,rrf+<0,fl,0>,.3,1}
cylinder {lff,lff+<0,fl,0>,.3,1}
cylinder {rff,rff+<0,fl,0>,.3,1}

//feet
sphere {<.25,-.45,0>,1,1 scale <.5,.2,.3> translate lrf}
sphere {<.25,-.45,0>,1,1 scale <.5,.2,.3> translate rrf}
sphere {<.25,-.45,0>,1,1 scale <.5,.2,.3> translate lff}
sphere {<.25,-.45,0>,1,1 scale <.5,.2,.3> translate rff}

//neck
cylinder {fbp,hp,.3,1}
//head
sphere {<.5,0,0>,1,1 scale <.5,.75,.5> rotate hr translate hp}
//nose
sphere {<1,-.5,0>,1,1 scale <.5,.5,.5> rotate hr translate hp}
texture {
pigment {granite scale .1}
finish {reflection .2 specular .1}}
}

//eyes
sphere {<.5,.5,.15>,.15 rotate hr translate hp pigment {rgb<1,1,1>}}
sphere {<.5,.5,-.15>,.15 rotate hr translate hp pigment {rgb<1,1,1>}}

sphere {<.6,.5,.15>,.07 rotate hr translate hp }
sphere {<.6,.5,-.15>,.07 rotate hr translate hp}



//left eye lids
union {
sphere {<0,0,0>,.18 clipped_by {plane {<0,1,0>,0}} rotate -lel translate <.5,.5,.15> rotate hr translate hp}
sphere {<0,0,0>,.18 clipped_by {plane {<0,-1,0>,0}} rotate lel translate <.5,.5,.15> rotate hr translate hp}
texture {
pigment {granite scale .1}
finish {reflection .2 specular .1}}

}


//right eye lids
union {
sphere {<0,0,0>,.18 clipped_by {plane {<0,1,0>,0}} rotate -rel translate <.5,.5,-.15> rotate hr translate hp}
sphere {<0,0,0>,.18 clipped_by {plane {<0,-1,0>,0}} rotate rel translate <.5,.5,-.15> rotate hr translate hp}
texture {
pigment {granite scale .1}
finish {reflection .2 specular .1}}

}

}
//end of union
