//frames 97 - 228 5.5 secs

camera {
location <2,2.5,5>
   look_at<.5,1.5,0>}
light_source { <200,200,200> color rgb <1.2,1.2,1.2> }


//#declare cl = 1
#switch(cl)
//rolling
#range(0,1)

#declare bl=0       //body length
#declare fw = 0    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = .01   //length to foot
#declare ho = <-.2,.15,0> //head offset from body
#declare hr = <0,0,0>   //head rotation
#declare rel = <0,0,0>  //eye lid opening
#declare lel = <0,0,0>
#declare rp = <(1-cl)*(1-cl)*4,1.2,0>
#declare rr = <0,0,rp.x*-114.59>
#break

//body moving apart
#range (1,1.4)
#declare bl=cos((cl-1)*pi*2/.8)*-.4+.4       //body length
#declare fw = cos((cl-1)*pi*2/.8)*-.25+.25    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = .01   //length to foot
#declare ho = <-.2,.15,0> //head offset from body
#declare hr = <0,0,0>   //head rotation
#declare rel = <0,0,0>  //eye lid opening
#declare lel = <0,0,0>
#declare rp = <0,1.2,0>
#declare rr = <0,0,0>
#break
//legs growing
#range (1.4,1.8)
#declare bl=.8       //body length
#declare fw = .5    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = cos((cl-1.4)*pi*2/.8) * -.5 +.5  //length to foot
#declare ho = <-.2,.15,0> //head offset from body
#declare hr = <0,0,0>   //head rotation
#declare rel = <0,0,0>  //eye lid opening
#declare lel = <0,0,0>
#if (cl<1.6)
#declare rp = <0,1.2,0>
#else
#declare rp = <0,1.2+cos((cl - 1.4)*pi*2/.8)*-.5,0>
#end
#declare rr = <0,0,0>
#break

//head expanding

#range (1.8,2.2)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = 1   //length to foot
#declare ho = <-.2+cos((cl-1.8)*pi*2/.8)*-.6+.6,.15+cos((cl-1.8)*pi*2/.8)*-.175 + .175,0> //head offset from body
#declare hr = <0,0,0>   //head rotation
#declare rel = <0,0,0>  //eye lid opening
#declare lel = <0,0,0>
#declare rp = <0,1.7,0>
#declare rr = <0,0,0>
#break

//eye opening
#range (2.2,2.6)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = 1   //length to foot
#declare ho = <1,.5,0> //head offset from body
#declare hr = <0,0,0>   //head rotation
#declare rel = <0,0,cos((cl-2.2)*pi*2/.8)*-10+10>  //eye lid opening
#declare lel = <0,0,cos((cl-2.2)*pi*2/.8)*-10+10>
#declare rp = <0,1.7,0>
#declare rr = <0,0,0>
#break

//eye hold

#range (2.6,2.8)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = 1   //length to foot
#declare ho = <1,.5,0> //head offset from body
#declare hr = <0,0,0>   //head rotation
#declare rel = <0,0,20>  //eye lid opening
#declare lel = <0,0,20>
#declare rp = <0,1.7,0>
#declare rr = <0,0,0>
#break

//eye blink 
#range (2.8,3)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = 1   //length to foot
#declare ho = <1,.5,0> //head offset from body
#declare hr = <0,0,0>   //head rotation
#declare rel = <0,0,20-sin((cl-2.8)*pi*7.5)*20>  //eye lid opening
#declare lel = <0,0,20-sin((cl-2.8)*pi*7.5)*20>
#declare rp = <0,1.7,0>
#declare rr = <0,0,0>
#break

//look at board 
#range (3,3.5)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = 1   //length to foot
#declare ho = <1,.5,cos((cl-3)*pi*2)*.25-.25> //head offset from body

#declare hr = <0,cos((cl-3)*pi*2)*-45+45,0>   //head rotation

#declare rel = <0,0,40>  //eye lid opening
#declare lel = <0,0,40>
#declare rp = <0,1.7,0>
#declare rr = <0,0,0>
#break

//pause

#range (3.5,4)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = 1   //length to foot
#declare ho = <1,.5,-.5> //head offset from body
#declare hr = <0,90,0>   //head rotation
#declare rel = <0,0,40>  //eye lid opening
#declare lel = <0,0,40>
#declare rp = <0,1.7,0>
#declare rr = <0,0,0>
#break


//turn to camera
#range (4,4.5)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = 1   //length to foot
#declare ho = <1,.5,cos((cl-4)*pi*2)*-.5> //head offset from body
#declare hr = <0,cos((cl-4)*pi*2)*77.5+12.5,0>   //head rotation
#declare rel = <0,0,40>  //eye lid opening
#declare lel = <0,0,40>
#declare rp = <0,1.7,0>
#declare rr = <0,0,0>
#break

//shake head

#range (4.5,5.5)
#declare bl= .8       //body length
#declare fw = .5    //width of feet
#declare bbr = 0    //back body rotation
#declare fbr = 0    //front body rotation
#declare fl = 1   //length to foot
#declare ho = <1,.5,.5> //head offset from body
#declare hr = <cos((cl-4.5)*pi*6)*10-10,-65,cos((cl-4.5)*pi*6)*-10+10>   //head rotation
#declare rel = <0,0,40>  //eye lid opening
#declare lel = <0,0,40>
#declare rp = <0,1.7,0>
#declare rr = <0,0,0>
#break


#end


#include "rockcreature.inc"

union {
object {creat rotate rr translate rp}

//sand

blob {
threshold .5
sphere {<0,0,0>,1,1 scale <50,1,50>}

#if (cl<1)
//depretion
cylinder {<6,1.2,0>,rp,1,-1}
//mound near depretion
cylinder {<6,.1,0>,<rp.x,.1,0>,1.2,.4 }
#else
//depretion
cylinder {<6,1.2,0>,<0,1.2,0>,1,-1}
//mound near depretion
cylinder {<6,.1,0>,<0,.1,0>,1.2,.4 }
#end

pigment {rgb <1,1,0>}
normal {bumps .1 scale .02}
}
rotate <0,0,5>
}
//post card
union {
triangle {<0,0,0>,<1,0,0>,<1,1,0>}
triangle {<0,0,0>,<1,1,0>,<0,1,0>}
pigment {
image_map {
tga "hawaiihf.tga"
}
}
rotate <-90,0,0>
scale 1.5
translate <1,1,3.1>
}

//surf board
#include "surf board.inc"
object {surfboard
scale .15
rotate <90,10,-80>
translate <2,3,-18>
finish {ambient 1}
}


//water

plane {<0,1,0>,.1113
pigment {rgb <.5,.75,1>}

finish {reflection .4 diffuse .6}
normal {
average 
normal_map {
[1 bumps .1 scale .2 translate <clock,0,0>]
[1 bumps .1 scale .2 translate <clock,0,0> rotate <0,80,0>]
[1 bumps .1 scale .2 translate <clock,0,0> rotate <0,63,0>]
[1 bumps .1 scale .2 translate <clock,0,0> rotate <0,255,0>]
}
}
}



//sky
#include "colors.inc"
#include "skies.inc"
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.749, 0.847> ] // horizon
            [0.25 P_Cloud2 scale 0.25 rotate z*5]
            [0.60 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}
