#declare exploClock = (decayClock-.8)/.10; 
#declare dustClock  = (decayClock-.81)/.15; 


#declare Flame = 
box {-4,4
  pigment { rgbt<1, 1, 1, 1>  }
  interior {
    media {
      emission 1.7  // transparancy of the light
      intervals 10
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      density {
        spherical
        ramp_wave 
        turbulence  exploClock*20
        color_map {
          [0.0 color rgb <0, 0, 0>]
          [0.1 color rgb <1, 0, 0>]
          [0.7 color rgb <1, 1, 0>]
          [1.0 color rgb <0, 0, 1>]
        } 
      } 
    } 
  }
  hollow on
}

 
#declare Dust = 
box {-4,4
  pigment { rgbt<1, 1, 1, 1>  }
  interior {
    media {
      emission 3//*sin(radians(180*exploClock))  // transparancy of the light
      intervals 10
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      density {
        spherical
        ramp_wave 
        turbulence  dustClock*25
        color_map {
          [0.0 color rgb  0 ]
          [0.1 color rgb .1 ]
          [0.7 color rgb .3 ]
          [1.0 color rgb .2 ]
        }rotate 30*y 
      } 
    } 
  }
  hollow on
} 


#switch (decayClock)
  #range (.8,.9)
//    union
    //{
      //light_source { 0 color Orange*3*sin(radians(180*exploClock)) fade_distance 7.5 fade_power 3.5}
      object {Flame //}
      scale min(2,exploClock*20)
      translate <71,6,38.75>
    }
    #break
#end
#switch (decayClock)
  #range (.81,.96)
    object {Dust scale min(2,dustClock*20) translate <71,6-max(0,(dustClock-.5)*3),38.75> }
    #break
#end

