// declare dancing flame column variables
#declare flameThreshold = 4;
#declare flameClock = mod(decayClock*6*3,6);
#declare flameLength = 3;

//declare a static flame
#declare flameLine =  cylinder{ 
    flameLength*y, 0*y,  .75 
  
    pigment { rgbt<1, 1, 1, 1>  }
    interior {
      media {
        emission 3 //1.7  // transparancy of the light
        intervals 10
        samples 1, 10
        confidence 0.9999
        variance 1/1000
        density {
          //spherical
          cylindrical
          ramp_wave 
          turbulence 1
          color_map {
            [0.0 color rgb <0, 0, 0>]
            [0.1 color rgb <1, 0, 0>]
            [0.7 color rgb <1, 1, 0>]
            [1.0 color rgb <0, 0, 1>]
          } scale <.3,.35,.3>
        } translate decayClock*y*90 //move the media within the column to make it look like it is rising
      } 
    } //end pigment
  
  hollow on

  #if(flameFadeOn=1)
    //This is the point when the line should begin to fade to 0.
    #if (flameClock>flameThreshold)
      scale <1.00001-(flameClock-flameThreshold)*.5, 1, 1.00001-(flameClock-flameThreshold)*.5>
    #end
  #end

} 


//How bright should each individual point light in the column be? 
#if (decayClock<.95)
  #declare flameBright = 3/flameCount;
#else
  #declare flameBright = (3*(1-(decayClock-.95)/.05))/flameCount; 
#end

#declare flameColorBase  = rgb <1, .5, .05>;

#if (flameFadeOn=1)
  #if (flameClock<flameThreshold)
    #declare FlameColor = color flameColorBase * flameBright;
  #else
    #declare FlameColor = color flameColorBase *(flameBright-((flameClock-flameThreshold)*flameBright*(1/6-flameThreshold)));
  #end
#else
  #declare FlameColor = color flameColorBase * flameBright;
#end

//This goes from <0,0,0> to <0,-flameLength,0>
#declare FlameLight = union
{
    #declare index = 0;
    #while (index < flameCount)
      light_source { (-1*flameLength*index/flameCount)*y color FlameColor fade_distance 10.5 fade_power 3.5 }
      #declare index = index + 1; // increment our counter
    #end
    object {flameLine translate flameLength*y*-1} 
    
    // height 0*y = origin of flame source
    #if (flameFadeOn=1)
      translate flameClock*y
    #else //flame is totally out of the flame source
      translate (flameLength+1)*y
    #end
}

