#declare Column = union {
  torus { 1   0.1 translate 5.95*y }
  torus { .95 0.1 translate 5.80*y }
  torus { .90 0.1 translate 5.65*y }
  cylinder {0 6*y .9}
  torus { .90 0.1 translate .35*y }
  torus { .95 0.1 translate .20*y }
  torus { 1   0.1 translate .05*y }
}



#declare GasPipe = union
{
  difference 
  {
    cylinder { -3*y,   1.3*y, .55  }  //total pipe height 1.3
    cylinder { -2.9*y, 1.4*y, .5 }
  }
  cylinder { -9*y, -3*y, .25 }
  cylinder { -9*y, -7*y, .75 }
}



#declare IronGate = union {
  cylinder { <-.2,-1, 2.166> <-.2,8,2.166> .1 } //vertical
  cylinder { <-.2,-1, 1.33>  <-.2,8,1.33> .1  } //vertical
  cylinder { <-.2,5,  3>     <-.2,5,  0.5> .1   }
  cylinder { <-.2,3,  3>     <-.2,3,  0.5> .1   }
  cylinder { <-.2,7.5,3>     <-.2,7.5,0.5> .1   }
  cylinder { <-.2,0.5,3>     <-.2,0.5,0.5> .1   }
}

 

#declare ThroneArm = blob
{
  threshold 0.6
  cylinder { -z, +z, 1, 1}
  cylinder { -1.1*z, 1.1*z, .5, -.5 }
  cylinder { -z, +z, .3, 1 }
  cylinder { -1.3*z, 1.3*z, .18, -.5 }
  scale <1.7,2,2>
}



#declare bloodTexture = texture {
      ripples  
      texture_map {
        [0.1 pigment {color rgb <.7, .2, .1>}]
        [0.7 T_Grnt23a]
      } scale <1,3,1>
      turbulence <1,1,1>
}  

#declare ThroneBody = union {
  object {ThroneArm translate <-2.1,2.5,0>}
  object {ThroneArm translate < 2.1,2.5,0>}
  
  difference {
    box {<-1.9,0,-2.2>, <1.9,2,2.2>}
    sphere { <0,0,-2.6> 1.5 }
  }

  box {<-2.2,0,2.1>, <2.2,5,3>}
}

#declare Throne = object {ThroneBody scale <.9,1,.65> }


#declare chair = union {
  union {
    cylinder { 0*y 6*y .1 translate < 1,0, 2>}//back
    cylinder { 0*y 6*y .1 translate <-1,0, 2>}
    cylinder { 0*y 2*y .1 translate < 1,0,.2>}//front
    cylinder { 0*y 2*y .1 translate <-1,0,.2>}
    cylinder {-1*x 1*x .1 translate < 0,2,.2>}//seat
    cylinder {-1*x 1*x .1 translate < 0,2, 2>}
    cylinder {.2*z 2*z .1 translate <-1,2, 0>}//seat
    cylinder {.2*z 2*z .1 translate < 1,2, 0>}  
    texture {T_Wood14 scale 5 rotate 90*z}
  }
  union {
    sphere   {0 1 scale <1,2,.2> translate <0,4,2>}
    superellipsoid { <.5,.5>
      scale <.9,.2,.85>
      translate <0,2,1.1>
    }
    pigment { Sapphire_Agate }
    finish { ambient Blue } 
  }
  translate -.1*y
}
