/* leaf4.pov - POV-Ray 3.1 rendering after the rendering after the... Well, 
	       you get the idea. This continues the snow accumulation.
Created:     9/28/1999 (derived from leaf3.pov)
Last edited: 10/7/1999
By:          William de Beaumont <amdebe1@ulster.net>
*/
#include "colors.inc"

//-------------only minor timing changes until next divider-------------------

#declare leafrot=
 texture
 {
  normal {wrinkles 1.2}
  pigment
  { bozo
    color_map
    {
     [0.0 rgb <.8,.8,.6>]
     [1.0 rgb <.9,.9,.7>]
   }
  }
 }

camera
{
 location <5,-19,-5>
 look_at <0,-24,0>
} 

#if (clock>.8)
 light_source {<50,100,-100> color <1-(clock-.8)*5,1-(clock-.8)*5,1-(clock-.8)*5>}
#else 
 light_source {<50,100,-100> color White}
#end

plane
{ -y,-50
  #if (clock>.8)
   finish {ambient .8*5*(-clock+1)}
  #else
   finish {ambient .8}
  #end
  pigment
  {
   bozo
   color_map
   {
     [0.0 rgb <1,1,1>]
     [0.1 rgb <.8,.8,.9>]
     [1.0 rgb <1,1,1>]
   }
   translate x*(clock+4)*10
   rotate y*20
   scale 100
  }
  scale 10
} 

plane 
{ y,-30
 texture  
 { 
  #if (clock>.8)
   finish {ambient .3*5*(-clock+1)}
  #else
   finish {ambient .3}
  #end
  pigment
  {
   bozo
   color_map
   {
/*    [0.0 rgb <.1,.5,.2>]
    [1.0 rgb <0,.8,.3>]*/
    [0.0 rgb <.65,.65,.55>]
    [1.0 rgb <.6,.6,.5>]
   }
  }
  //normal { bumps 1 scale 0.1 }
  //normal { bumps 1 scale 0.01 }
  normal {bumps 1 scale 0.05}
  scale 10
 } 
}

fog
{
 distance 300
 #if (clock>.8)
  color Gray75*5*(clock-.8)
 #else
  color Gray75
 #end
 fog_type 2
 fog_offset 25
 fog_alt 25
}

#declare leaf=
 union
 {
  intersection
  {
   torus {4.92,.1 rotate z*90 translate y*-4.5}
   box {<-1,-1,-3>,<1,1,5>}
  }
  intersection
  {
   difference
   {
    cylinder {<-2,-4.5,0>,<2,-4.5,0>,5}
    cylinder {<-3,-4.5,0>,<3,-4.5,0>,4.95}
   }
   union
   {
    cone {<0,.5,0>,2,<0,-1,-4>,0}
    intersection
    {
     cylinder {<0,-3,0>,<0,3,0>,2}
     box {<-3,-4,0>,<3,4,3>}
    }
   }
  }
 }

#declare cs=seed(clock*10000);

object 
{leaf
 texture {leafrot}
 rotate z*180
 translate -y*24
} 

#declare s1=seed(46446);//44484313);//35458);

#declare leafx=0;
#while (leafx <50)
 #declare leafy=0;
 #while (leafy <50) 
  object 
  {leaf
   rotate <175+rand(s1)*10,rand(s1)*360,rand(s1)*90-45>
   translate <(leafx-45)*10-rand(s1)*5,-29,(leafy-5)*10+rand(s1)*5>
   texture
   {
    normal {wrinkles 1.2}
    pigment
    { bozo
      color_map
      { 
       [0.0 rgb <.8,.8,.6>]
       [1.0 rgb <.9,.9,.7>]
    /*   [0.0 rgb <.8-.4*.5,.8-.4*.5,.4-.4*.5>]
       [1.0 rgb <.8,.8,.8*.5>]*/
      }
    }
   }
  }
  #declare leafy=leafy+1;
 #end
 #declare leafx=leafx+1;
#end

//some trees
#declare treecount=0;
#while (treecount <10)
 #declare treex=rand(s1)*-250;
 #declare treey=rand(s1)*250;
 #declare treewidth=5+rand(s1)*5;
 //trunks
 cone 
 {<treex,-30,treey>,treewidth,<treex+rand(s1)*5,100,treey+rand(s1)*5>,treewidth*.5
  normal {wrinkles 1 scale <1,10,1>}
  pigment {color rgb <.8,.8,.4>}
 }
 #declare branchcount=0;
 #while (branchcount <20)
  #declare branchheight=rand(s1)*90-5;
  //branches
  cone 
  {<treex,branchheight,treey>,treewidth*.25,<treex+rand(s1)*60-30,branchheight+rand(s1)*60+30,treey+rand(s1)*40-20>,0//treewidth*.125
   normal {wrinkles 1 scale <1,10,1>}
   pigment {color rgb <.8,.8,.4>}
  }
  #declare branchcount=branchcount+1; 
 #end
 #declare rootcount=0;
 #while (rootcount <5)
  //roots
  cone 
  {<treex,-30,treey>,treewidth*.25,<treex+rand(s1)*40-20,-30,treey+rand(s1)*40-20>,treewidth*.125
   normal {wrinkles 1 scale <1,10,1>}
   pigment {color rgb <.8,.8,.4>}
  }
  #declare rootcount=rootcount+1; 
 #end
 #declare treecount=treecount+1;
#end

//the tree the leaf is attached to
 #declare treex=0;
 #declare treey=20;
 #declare treewidth=5+rand(s1)*5;
 //trunk
 cone 
 {<treex,-30,treey>,treewidth,<treex+rand(s1)*5,50,treey+rand(s1)*5>,treewidth*.5
  normal {wrinkles 1 scale <1,10,1>}
  pigment {color rgb <.9,.9,.7>}
 }
 #declare branchcount=0;
 #while (branchcount <20)
  //branches
  #declare branchheight=rand(s1)*90-5;
  cone 
  {<treex,branchheight,treey>,treewidth*.25,<treex+rand(s1)*60-30,branchheight+rand(s1)*20+10,treey+rand(s1)*60-30>,0//treewidth*.125
   normal {wrinkles 1 scale <1,10,1>}
   pigment {color rgb <.8,.8,.4>}
  }
  #declare branchcount=branchcount+1; 
 #end
 #declare rootcount=0;
 #while (rootcount <5)
  //roots
  cone 
  {<treex,-30,treey>,treewidth*.25,<treex+rand(s1)*40-20,-30,treey+rand(s1)*40-20>,treewidth*.125
   normal {wrinkles 1 scale <1,10,1>}
   pigment {color rgb <.9,.9,.7>}
  }
  #declare rootcount=rootcount+1; 
 #end
  //the branch the leaf is attached to
  #declare branchheight=-20;
  cone 
  {<treex,branchheight,treey>,.25,<0,-1,3.3>,.125
   normal {wrinkles 1 scale <1,10,1>}
   pigment {color rgb <.8,.8,.4>}
  }

//grass
#declare grasscount=0;
#while (grasscount<5000)
 #declare grassx=rand(s1)*-250+10;
 #declare grassy=rand(s1)*250-10;
  cone
  { <grassx,-30,grassy>,.2,<grassx+rand(s1),-27,grassy+rand(s1)>,0
    pigment {color rgb <.7,.7+rand(s1)*.1 +.2,rand(s1)*.3 +.5>}
  }
 #declare grasscount=grasscount+1;
#end


//--------------------now the new stuff (melting snow)------------------------
#declare flaketext=
 texture
 {
  finish {reflection .01}
  pigment {color rgbt <1,1,1,1>}
 }
#declare flaketext2=
 texture
 {
  #if (clock>.8)
   finish {ambient .3 * (-clock+1)*5 reflection .01}
  #else 
   finish {ambient .3 reflection .01}
  #end
  pigment {color rgbt <1,1,1,.9>}
 }

blob 
{ threshold .5
/* #declare sidecount=0;
 #while (sidecount <360)          
  cylinder {<.5,0,.5>,<-.5,0,.5>,.05-(clock-.2)*.02,2 rotate y*sidecount}
  cylinder {<.4,0,.3>,<-.4,0,.3>,.05-(clock-.2)*.02,2 rotate y*sidecount}
  cylinder {<.2,0,.2>,<-.2,0,.2>,.05-(clock-.2)*.02,2 rotate y*sidecount}
  #declare sidecount=sidecount+60;
 #end
#if (clock<.5)
 sphere {<0,-1.5+clock*3,0>,1,2 scale <1,.08,1>}
#else*/
 sphere {<0,0,0>,1,2 scale <1,.08,1>}
//#end
 translate <0,-24.5-clock*.1,0>
 interior {ior .5}
 texture {flaketext}
}
#declare snowflake=
union
{
 #declare sidecount=0;
 #while (sidecount <360)          
  cylinder {<.5,0,.5>,<-.5,0,.5>,.05 rotate y*sidecount}
  cylinder {<.4,0,.3>,<-.4,0,.3>,.05 rotate y*sidecount}
  cylinder {<.2,0,.2>,<-.2,0,.2>,.05 rotate y*sidecount}
  #declare sidecount=sidecount+60;
 #end
 interior {ior .5}
 texture {flaketext2}
}

//#if (clock>=.5)
 #declare flakecount=0;
 #while (flakecount<(clock+2)*20)
  #if (flakecount>20)
  object 
  { snowflake 
    #if (-13-(clock+2)*20+flakecount>-29 | flakecount<20) 
     rotate x*-((clock+2)*20+rand(s1)*4)*90
     translate <rand(s1)*-25+5,-13-(clock+2)*20+flakecount,rand(s1)*25-5>
    #else
     rotate x*(45-rand(s1)*90)
     translate <rand(s1)*-25+5,-29,rand(s1)*25-5>
    #end
  }
  #end
  object 
  { snowflake 
    #if (-13-(clock+2)*20+flakecount>-29 | flakecount<20) 
     rotate x*-((clock+2)*20+rand(s1)*4)*90
     translate <rand(s1)*-25+5,-13-(clock+2)*20+flakecount,rand(s1)*25-5>
    #else
     rotate x*(45-rand(s1)*90)
     translate <rand(s1)*-25+5,-29,rand(s1)*25-5>
    #end
  }
  #declare flakecount=flakecount+1;
 #end
//#end
