// Opening shot showing picture from Rosie
#debug "Shot four is being parsed.\n"

#declare Indoors=on;
#include "chezrust.inc"
//#include "valley.inc"

#local ER= 3.75;
#local BB=27.5+ER;
#local BT=90-ER;
#local RB=21.26;
#local RT=15.01;

#local OT=sqrt( (RT-RB)*(RT-RB) + (BT-BB)*(BT-BB) );
#local OU=(BT-BB)/OT*ER;
#local OV=(RB-RT)/OT*ER;

#local i_I=0;

#declare RobotY=y;
#declare RobotZ=-x;
#declare RobotX= z;
#declare RobotL=<0,10,-198>;
#declare RotLT= i_I*22.5/5.625/sqrt(2+sqrt(3));
#declare RotRT=-i_I*22.5/5.625/sqrt(2+sqrt(3));
// rotation in degrees=distance*180/pi/5.625.sqrt(2+sqrt(3));
#declare CamLft1=0;
#declare CamSwp1=0;
#declare CamLft2=15;
#declare CamSwp2=0;
#declare CamLft3=Transition(-25,15,0,Timer-1);
#declare CamSwp3=Transition(105,180,0,Timer-1);

#declare vT=vnormalize(Transition(<-16,0,-13.1>,<-.5,0,-23>,0,Timer-.5));
#declare BotHandZ=vT*(BT-BB)/OT-y*(RB-RT)/OT;
#declare BotHandX=vnormalize(vcross(-y,BotHandZ));
#declare BotHandY=vcross(BotHandZ,BotHandX);

#declare BotHandL=y*Transition(72.5,50.5,0,Timer-.5)
  -vT*Transition(21.5,23,5,Timer-.25)-14.3*BotHandZ;

#declare FingerOpen=34;
#declare ClawOpen=28.9;
#include "rusty.inc"

// transform can for location of hand
#declare SprayX=vmatrix(x,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare SprayY=vmatrix(y,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare SprayZ=vmatrix(z,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare SprayL=vmatrix(<0,-9.5,4.3>,BotHandX,BotHandY,BotHandZ,BotHandL);

// and then transform it for location of the robot 
#declare SprayX=vmatrix(SprayX,RobotX,RobotY,RobotZ,<0,0,0>);
#declare SprayY=vmatrix(SprayY,RobotX,RobotY,RobotZ,<0,0,0>);
#declare SprayZ=vmatrix(SprayZ,RobotX,RobotY,RobotZ,<0,0,0>);
#declare SprayL=vmatrix(SprayL,RobotX,RobotY,RobotZ,RobotL);
#declare SprayOn=off;
#declare SprayCapOn=off;
#include "spray.inc"

#declare CamE=Transition(RobotL+80*RobotY,<300,200,-250>,0,(Timer-1)/2);
#declare CamL=Transition(<-200,150,-146>,
  <300,200,-250>-vnormalize(<500,50,-104>)*110,0,Timer-2)
  +vnormalize(<500,50,-104>)*Timer*5;
#declare CamZ=2.5;

// the first patch

#local sC=min(max((Timer-1.625)/1.25,0),1);

#declare RuffGold= texture { Gold normal { granite .3 scale .02 } }

#declare HalfRust = texture {
  pigment { rgb lin(<.20,.13,0>,<1,.9,0>,sC) }
  finish { diffuse lin(1,.4,sC) specular lin(0,.8,sC) roughness .03 ambient .1 }
  normal { granite .3 scale .02 }
}

#declare HalfGold = texture {
  granite 
  texture_map { [.8 BlisterGold] [.8 HalfRust] }
  scale 50
}

#declare Patched = texture {
  granite
  texture_map { [.8 BlisterGold] [.8 RuffGold] }
  scale 50
}
  
cone {
  y*(BB+OV),RB+OU,y*(BT+OV),RT+OU
  texture { Patched }
  clipped_by { sphere { y*72.5+20.5*vnormalize(<16,0,13>),2 } }
//  bounded_by {clipped_by }
  Matrix(RobotX,RobotY,RobotZ,RobotL)
}
 