// Opening shot showing picture from Rosie
#debug "Shot four is being parsed.\n"

#declare Indoors=on;
#include "chezrust.inc"
//#include "valley.inc"

#local ER= 3.75;
#local BB=27.5+ER;
#local BT=90-ER;
#local RB=21.26;
#local RT=15.01;

#local OT=sqrt( (RT-RB)*(RT-RB) + (BT-BB)*(BT-BB) );
#local OU=(BT-BB)/OT*ER;
#local OV=(RB-RT)/OT*ER;

#local i_I=Transition(0,45,0,Timer-2);
#declare RobotY=y;
#declare RobotZ=vrotate(-x,y*i_I);
#declare RobotX=vrotate( z,y*i_I);
#declare RobotL=<0,10,-223>+vnormalize(<-1,0,1>)*Transition(0,250,0,(Timer-3)/2.5);
#declare RotLT= i_I*22.5/5.625/sqrt(2+sqrt(3))
  +Transition(0,250*180/pi/5.625/sqrt(2+sqrt(3)),0,(Timer-3)/2.5);
#declare RotRT=-i_I*22.5/5.625/sqrt(2+sqrt(3))
  +Transition(0,250*180/pi/5.625/sqrt(2+sqrt(3)),0,(Timer-3)/2.5);
// rotation in degrees=distance*180/pi/5.625/sqrt(2+sqrt(3));
#declare CamLft1=0;
#declare CamSwp1=0;
#declare CamLft2=15;
#declare CamSwp2=0;
#declare CamLft3=Transition(-25,15,0,Timer-1);
#declare CamSwp3=Transition(105,180,0,Timer-1);

// we want the spray can to wind up at <-80,85.5,-252>
#declare pStop=<-29,75.5,80>;

#declare BotHandL=Transition(<0,100,35>,pStop,5*y,Timer-.5);
#declare BotHandL=Transition(BotHandL,<0,95,30>,4*y,Timer-1.625);

#declare BotHandZ=Transition(z,vnormalize(<-29,0,69.75>),0,Timer-.5);
#declare BotHandZ=Transition(BotHandZ,z,0,Timer-1.625);
#declare BotHandY=y;
#declare BotHandX=vnormalize(vcross(BotHandY,BotHandZ));

#declare BotHandL=BotHandL+BotHandY*9.5-4.3*BotHandZ;

#declare FingerOpen=34;
#declare ClawOpen=Transition(28.9,31,0,(Timer-1.5)*8);

#declare RustyGold = texture { Gold
  normal { granite
    normal_map {
      [.6 bumps .001]
      [.8 granite .1 scale.1 ]
      [.8 granite .3 scale .02]
    }
  }
  scale 50
}

#include "rusty.inc"

// transform can for location of hand
#declare SprayX=vmatrix(x,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare SprayY=vmatrix(y,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare SprayZ=vmatrix(z,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare SprayL=vmatrix(<0,-9.5,4.3>,BotHandX,BotHandY,BotHandZ,BotHandL);

// and then transform it for location of the robot 
#declare SprayX=vmatrix(SprayX,RobotX,RobotY,RobotZ,<0,0,0>);
#declare SprayY=vmatrix(SprayY,RobotX,RobotY,RobotZ,<0,0,0>);
#declare SprayZ=vmatrix(SprayZ,RobotX,RobotY,RobotZ,<0,0,0>);
#declare SprayL=vmatrix(SprayL,RobotX,RobotY,RobotZ,RobotL);
#declare SprayOn=off;
#declare SprayCapOn=off;
#if(Timer>1.4999)
  #declare SprayX=vnormalize(<-29,0,69.75>);
  #declare SprayY=y;
  #declare SprayZ=vnormalize(<-69.75,0,-29>);
  #declare SprayL=<-80,85.5,-252>;
#end
#include "spray.inc"

#declare CamE=RobotL+80*RobotY;
#declare CamL=<300,150,-250>-vnormalize(<500,25,-104>)*(85+Timer*5);
#declare CamZ=2.5;

#declare FlowerX=x;
#declare FlowerY=y;
#declare FlowerZ=z;
#declare FlowerL=<-210,85.5,10>;
#declare PetalPig = pigment {
  granite scale 10
  color_map {
    [.6 rgb <1,.5,.75>]
    [.7 rgb <.45,.25,0>]
  }
}
#include "flower.inc"
 