// Opening shot showing picture from Rosie
#debug "Shot four is being parsed.\n"

#declare Indoors=on;
#include "chezrust.inc"
//#include "valley.inc"

#local i_I=45;
#local i_J=9/16*200+75/2;

#declare Path=array[4] {
  <0,10,-223>+vnormalize(<-1,0,1>)*250,vnormalize(x+z),
  <0,10,-223>+z*(250*sqrt(2)+250),z
}
#declare Trail=array[2][5]

PrepFullSpline(Path,Trail)

#declare RobotY=y;

#declare RobotZ=vnormalize(SplineVel(Trail,i_J));
#declare RobotX=vnormalize(vcross(RobotY,RobotZ));
#declare RobotL=SplineLoc(Trail,i_J);
#declare RotLT=( i_I*22.5+i_J*180/pi)/5.625/sqrt(2+sqrt(3));
#declare RotRT=(-i_I*22.5+i_J*180/pi)/5.625/sqrt(2+sqrt(3));
// rotation in degrees=distance*180/pi/5.625/sqrt(2+sqrt(3));
#declare CamLft1=0;
#declare CamSwp1=0;
#declare CamLft2=15;
#declare CamSwp2=0;
#declare CamLft3=15;
#declare CamSwp3=180;

#declare BotHandX=vrotate(vrotate(x,-z*90),y*70);
#declare BotHandY=vrotate(vrotate(y,-z*90),y*70);
#declare BotHandZ=vrotate(z,y*70);

#declare BotHandL=<10,82.5,40>;

#declare FingerOpen=10;
#declare ClawOpen=-12;

#declare RustyGold = texture { Gold
  normal { granite
    normal_map {
      [.6 bumps .001]
      [.8 granite .1 scale.1 ]
      [.8 granite .3 scale .02]
    }
  }
  scale 50
}

#include "rusty.inc"

#declare SprayX=vnormalize(<-29,0,69.75>);
#declare SprayY=y;
#declare SprayZ=vnormalize(<-69.75,0,-29>);
#declare SprayL=<-80,85.5,-252>;
#declare SprayOn=off;
#declare SprayCapOn=off;
#include "spray.inc"


#declare CamE=vmatrix(BotHandL,RobotX,RobotY,RobotZ,RobotL)+<2,-1.5,0>;
#declare CamL=CamE+vnormalize(<25,2,-45>)*(56-Timer);
#declare CamZ=2.5;

#declare FlowerX=vmatrix(BotHandX,RobotX,RobotY,RobotZ,<0,0,0>);
#declare FlowerY=vmatrix(BotHandY,RobotX,RobotY,RobotZ,<0,0,0>);
#declare FlowerZ=vmatrix(BotHandZ,RobotX,RobotY,RobotZ,<0,0,0>);
#declare FlowerL=BotHandL-BotHandY*34.5+BotHandZ*.5;
#declare FlowerL=vmatrix(FlowerL,RobotX,RobotY,RobotZ,RobotL);
#declare PetalPig = pigment {
  granite scale 10
  color_map {
    [.6 rgb <1,.5,.75>]
    [.7 rgb <.45,.25,0>]
  }
}
#include "flower.inc"
 