// Opening shot showing picture from Rosie
#debug "Shot four is being parsed.\n"

#declare Indoors=on;
#include "chezrust.inc"
//#include "valley.inc"

#local i_I=45;
#local i_J=9/16*200+75/2;

#declare Path=array[4] {
  <0,10,-223>+vnormalize(<-1,0,1>)*250,vnormalize(x+z),
  <0,10,-223>+z*(250*sqrt(2)+250),z
}
#declare Trail=array[2][5]

PrepFullSpline(Path,Trail)

#declare RobotX=x;
#declare RobotY=y;
#declare RobotZ=z;
#declare RobotL=<-150,10,175>;
#declare RotLT=0;
#declare RotRT=0;
// rotation in degrees=distance*180/pi/5.625/sqrt(2+sqrt(3));
#declare CamLft1=0;
#declare CamSwp1=0;
#declare CamLft2=Transition(-10,20,0,Timer-2.5);
#declare CamSwp2=0;
#declare CamLft3=15;
#declare CamSwp3=180;

// we want the spray can to wind up at <-120,80,260>
#local pCan=Transition(<0,90,35>,<10,70,55>,<5,10,0>,Timer-1.75);

#declare BotHandZ=vnormalize((pCan-z*11.25)*<1,0,1>);
#declare BotHandY=y;
#declare BotHandX=vnormalize(vcross(BotHandY,BotHandZ));
#declare BotHandL=pCan+BotHandY*9.5-4.3*BotHandZ;
#declare FingerOpen=45;//Transition(34,-45,0,Timer-2.875);
#declare ClawOpen=Transition(28.9,31,0,(Timer-2.75)*8);

#if(Timer>2.874)
#declare BotHandL=Transition(BotHandL,<0,77.3,75>,y*20,Timer-2.875);

#local aR=Transition(0,-180,0,Timer-2.875);
#local aP=Transition(0,  110,0,Timer-2.875);
#declare ClawOpen=Transition(31,-12,0,(Timer-3.75)*4);

#declare vX=vrotate(vrotate(x,z*aR),x*aP);
#declare vY=vrotate(vrotate(y,z*aR),x*aP);
#declare vZ=vrotate(z,x*aP);

#declare vRZ=vnormalize((BotHandL-z*11.25)*<1,0,1>);
#declare vRX=vcross(y,vRZ);

#declare BotHandX=vmatrix(vX,vRX,y,vRZ,<0,0,0>);
#declare BotHandY=vmatrix(vY,vRX,y,vRZ,<0,0,0>);
#declare BotHandZ=vmatrix(vZ,vRX,y,vRZ,<0,0,0>);

#end

#declare RustyGold = texture { Gold
  normal { granite
    normal_map {
      [.6 bumps .001]
      [.8 granite .1 scale.1 ]
      [.8 granite .3 scale .02]
    }
  }
  scale 50
}

#include "rusty.inc"

#declare SprayX=vnormalize(<73.75,0,-30>);
#declare SprayY=y;
#declare SprayZ=vnormalize(<30,0,73.75>);
#declare SprayL=pCan+<-150,10,175>;
#declare SprayOn=off;
#declare SprayCapOn=off;
#include "spray.inc"

// the one by the mirror; probably off-screen at the moment
#declare SprayX=vnormalize(<-29,0,69.75>);
#declare SprayY=y;
#declare SprayZ=vnormalize(<-69.75,0,-29>);
#declare SprayL=<-80,85.5,-252>;
#declare SprayOn=off;
#declare SprayCapOn=off;
#include "spray.inc"

#declare CamE=<-150,80,250>;
#declare CamL=CamE+<-200/sqrt(5),60,-400/sqrt(5)>-x*Timer;

#declare CamZ=2.5;

#declare FlowerX=x;
#declare FlowerY=vrotate( z,-x*5)*<-1,1,-1>;
#declare FlowerZ=vrotate( y,-x*5)*<-1,1,-1>;
#declare FlowerL=<0,-3.6,30>+<-150,80,250>;
#declare PetalPig=pigment { rgb <1,0,0> }

#include "flower.inc"

#local Trans=array[256] {
  255,  0,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,127,114, 195, 53,187, 33,
  179, 21,170,162, 154,138, 98,146,  81, 90, 73,130,  65, 57, 37,  5,
  251,150,203, 77, 227,183,106, 41, 243,215,199, 94, 166,134, 61, 13,
  247,235,191,102, 118,223,239,175, 158, 45,211,142,  85, 25,  5, 69

}
#local pC=<.5,.5,0>;
polygon { 5,0,x,x+y,y,0
  texture {
    material_map {
      gif "smear.gif" once
#local iI=0; #while(iI<255)
  texture { pigment { rgbt <1,0,0,Trans[iI]/255> } finish { ambient 0 diffuse 1 } }
#local iI=iI+1; #end      

    }
  }  
    translate <-.5,-.5,0>
    matrix <0,0,-160/3, -40,0,0, 0,1,0,-150,80+.002,250+7.5>
  no_shadow
}

polygon {5,0,x,x+z,z,0 pigment { rgb <1,.99,.98> }
  translate <-.5,0,-.5>
  scale <50,1,70>
  rotate y*25
  translate <-150,80.001,255>
}

union { // the cap from the spray can
  intersection {
    torus { 2.5,.5 }
    cylinder { -y*.5,0,3 }
    torus { 2.5,.4 inverse }
    translate y*.5
  }
  difference {
    cylinder { y*.5,y*5,3 }
    cylinder { y*.4,y*5.1,2.9 }
  }
  cylinder { 0,y*.1,2.5 }  
  difference {
    cylinder { y*.1,y*3.5,1.05 }
    cylinder { 0,y*3.6,.95 }
  }
  pigment { rgb <1,0,0> }
  translate <-130,80,275>
}
   