camera { location <0,0,-120> direction 1*z look_at 0} 
                                                        
#declare TotalFrames = 200; 
#declare Prefix = "C:\images\2scen"
#declare Frame = ceil((TotalFrames*clock)+1); 
#declare BFrame = (TotalFrames*clock)+2; 
#declare CFrame = (TotalFrames*clock)+3; 
#declare DFrame = (TotalFrames*clock)+4; 
//#declare Frame = floor(Frame);

box {0,<1,1,0>  
texture {
finish {ambient 1 diffuse 1}
pigment {
image_map {
#if (Frame < 100)
#if (Frame < 10)                            
tga concat(Prefix,"00",str(Frame,0,0), ".tga")
#else
tga concat(Prefix,"0",str(Frame,0,0), ".tga")
#end
#else
tga concat(Prefix,str(Frame,0,0), ".tga")
#end
interpolate 2
}
}
} 


#macro Display(TotalFrames,Prefix) 

#declare Start = .5;
#declare End = .875; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare Frame = ceil(((TotalFrames-1)*keyclock)+1);  
texture {
finish {ambient 1.5 diffuse 0}
pigment {
image_map {
#if (Frame < 100)
#if (Frame < 10)                            
png concat(Prefix,"0",str(Frame,0,0), ".png")
#else
png concat(Prefix,"",str(Frame,0,0), ".png")
#end
#else
png concat(Prefix,str(Frame,0,0), ".png")
#end
interpolate 2
}
}
} 
#end 
Display(11,"c:\SDFiles\hud") 


//**** Declare Phasers ****//

#macro key(S,E)
#if (clock >= S)
#if (clock < E)
#declare keyclock = mod((clock-S)/(E-S),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end  
#end

key(.5,1.0001)

#declare mclock3 = pow(keyclock,2) 
#declare mclock4 = sin((keyclock-.5)*pi)/2+.5 
#declare Rclock = sin(clock*2*pi)

#declare PhaserFirePoint = vrotate(<0,0,0>,<90*mclock4,0,15*Rclock>) 


#declare ShootAt = vrotate(<10,145,(-7500+(13500*clock))/4>,<0,0,25*Rclock+25>)
#declare PhaserAxis = (ShootAt-PhaserFirePoint)//*<1, 1, 1>
#declare RotateX = degrees(atan2(vlength(PhaserAxis*<1, 0, 1>),PhaserAxis.y))
#declare RotateY = degrees(atan2(PhaserAxis.x,PhaserAxis.z))


#if (clock <.625)
#if (clock >=.4)
texture {
finish {ambient 1.5 diffuse 0}
pigment {
image_map {
png "targeting.png"
interpolate 2
once
}
} 
finish {ambient 2}     
translate -.5
scale .15 
key(.4,.625)
#declare accelc = pow(keyclock,2)


translate <.45-(.2*accelc),.475+(.6*accelc),0>
//translate PhaserFirePoint
//scale <1/160,1/120,1>
//translate -<-80,-60,-.001>
} 
#end  
#end

#if (clock <.615)
#if (clock >=.35)
texture {
finish {ambient 1.5 diffuse 0}
pigment {
image_map {
png "targeting.png"
interpolate 2
once
}
} 
finish {ambient 2}     
translate -.5
scale .15 
key(.35,.615)
#declare accelc = pow(keyclock,2)


translate <.475+(.3*accelc),.45+(-.25*accelc),0>
//translate PhaserFirePoint
//scale <1/160,1/120,1>
//translate -<-80,-60,-.001>
} 
#end  
#end





   
scale <160,120,1>
translate <-80,-60,-.001>
}

#declare Start = .6;
#declare End = .75; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock = pow(keyclock,2)

#declare Rclock = sin(clock*2*pi)
#declare Elevation = (90*mclock)+(15*Rclock )
   

text { ttf "c:\pov\display.ttf" concat(str(Elevation,0,0)," deg") .00125, 0 pigment {rgb <1,.5,0>} finish{ambient 1} 
translate -2*x scale 5 translate <-20,36,-30>}

#declare Start = .5;
#declare End = 1.0001; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end  

#declare mclock = pow(keyclock,2)

#declare Rclock = sin(clock*2*pi)
#declare Speed = 4500+(150*Rclock)+(3500*mclock)

text { ttf "c:\pov\display.ttf" concat(str(Speed,0,0)," mps") .00125, 0 pigment {rgb <1,.5,0>} finish{ambient 1} 
translate -2*x scale 5 translate <20,36,-30>}


