#include "colors.inc"

#macro CM(S,E)
#if (clock >= S)
#if (clock < E)
#declare keyclock = mod((clock-S)/(E-S),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end
#end
                       
//#if (clock < .1)  
#declare sky_vect = y;
#declare cam_loc = <400,-20,0>*1.5;
#declare lookat = <0,0,0>;

camera { 
location cam_loc
direction 1.5*z
look_at lookat 

#local MvRndX = rand(seed(clock*654656))*2
#local MvRndY = rand(seed(clock*656))*2
#local MvRndZ = rand(seed(clock))*2
CM(.55,.75) 
#declare KC = pow(1-keyclock,.5) 
#if (clock < .8)
#if (clock >= .65)
rotate <MvRndX-1,MvRndY-1,MvRndZ-1>*KC
#end 
#end

}


light_source {
<-250,120,150>*10000
color rgb 4
//area_light 25,25,10,10
//adaptive 0
}
/*#declare flare_size = <1,1,1>;
#declare flare_brightness = 1.5;   
#declare light_loc = <-250,80,60>*10000
#include "35mm.flr"   
#include "nkflare.inc"*/



light_source {
< 250, 0, -250 >*10000
color rgb <.5,.5,1>/2
//area_light 25,25,10,10
//adaptive 0
}
background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
} 
#macro Exp(R,B,S,E,Size) 
#declare Rand = rand(seed(R)) 

#if (clock >= S)
#if (clock < E)
#local keyclock = mod((clock-S)/(E-S),1) 
#local Rate = pow(keyclock,.375)
 
#local Scale = 1*Rate  
#local Fader = -1.5*keyclock+1.5

sphere {0,1 no_shadow hollow on
pigment {transmit 1}
interior {
media { 
intervals 35
//samples 1,1
/*confidence .9
variance .1*/
emission <1,.5,.1>/Size/Scale*Fader*B

density {bozo
color_map {
[0 rgb <1,.8,.7>]
[1 rgb 1]
} 
translate -2*clock+Rand
turbulence .5
omega .125
lambda 1
scale .35 
rotate (Rand*360)
}  

density {spherical
color_map {
[.1/2 rgb 1]
[.25/2 rgb (.25+(.25*Rand))*<.7,.2,0>]  
}
translate -1*clock+Rand 
rotate -2*clock
warp {turbulence .5+.5*(rand(seed(R))) omega .125 } 
rotate 2*clock
translate 1*clock-Rand

scale 8
translate 2*clock+Rand
rotate -20*clock
warp {turbulence 1 omega .125 }
rotate 20*clock
translate -2*clock-Rand
scale 1/8 
translate (1+(.8*Rand))*z 
rotate (-Rand*720) 
rotate 20*keyclock
} 

density {spherical
color_map {
[.15/2 rgb 0]
[.15/2 rgb <1,.125,0>]
[.15/2 rgb 3]  
[.25 rgb 1]
}
translate -1.5*clock+Rand 
rotate -2*clock
warp {turbulence 1*keyclock+.5 omega 0 lambda 0} 
rotate 2*clock
translate 1.5*clock-Rand  

scale 10*Rate+2
translate 6*clock-Rand
rotate 20*clock
warp {turbulence 1.5 omega 0}
rotate -20*clock
translate -6*clock+Rand
scale 1/(10*Rate+2)

rotate (Rand*360)

//omega 0 
scale .8  
}
density {spherical
color_map {
[.15/2 rgb 0]
[.15/2 rgb <1,.125,0>]
[.15/2 rgb 3]  
[.25 rgb 1]
}
translate -2*clock-Rand 
rotate -2*clock
warp {turbulence .5 omega 0 lambda 0} 
rotate 2*clock
translate 2*clock+Rand  

scale 10*Rate+2
translate 6*clock-Rand
rotate 20*clock
warp {turbulence 1.5 omega 0}
rotate -20*clock
translate -6*clock+Rand
scale 1/(10*Rate+2)
rotate (Rand*360) 
//omega 0 
scale .8  
}
#if (keyclock < .5)
#else
density { bozo
color_map{
[1.5*keyclock-1 rgb 0]
[2*keyclock-1 rgb 1]
[1.0 rgb 1]
}
scale 1
translate .25*keyclock
warp {turbulence .5 }
translate -.25*keyclock  

scale 6
translate 2*clock+Rand
rotate 20*clock
warp {turbulence .75 omega .125 lambda 1}
rotate -20*clock
translate -2*clock-Rand
scale 1/6

rotate 323456*Rand+567567
}
#end

}
}
scale Scale 
scale Size
}
#end
#end

#end


#macro Laser (S,E)
#if (clock > S)
#if (clock < E)
cylinder {0,<0,1,0>,1 hollow on
pigment {transmit 1}
interior {
media{
emission 1
intervals 30
density { cylindrical
color_map{
[0.0 rgb <1,0,0>*0]
[.5 rgb <1,0,0>*.25]
[.9 rgb <1,1,0>*.5]
[1.0 rgb <1,1,0>]
}
}
}
}
scale <1.5,10000,1.5>
rotate -90*x
}
sphere {0, 1 hollow on
pigment {transmit 1}
interior {
media{
emission 1
intervals 30
density { spherical
color_map{
[0.0 rgb <1,0,0>*0]
[.5 rgb <1,0,0>*.25]
[.9 rgb <1,1,0>*.5]
[1.0 rgb <1,1,0>]
}
}
}
}
scale 3
}
#end
#end
#end
#macro Bolt(S,W)
sphere {0, 1 hollow on
pigment {transmit 1}
interior {
media{
emission 1/2.5
intervals 30
density { spherical
color_map{
[0.0 rgb <1,.33,.22>*0]
[.5 rgb <1,.66,.22>*.25]
[.875 rgb <1,.66.22>*1]
}
translate <0,0,1>
}
}
}
scale 3
scale <1,1,5>
translate -15*z  
translate (S*clock)*z  
translate <20*W,0,0>
}
sphere {0, 1 hollow on
pigment {transmit 1}
interior {
media{
emission 1/2.5
intervals 30
density { spherical
color_map{
[0.0 rgb <1,.33,.22>*0]
[.5 rgb <1,.66,.22>*.25]
[.875 rgb <1,.66.22>*1]
}
translate <0,0,1>
}
}
}
scale 3
scale <1,1,5>
translate -15*z  
translate (S*clock)*z  
translate <-20*W,0,0>
}
#end    

#macro FFTest(Loc,Rot,ERot) 
#if (Rot.z > 90)
#declare RotZ = 90;  
#else              
#declare RotZ = Rot.z;
#end 
 
#if (Rot.x > 90)
#declare RotX = 90;
#else              
#declare RotX = Rot.x;
#end 

//#declare RotZ = ((Rot.z/clock)*clock_delta)/2
//#declare RotX = ((Rot.x/clock)*clock_delta)/2
 
#declare EngRot1 = ((RotZ)/2)+((-RotX)/2)+ERot
#declare EngRot2 = ((-RotZ)/2)+((-RotX)/2)+ERot

union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1>} 
sphere {0,25 pigment {rgb <0,0,4>} scale <.75,.5,2> translate 15*y }  

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate -37.5*x rotate <EngRot2,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <-37.5,0,50> rotate <EngRot2,0,0>} 

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate 37.5*x rotate <EngRot1,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <37.5,0,50> rotate <EngRot1,0,0>}

scale .75 
rotate Rot 
translate Loc
}
#end

CM(.5,.6)
#declare Rate = pow(keyclock,2) 

#declare Rclock = sin(clock*2*pi)            
#if (clock > .45) 
#if (clock < .675)
#include "COM Fighter.inc"  
TiltFighter(<-60,-320*Rate,4080*clock-2300>,<-120*Rate,180,(-20*Rclock)-(60*Rate)>,0,false,1)
TiltFighter(<50,320*Rate,4080*clock-2380>,<120*Rate,180,(20*Rclock)+(60*Rate)>,0,false,2)  
#end
#end

//FFTest(<-60,-320*Rate,4080*clock-2300>,<-120*Rate,180,(-20*Rclock)-(60*Rate)>,0)
//FFTest(<50,320*Rate,4080*clock-2380>,<120*Rate,180,(20*Rclock)+(60*Rate)>,0)

union {Bolt(8000,.75)  scale 2.5 rotate <0,0,15> translate <50,0,-500>}
union {Bolt(8000,.875) scale 2.5 rotate <0,0,10>translate <50,0,-700>} 
union {Bolt(8000,1)    scale 2.5 rotate <0,0,5> translate <50,0,-900>}  

union {Bolt(8000,.75)  scale 2.5 rotate <0,0,-5> translate <50,0,-1900>}
union {Bolt(8000,.875) scale 2.5 rotate <0,0,-10>translate <50,0,-2100>} 
union {Bolt(8000,1)    scale 2.5 rotate <0,0,-10> translate <50,0,-2300>}  


union {Bolt(8000,.75)  scale 2.5 rotate <0,0,-20> translate <-60,0,-2000>}
union {Bolt(8000,.875) scale 2.5 rotate <0,0,-20>translate <-60,0,-2000>} 
union {Bolt(8000,1)    scale 2.5 rotate <0,0,-20> translate <-60,0,-2000>}

union {Bolt(8000,.75)  scale 2.5 rotate <0,0,-10> translate <-60,0,-3000>}
union {Bolt(8000,.875) scale 2.5 rotate <0,0,-10>translate <-60,0,-3000>} 
union {Bolt(8000,1)    scale 2.5 rotate <0,0,-10> translate <-60,0,-3000>}


#macro EFTest(Loc,Rot) 
union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1>} 
sphere {0,25 pigment {rgb <0,0,4>} scale <.75,.5,2> translate -30*z }  
scale .75 
rotate Rot 
translate Loc
}
#end   

CM(.1275,1)
#declare Rate = pow(keyclock,.5/1.5) 
#declare RotRate = pow(keyclock,2) 
#declare Clock = keyclock 
 
CM(0,.128)
#declare Clock2 = keyclock 

#include "Pirate Fighter.inc" 
//EFTest(<-80+80*Rate,-10+10*Rate,(-1500*keyclock+2030)+(-500*Rate)>,<0,0,(25*Rclock)>+(520*RotRate)) 
#if (clock <.7)
FixedFighter(<-80+80*Rate,-10+10*Rate,(500)+(-500*Rate)>,<0,0,(25*Rclock)>+(520*RotRate),1,.625,.7) 
#end

CM(.35,.7)
#declare Tilt = sin((keyclock-.5)*pi)/2+.5 
#if (clock < .7)
#if (clock > .35)
//EFTest(<40,25-70*Tilt,(-1500*keyclock+2100)+(-4764*Clock)>,<0,0,(-45*Rclock)>)
FixedFighter(<40,25-70*Tilt,(-1500*keyclock+2100)+(-4764*Clock)>,<0,0,(-45*Rclock)>,2,1,2)  
#end  
#end

#if (clock < .6 )
union {
//Exp(R,B,S,E,Size) 
Exp(8,1,.3,.9,50)
/*rotate <0,0,(25*Rclock)>+(520*RotRate)*/
translate <-80+80*Rate,-10+10*Rate,(500)+(-500*Rate)>
}
#end
union {
//Exp(R,B,S,E,Size) 
Exp(7777,1.5,.6,1,175)
rotate -90*y
translate <60*keyclock-20,-10+10*Rate,(500)+(-500*Rate)>
} 

CM(.55,.8) 
#if (clock < .8)
disc {<0,0,0>, y, 1.5
pigment {
onion
pigment_map {
[0 color rgbt <.5,.5,1,1>]
[.475*keyclock+0.5 color rgbt <.375,.375,1,1>]
[.975 bozo color_map {[0 rgbt <.75,.75,1,2*keyclock-1>]
[1 rgbt <.5,.5,1,1*keyclock>]}
turbulence .5 scale .0675 translate <0,.75*keyclock,0>]
[1 color rgbt <.5,.5,1,1>]
}
translate -3*y*keyclock
warp {turbulence .25}
translate 3*y*keyclock

translate <0,-.25*keyclock,0>
}
finish {
ambient 1.5
diffuse 0
}
no_shadow hollow
scale 1500*keyclock+.1 
rotate -30*z 
translate <60*keyclock-20,-10+10*Rate,(500)+(-500*Rate)>
}
#end


                  

/*#if (clock >.625)
disc {0,y,1
texture {
finish {ambient 2}
pigment {
onion 
color_map{
[0 rgb <1,.5,.15>*1.25 transmit 2*Glo-1]
[1 rgb <1,.5,.15> transmit 1]
}
}
}                      
rotate 90*x  
rotate 90*y
scale 50+75*Glo  
translate <80,-10+10*Rate,(-1500*Clock2+2030)+(-500*Rate)>
} 
#end*/
   






CM(.66,1)
#if (clock > .6)
light_source {<0,0,40>, rgb <1,.5,.1>*2 fade_distance 200-200*keyclock fade_power 2 shadowless}
#end                                          
union {Laser (.1,.13)  
scale 2.5
rotate <-5+5*(clock*4),0,0> 
translate <-80,-25,(-1500*Clock2+2020)+(-500*Rate)>
} 

union {Laser (.175,.2)  
scale 2.5
rotate <3*(clock*4),0,0> 
translate <40,0,(-1500*Clock2+2090)+(-2764*Clock)>
}

union {Laser (.125,.15)  
scale 2.5
rotate <2.5-5*(clock*4),0,0> 
translate <40,0,(-1500*Clock2+2090)+(-2764*Clock)>
} 


#macro Debris(RNum,Num,Loc,Clock)
#declare C=0;
#while (C < Num)
#declare Seed = seed(C+RNum)
#declare Rand = rand(Seed)  
#declare Seed2 = seed(C*C+RNum*RNum)
#declare Rand2 = rand(Seed2)
intersection {
difference {
sphere {0,1}
sphere {0,.95}   
sphere {2*z,2
}
}
sphere {0,.875 scale <.5+Rand*.5,1+Rand2*2,4>} 
scale <1,1,.1+Rand2*.75>*1.5

texture {   
pigment { gradient y triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}
turbulence -.25*Rand-.25   
scale .2+.15*Rand2          
translate Rand2*y
}
}
texture {   
pigment { gradient x triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}  
turbulence .5*Rand2+.125
scale .2+.15*Rand2          
translate Rand2*x
}
}
texture {   
pigment { bozo
color_map {
[0 rgb .5-(<0,.15,.3>/2)*Rand]
[.3+.4*Rand2 rgb .25-<0,.075,.15>*Rand2]
[.425+.4*Rand2 rgb .5 transmit 1]
}   
turbulence 1
scale .35+.35*Rand2          
translate Rand2*y
}
}

scale 2
rotate Rand*720
rotate 480*Rand2*clock
translate (Rand*80*Clock)*x
translate (-Rand*35*Clock+5)*y
translate (Rand*60*Clock+10)*z
rotate C*360*Rand
//translate <Rand2*8*clock,Rand*-8*clock,Rand2*8*clock> 
rotate -C*180*Rand2 
scale 2
translate Loc 

}
#declare C=C+1;
#end  
#end 

#declare Start = .69;
#declare End = 1.0001; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock2 = pow(keyclock,.5)

#if (clock > Start)
Debris(10,100,<0,0,80>,1.5*mclock2)
#end





global_settings {max_trace_level 100000}  

