#include "colors.inc"

#macro CM(S,E)
#if (clock >= S)
#if (clock < E)
#declare keyclock = mod((clock-S)/(E-S),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end
#end

CM(0,1) 
#declare keyclock = pow(keyclock,2)

#declare sky_vect = y;
#declare cam_loc = <40*keyclock-20,-20*keyclock+10,40>*10;
#declare lookat = <0.01,0.01,0.01>;
camera { 
  location  cam_loc
  direction 1.5*z
  look_at   lookat
}
#declare RBox2 =
superellipsoid {
<.25, .25>
translate <1,1,1>
scale .5
}
#declare Scarring =
texture {pigment {bozo color_map {[0 rgb 0 transmit .875][1 rgb 0 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb 0 transmit .667][1 rgb 0 transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}



light_source {
<-250,120,-50>*10000
color rgb 2
//area_light 25,25,10,10
//adaptive 0
}
  
background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
}
#macro Missile(S,E,SLoc,SRot,Dist,Scale,TotalNum,MisEnd)
#declare M_Tex1 =
texture {
pigment {rgb 1}
finish {ambient .15 diffuse .875 phong 1}
}
#declare M_Tex2 =
texture {
pigment {rgb <0,0,.75>}
finish {ambient .15 diffuse .875 phong 1}
}
#declare M_Tex3 =
texture {
pigment {rgb .125}
finish {ambient .15 diffuse .875 phong 1}
}
#local MisClock = mod((clock-S)/(E-S), 1) 
#local AccelClock = clock 
#if (clock < E)
#local SmokeTrans = <0,100*AccelClock*(Dist/100)+.001,0>
#else                                                   
#local SmokeTrans = <0,100*E*(Dist/100)+.001,0>
#end

union {

difference {
cylinder {0,SmokeTrans,2 hollow on
pigment {transmit 1}
interior {
media{
emission 2/3/Scale/5
absorption (1/3/Scale)*10/5
intervals 15
density { cylindrical
color_map{
[0 rgb 0]
[1 rgb 1]
}
scale <2,1,2>
} 
density { bozo
color_map{
[.5 rgb 0]
[.5 rgb 1]
}
rotate -25*MisClock*y
warp {turbulence .25}
rotate 25*MisClock*y
scale .175*Scale
}
density { spherical
color_map{
[0 rgb 0]
[.5 rgb .25]
[1 rgb 1]
}
scale <10,250,10>
translate (100*clock*(Dist/100)+.001)*y
} 
}
}
rotate -90*x
} 
plane {-z,0  pigment {transmit 1}
translate (100*clock*(Dist/100)+.001)+250*z
}
           
}

#if (clock < MisEnd)
cylinder {0,3*y,1
pigment {transmit 1}
hollow
interior {
media {
emission <.675,.5,1>/2/3/Scale
//intervals 25
#declare C=0;
#while (C <360)
density {
cylindrical
color_map {
[0 rgb 0]  
[.25 rgb 1]
}       
rotate 15*z     
rotate C*y
}        
#declare C=C+60;
#end
density {
gradient y
color_map {
[0 rgb 0] 
[.125 rgb .25]
[.25 rgb .5]  
[.5 rgb 1.75]
[.75 rgb 7.5]
[1 rgb 10]
}       
scale 4
} 
}
}
scale 3 
translate -3*y
rotate -90*x 
translate <0,0,-100*AccelClock>*(Dist/100)+<0,0,6>
}

// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

               scale < 0.75, 6.5, 0.75 >
               rotate < 90, 0, 0 >
               translate < 0, 1.522e-22, -7.5 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               scale < 0.75, 1, 0.75 >
               rotate < 90, 0, 0 >
               translate < 0, 0, -1 >

               texture
               {
                  M_Tex3
                  scale < 0.75, 1, 0.75 >
                  rotate < 90, 0, 0 >
                  translate < 0, 0, -1 >
               }
            }
                // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < .75, 1, .75 >
                     rotate < 90, 0, 0 >
                     translate < 0, 0, -1 >
                     pigment {rgb <1,.75,0>}
                     finish {ambient 1}
                  }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5 }

               scale < 0.75, 2.5, 0.75 >
               rotate < -90, 0, 0 >
               translate < 0, 0, -7.5 >

               texture
               {
                  M_Tex2
                  scale < 0.75, 2.5, 0.75 >
                  rotate < -90, 0, 0 >
                  translate < 0, -3.3087e-24, -7.5 >
               }
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 0.375, 0.375, 0.75 >
               translate < 0, 0, -10 >
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     translate < 0, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, 0 >
                     translate < 0, 1.25, -2.5 >
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     rotate < 0, 0, 90 >
                     translate < 0, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, 90 >
                     translate < -1.25, -5.4639e-08, -2.5 >
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     rotate < 0, 0, -90 >
                     translate < 6.6613e-16, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, -90 >
                     translate < 1.25, -5.4639e-08, -2.5 >
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     rotate < 0, 0, -180 >
                     translate < 0, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, -180 >
                     translate < 1.0928e-07, -1.25, -2.5 >
                  }
               }
            }
         }

         texture
         {
            M_Tex1
            translate < 0, 0, -2.5 >
         }
      }
   }
   scale .5
#if ( MisClock > 0 )
translate <0,0,-Dist*AccelClock>
#end
}
#end 



#if ( MisClock > 0 )
light_source {
<0,0,-Dist*AccelClock+2>
color rgb <.6,.5,1>*1.5
fade_distance 60*Scale
fade_power 2
}
#end
scale Scale 
rotate SRot
translate SLoc
}
#declare flare_brightness = (<.5,.33,1.25>*2)*(1-MisClock); 
#declare flare_size = (((1)*((1-MisClock)*.5))+.5)*(.6-.3*MisClock);  
#declare light_loc = <0,0,-(Dist*Scale)*AccelClock>  
#declare light_loc = vrotate(light_loc,SRot)
#declare light_loc = SLoc+light_loc
#include "CAMCORDR.flr" 
#include "nkflare.inc" 

#end  
  
#macro GateWay(St,Ed,Loc)   
CM(St,Ed)
#declare keyclock = pow(1-keyclock,.5)
sor {8,
<20,-15>, 
<15,0>,
<6,5>,
<1.5,5.25+4.75*keyclock>,
<.5,5.5+7*keyclock>,
<.25,5.75+9*keyclock>,
<.125,6+10*keyclock>,
<0,6.25+11*keyclock>
open
rotate 90*x

//interior {ior 1.2}
texture {
finish {ambient 1.5 diffuse 0}
pigment {
cylindrical
pigment_map { 
[.25 transmit 1]
[.875 
radial triangle_wave frequency 6
//onion triangle_wave
color_map{
[0 rgb <.125,.125,.5> transmit .5]
[1 rgb <.5,.5,.75>*1.5]
}
scale 3
translate -20*z*clock
warp {turbulence 1 omega 0}
translate 20*z*clock     
scale 1/3

warp {turbulence .75 omega 0 lambda 1
}

scale 1/8
scale <1,100000,1>
]             
[.8 rgb 3]

}
scale 20
rotate 90*x 
rotate (10*clock+10)*z
}
}               

texture {
finish {ambient 2 diffuse 0}
pigment {
cylindrical
pigment_map { 
[.25 transmit 1]
[.925 onion triangle_wave
color_map{
[0 rgb <.5,.5,.75> transmit .125]
[1 rgb <.5,.5,1>*1.25]
}
scale 6
translate -2*z*clock
warp {turbulence 2}
translate 2*z*clock     
scale 1/6


phase 6*clock
warp {turbulence .5
}
scale 1/12
scale <1,100000,1>
]             
[.8 rgb 3]

}
scale 20 
rotate 90*x
}
}                      
translate -16*z   
rotate -90*z*clock
scale <1*keyclock+.0001,1*keyclock+.0001,1*keyclock+.0001> 
translate 16*z*keyclock 
translate Loc
} 
#if (clock > St)
#if (clock <= Ed)
#declare flare_size = (1.5*keyclock+.5)/2;
#declare flare_brightness = <.5,.5,1>*2;   
#declare light_loc = <0,0,-130*keyclock>+Loc
#include "CAMCORDR.flr"   

light_source {<0,0,13*keyclock>+Loc rgb 3 shadowless fade_distance 150 fade_power 1} 
#declare C=0; 
#while(C<360) 
light_source {<0,5,13*keyclock>+Loc rgb 1 shadowless fade_distance 150 fade_power 1 rotate 60*keyclock*z rotate -C*z}
#declare C=C+90
#end

#declare C=0; 
#while(C<360) 
light_source {<0,20,8*keyclock>+Loc rgb <.5,.5,1>/2 shadowless fade_distance 150 fade_power 1 rotate 60*keyclock*z rotate C*z}
#declare C=C+45
#end 
#end  
#end

#end


#declare GateFin =
difference {
intersection {
object {
box { < 0, 0, 0 >, < 1, 1, 1 > }
scale < 20, 13.362, 2.015 >
rotate < 8.673, 0, 0 >
translate < -12, -6.5, -2 >
}
object {
box { < 0, 0, 0 >, < 1, 1, 1 > }
scale < 20, 13.362, 2.0148 >
rotate < -8.6732, 0, 0 >
translate < -12, -6.75, 0 >
}
object {
torus { 12, 0.06125 }
scale < 1, 12, 1 >
rotate < 90, 0, 0 >
translate < -12, 0, 0 >
}
object {
box { < 0, 0, 0 >, < 1, 1, 1 > }
scale < 2.75, 4.75, 2.5 >
translate < -2, 1.3531e-17, -1.25 >
}
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
scale < 0.25, 10, 0.25 >
rotate < 0, 0, -90 >
translate < -5, 0.75, 0 >
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
scale < 0.25, 10, 0.25 >
rotate < 0, 0, -90 >
translate < -5, 3, 0 >
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
scale < 0.25, 10, 0.25 >
rotate < 0, 0, -90 >
translate < -5, 2.25, 0 >
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
scale < 0.25, 10, 0.25 >
rotate < 0, 0, -90 >
translate < -5, 1.5, 0 >
}
object {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}
scale < 0.25, 2, 0.25 >
rotate < 90, 0, 0 >
translate < 0, 0, -1 >
}      
texture {pigment {rgb .6} finish {ambient .1 diffuse .6}}
texture {Scarring scale 1/2}
texture {Scarring scale 1}
texture {Scarring scale 2}
}
#macro GateFins(GteOpn,Flip) 
union {
union {GateFin rotate (-75*GteOpn+75)*z}
union {GateFin scale <1,-1,1> rotate (75*GteOpn-75)*z}
object {
RBox2
scale<0.375,0.875,2>
translate<0,-0.375,-1>
}
object {
RBox2
scale<0.25,0.125,1.75>
translate<0.25,-0.25,-0.875>
}
object {
RBox2 
scale<0.25,0.125,1.75>
translate<0.25,0.25,-0.875>
}
object {
RBox2
scale<0.25,0.125,1.75>
translate<0.25,0,-0.875>
}
scale <Flip,1,1>
texture {pigment {rgb .6} finish {ambient .1 diffuse .6}}
texture {Scarring scale 1/2}
texture {Scarring scale 1}
texture {Scarring scale 2}
 
//scale <1,1,1.5>
}
#end 

#macro Gate(St,Ed,Loc)
CM(St,Ed)
#declare keyclock = sin(((1-keyclock)-.5)*pi)/2+.5

union {GateFins(keyclock,1) translate <3+10*keyclock,.25-.25*keyclock,0>} 
union {GateFins(keyclock,-1) translate <-3-10*keyclock,-.25+.25*keyclock,0>}

union {GateFins(keyclock,1) translate <3+10*keyclock,.25-.25*keyclock,5-5*keyclock> rotate 90*z} 
union {GateFins(keyclock,-1) translate <-3-10*keyclock,-.25+.25*keyclock,5-5*keyclock> rotate 90*z}
#end

union {
GateWay(-.01,.35,0) 
Gate(.6,1.5,0) 
rotate 180*y
scale 10
}
#if (clock <=.35)
#include "NKflare.inc"
#end

Missile(0,1.01,<-25,0,1500>,<0,0,5>,4500/5,5,6,1)

global_settings {max_trace_level 100000}  
