#declare Start = .25;
#declare End = 1.0001; 
#declare keyclock = 0  
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#end
#end

#declare mclock = pow(keyclock,.5)
#declare mclock2 = sin((keyclock-.5)*pi)/2+.5

camera 
{
location  <0,-40*mclock+70,-80>*15/3*1.125
direction 15*z
look_at <0,0,0>  
rotate 140*mclock2*y
}

disc {0,y,20 no_shadow hollow 
texture {
pigment {
image_map {
png "radar01.png"  
interpolate 2
}
} 
finish {ambient 2} 
scale <40,40,1> 
rotate 90*x
translate <-20,0,-20>     
} 
texture {
pigment {
gradient z triangle_wave
color_map {
[0 rgbt <1,.45,0>*1.5]
[.25 rgbt <1,.45,0,.5>]
[1 rgbt <1,.45,0,1>]
}
} 
finish {ambient .5 diffuse 0}
scale 10
translate -20*z*clock
} 
texture {
pigment {
radial
color_map {
[.075 rgbt <1,.33,0,1>]
[.1 rgb <1,.75,0>*1.5]
[.125 rgbt <1,.5,0,.5>]
[1 rgbt <1,.33,0,1>]
}
}
finish {ambient 1 diffuse 0}
rotate -(360*2)*clock*y
} 







}

#declare Blip = 
sphere {0,1 hollow no_shadow
pigment {rgbt <0,0,0,1>}
interior {
media {
emission <1,.5,0>/2 
//intervals 25
density {
spherical
color_map {
[0 rgb 0]  
[.5 rgb .5]  
[1 rgb 1.5]
}       
}        
}
} 
 
scale 2.5 
}


cylinder {0,y*1,.5 pigment {rgb <1,.5,0>*1.5
}
finish {ambient 1 } 
translate <-2,0,-4>
} 
union {Blip translate <-2,1,-4>}     



#declare Start = .275;
#declare End = 1.0001; 
#declare keyclock = 0  
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#end


cylinder {0,y*(2-(.5*keyclock)),.5 pigment {rgb <1,.5,0>*1.5
}
finish {ambient 1 } 
translate <3,0,20>
translate <-2,0,-30>*keyclock
} 
union {Blip
translate <3,2,20>
translate <-2,-.5,-30>*keyclock
} 
#end 

#declare Start = .35;
#declare End = 1.0001; 
#declare keyclock = 0  
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#end

cylinder {0,y*(2-(-1*keyclock)),.5 pigment {rgb <1,.5,0>*1.5
}
finish {ambient 1 } 
translate <-2,0,20>
translate <1,0,-30>*keyclock
} 
union {Blip
translate <-2,2,20>
translate <1,1,-30>*keyclock
} 
#end
 


global_settings {
max_trace_level 120
}