#include "colors.inc"


#declare Start = .5
;
#declare End = 1.0001; 
#declare keyclock = 0  
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#end
#end

#declare CamAccel = pow(keyclock,2)
camera 
{
location  <80*CamAccel,40*CamAccel,-425*CamAccel>
direction 1*z
look_at <0,0,-3750*clock+3400>
}

// Object type: OmniLight
// Name: Omni Light
light_source
{
   < -250, 300, -150 >*10000
   color rgb 4
   //area_light 25,25,10,10
   //adaptive 0
}

sphere {< -250, 200, -150 >*10000,500000 pigment {rgb 20} no_shadow} 


// Object type: OmniLight
// Name: Omni Light
light_source
{
   < 250, 0, -250 >*10000
   color rgb <.5,.5,1>/2
   //area_light 25,25,10,10
   //adaptive 0
}


background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
}   
       
       
/*sphere {0,1000 scale <1,1,5> hollow no_shadow
pigment { bozo
color_map {
[0 rgbt <.125,.125,.4,.375>]
[1 rgbt <0,0,0,1>]
}
scale 600
turbulence 1.75
//omega .35 
scale <1,1,3>
}
finish {ambient .5 diffuse 0}
}*/ 


#declare C=0;
#while (C < 200)
#declare Seed = seed(C+22)
#declare Rand = rand(Seed)  

#declare Seed2 = seed(C*C+5)
#declare Rand2 = rand(Seed2)
intersection {
difference {
sphere {0,1}
sphere {0,.95}   
sphere {2*z,2
}
}
sphere {0,.875 scale <.5+Rand*.5,1+Rand2*2,4>} 
scale <1,1,.1+Rand2*.75>*1.5

texture {   
pigment { gradient y triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}
turbulence -.25*Rand-.25   
scale .25+.15*Rand2          
translate Rand2*y
}
}
texture {   
pigment { gradient x triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}  
turbulence .5*Rand2+.125
scale .25+.15*Rand2          
translate Rand2*x
}
}
texture {   
pigment { bozo
color_map {
[0 rgb .5-(<0,.15,.3>/2)*Rand]
[.3+.4*Rand2 rgb .25-<0,.075,.15>*Rand2]
[.425+.4*Rand2 rgb .5 transmit 1]
}   
turbulence 1
scale .35+.35*Rand2          
translate Rand2*y
}
}
rotate Rand*720
rotate 180*Rand2*clock
           
translate Rand*20*x
translate -Rand*100*y+15
translate Rand*100*z
rotate C*360*Rand
translate <Rand2*8*clock,Rand*-8*clock,Rand2*8*clock> 
rotate -C*180*Rand2

translate <-30,0,0>
}
#declare C=C+1;
#end

#declare C=0;
#while (C < 100)
#declare Seed = seed(C+122)
#declare Rand = rand(Seed)  

#declare Seed2 = seed(C*C+235)
#declare Rand2 = rand(Seed2)
intersection {
difference {
sphere {0,1}
sphere {0,.95}   
sphere {2*z,2
}
}
sphere {0,.875 scale <.5+Rand*.5,1+Rand2*2,4>} 
scale <1,1,.1+Rand2*.75>*1.5

texture {   
pigment { gradient y triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}
turbulence -.25*Rand-.25   
scale .25+.15*Rand2          
translate Rand2*y
}
}
texture {   
pigment { gradient x triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}  
turbulence .5*Rand2+.125
scale .25+.15*Rand2          
translate Rand2*x
}
}
texture {   
pigment { bozo
color_map {
[0 rgb .5-(<0,.15,.3>/2)*Rand]
[.3+.4*Rand2 rgb .25-<0,.075,.15>*Rand2]
[.425+.4*Rand2 rgb .5 transmit 1]
}   
turbulence 1
scale .35+.35*Rand2          
translate Rand2*y
}
}
rotate Rand*720
rotate 180*Rand2*clock
           
translate Rand*20*x
translate -Rand*100*y+15
translate Rand*100*z
rotate C*360*Rand
translate <Rand2*8*clock,Rand*-8*clock,Rand2*8*clock> 
rotate -C*180*Rand2

translate <0,0,80>
}
#declare C=C+1;
#end




#macro Defl(Locat,Rotat,Flare,Duration) 
#if (clock >= Flare)
#if (clock <= Flare+Duration)
sphere {0,50 scale <1,.66,2> 
texture {   
pigment { gradient z triangle_wave
color_map {
[0 rgb <.5,.5,1>]
[.25 rgb <.25,.25,1> transmit .5]
[1 rgb 0 transmit 1]
}  
turbulence 1
scale 20
translate -Locat
}
finish {ambient 1 phong 1}
}  

texture {   
pigment { bozo
color_map {
[0 rgb <.5,.5,1>]
[.33 rgb <.25,.25,1> transmit .5]
[1 rgb 0 transmit 1]
}        
turbulence 2
scale 20
translate -Locat
}
finish {ambient 1 phong 1}
}
rotate Rotat
translate Locat
}
#end
#end   
#end

#macro FFTest(Loc,Rot) 
#if (Rot.z > 90)
#declare RotZ = 90;  
#else              
#declare RotZ = Rot.z;
#end 
 
#if (Rot.x > 90)
#declare RotX = 90;
#else              
#declare RotX = Rot.x;
#end 

#declare EngRot1 = ((RotZ)/2)+((-RotX)/2) 
#declare EngRot2 = ((-RotZ)/2)+((-RotX)/2)

union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1> rotate Rot}  

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate -37.5*x rotate <EngRot2,0,0>} 
sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate 37.5*x rotate <EngRot1,0,0>} 

scale .75
 
translate Loc
}


#end   


#declare Rclock = sin(clock*2*pi)


//FFTest(<-50-(15*Rclock),-20,-3800*clock+3400>,<0,0,15*Rclock>) 
//FFTest(<40+(10*Rclock),0,-3800*clock+3460>,<0,0,-15*Rclock-5>)

//Defl(<-50-(15*Rclock),-20,-3800*clock+3400>,<0,0,15*Rclock>,.474,.025)
//Defl(<40+(10*Rclock),0,-3800*clock+3460>,<0,0,-15*Rclock-5>,.525,.0125) 

//Defl(<-50-(15*Rclock),-20,-3800*clock+3400>,<0,0,15*Rclock>,.5,.035)
//Defl(<40+(10*Rclock),0,-3800*clock+3460>,<0,0,-15*Rclock-5>,.55,.0125)

Defl(<-50-(15*Rclock),-20,-3800*clock+3400>,<0,0,15*Rclock>,.6,.0125)
Defl(<40+(10*Rclock),0,-3800*clock+3460>,<0,0,-15*Rclock-5>,.65,.025)

Defl(<-50-(15*Rclock),-20,-3800*clock+3400>,<0,0,15*Rclock>,.685,.01)
Defl(<40+(10*Rclock),0,-3800*clock+3460>,<0,0,-15*Rclock-5>,.725,.05)



#include "COM Fighter.inc"

TiltFighter(<-50-(15*Rclock),-20,-3800*clock+3400>,<0,0,15*Rclock>,0,false,1)
TiltFighter(<40+(10*Rclock),0,-3800*clock+3460>,<0,0,-15*Rclock-5>,0,false,2)
