camera { location <0,0,-120> direction 1*z look_at 0}
light_source {<-150,300,-150>*10000
color rgb 4
//area_light 25,25,10,10
//adaptive 0
} 
                                                        
box {0,<1,1,0> hollow on 
texture {
finish {ambient 1 diffuse 1}
pigment {
image_map {
png "backgrid"
interpolate 2
}
}
finish {ambient .75 diffuse 0}
} 

   
scale <160,55,1>
translate <-80,-27.5,-.001> 
} 
#macro SpatialText(Per)
union {  
text { ttf "c:\pov\display.ttf" "S" .25, 0 
translate -.5*x translate -2.5*x*Per}  

text { ttf "c:\pov\display.ttf" "P" .25, 0 
translate -.5*x translate -1.5*x*Per} 

text { ttf "c:\pov\display.ttf" "A" .25, 0 
translate -.5*x translate -.5*x*Per} 

text { ttf "c:\pov\display.ttf" "T" .25, 0 
translate -.5*x translate .5*x*Per} 

text { ttf "c:\pov\display.ttf" "I" .25, 0 
translate -.5*x translate 1.5*x*Per}

text { ttf "c:\pov\display.ttf" "A" .25, 0 
translate -.5*x translate 2*x*Per}

text { ttf "c:\pov\display.ttf" "L" .25, 0 
translate -.5*x translate 3*x*Per} 

pigment { rgb 0 transmit 1} 
interior {
media{
emission <.375,.375,1>/48
density { bozo    
color_map{ 
[0 rgb 1]
[1 rgb 5]
}
scale .25 
translate -8*z*clock
}
density { spherical    
color_map{ 
[0 rgb .25]
[1 rgb 2.5*Per+2.5]
}
scale 4
}
}  
}
hollow on no_shadow 
scale <1,1.5,2>
rotate (-30+30*Per)*x

scale 18
translate <0,6,-30>
}

sphere {0,1 
pigment { rgb 0 transmit 1}  
scale <2*Per+1,.5,1>
interior {
media{
emission <.375,.375,1>/(1*Per+1)
density { bozo    
color_map{ 
[0 rgb 0]
[1 rgb 1]
}
scale .25 
translate -8*z*clock
}
density { spherical    
color_map{ 
[0 rgb 0]
[1 rgb -.5*Per+1]
}
scale <2*Per+1,.5,1>
}
}  
}
hollow on no_shadow
scale 18   
translate <0,10,-30>
}

#end  

#macro DecayText(Per)
union {  
text { ttf "DecayText.ttf" "D" .25, 0 
translate -.5*x translate -1.5*x*Per}  

text { ttf "DecayText.ttf" "E" .25, 0 
translate -.5*x translate -.75*x*Per} 

text { ttf "DecayText.ttf" "C" .25, 0 
translate -.5*x } 

text { ttf "DecayText.ttf" "A" .25, 0 
translate -.5*x translate .75*x*Per} 

text { ttf "DecayText.ttf" "Y" .25, 0 
translate -.5*x translate 1.5*x*Per}




texture {   
pigment { gradient y triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>/2]
[.05 rgb .25]
[.1 rgb .5 transmit 1]
}
turbulence -.25  
scale .05       
}
}
texture {   
pigment { gradient x triangle_wave
color_map {
[0 rgb .5]
[.05 rgb .25-<0,.075,.15>/2]
[.1 rgb .5 transmit 1]
}  
turbulence .5
scale .05        
}
}
texture {   
pigment { bozo
color_map {
[0 rgb .5-(<0,.15,.3>/2)]
[.4 rgb .25]
[.45 rgb .5 transmit 1]
}   
turbulence 1
scale .25
}
}

hollow on no_shadow 
scale <1,1,2>
scale 32
translate <6,-25,-30>
}


#end  


#declare Start = .1;
#declare End = .4; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end 

#declare mclock2 = sin((keyclock-.5)*pi)/2+.5




#declare Start = .33;
#declare End = .66; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock = pow(keyclock,2)




SpatialText(mclock2) 
DecayText(1-mclock)



#macro Debris(RNum,Num,Loc,Clock)
#declare C=0;
#while (C < Num)
#declare Seed = seed(C+RNum)
#declare Rand = rand(Seed)  
#declare Seed2 = seed(C*C+RNum*RNum)
#declare Rand2 = rand(Seed2)
intersection {
difference {
sphere {0,1}
sphere {0,.95}   
sphere {2*z,2
}
}
sphere {0,.875 scale <.5+Rand*.5,1+Rand2*2,4>} 
scale <1,1,.1+Rand2*.75>*1.5

texture {   
pigment { gradient y triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}
turbulence -.25*Rand-.25   
scale .2+.15*Rand2          
translate Rand2*y
}
}
texture {   
pigment { gradient x triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}  
turbulence .5*Rand2+.125
scale .2+.15*Rand2          
translate Rand2*x
}
}
texture {   
pigment { bozo
color_map {
[0 rgb .5-(<0,.15,.3>/2)*Rand]
[.3+.4*Rand2 rgb .25-<0,.075,.15>*Rand2]
[.425+.4*Rand2 rgb .5 transmit 1]
}   
turbulence 1
scale .35+.35*Rand2          
translate Rand2*y
}
}

scale 2
rotate Rand*720
rotate 480*Rand2*clock
translate (Rand*80*Clock)*x
translate (-Rand*35*Clock+5)*y
translate (Rand*60*Clock+10)*z
rotate C*360*Rand
//translate <Rand2*8*clock,Rand*-8*clock,Rand2*8*clock> 
rotate -C*180*Rand2 
translate Loc
}
#declare C=C+1;
#end  
#end 

#declare Start = .5;
#declare End = 1.0001; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock2 = pow(keyclock,.5)

#if (clock > Start)
Debris(10,200,<0,-15,-30>,1.5*mclock2)
#end
//