#include "colors.inc"
camera 
{
location  <-3,0,-3>
direction 1*z
look_at 0
}
light_source {<-250,300,-150>*10000
color rgb 2
//area_light 25,25,10,10
//adaptive 0
}
background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
} 

#declare C=0;
#while (C < 60)
#declare Seed = seed(C+62)
#declare Rand = rand(Seed)  
#declare Seed2 = seed(C*C+523)
#declare Rand2 = rand(Seed2)
intersection {
difference {
sphere {0,1}
sphere {0,.95}   
sphere {2*z,2
}
}
sphere {0,.875 scale <.5+Rand*.5,1+Rand2*2,4>} 
scale <1,1,.1+Rand2*.75>*1.5

texture {   
pigment { gradient y triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}
turbulence -.25*Rand-.25   
scale .2+.15*Rand2          
translate Rand2*y
}
}
texture {   
pigment { gradient x triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}  
turbulence .5*Rand2+.125
scale .2+.15*Rand2          
translate Rand2*x
}
}
texture {   
pigment { bozo
color_map {
[0 rgb .5-(<0,.15,.3>/2)*Rand]
[.3+.4*Rand2 rgb .25-<0,.075,.15>*Rand2]
[.425+.4*Rand2 rgb .5 transmit 1]
}   
turbulence 1
scale .35+.35*Rand2          
translate Rand2*y
}
}


rotate Rand*720
rotate 180*Rand2*clock
translate Rand*20*x
translate -Rand*15*y+5
translate Rand*30*z
rotate C*360*Rand
translate <Rand2*8*clock,Rand*-8*clock,Rand2*8*clock> 
rotate -C*180*Rand2
}
#declare C=C+1;
#end  
