#include "colors.inc"
#include "woods.inc"

sky_sphere
{
  pigment
  {
    bozo turbulence 1
    color_map { 
    [0.0 color rgb <0,0,.5>] 
    [0.25 color rgb <0,0,.5>]
    [1.0 color rgb<1,1,1>]}
   rotate <0,0,1*clock>} scale <1, 0.25, 1>
}

light_source {<-2000, 1000, 1000> color rgb<2,2,2>}

camera {location <.55, 2, .45> look_at <3, 4.75+(3*clock), .45>}


//camera to catch explosion
//camera {location <0,0,0> rotate <0,0,5>  translate <.5, .45,.5-(1.5*clock)> 
//   look_at  <.65, .45+(.5*clock), .4>
//   }

plane {y,.4 pigment { bozo 
    pigment_map { 
    [0.0 color rgb <0,1,0>] 
    [0.5 color rgb <.25,.75,.5>]
    [1.0 color rgb <0,1,0>]}} }
   
//sandbox
//difference{
//box{<0,.25,0><1,.5,1>}
//box{<.025,1.25,.025><.975,-1.25,.975>}
//texture {T_Wood1 scale .1 } finish {ambient .33  phong .25}
//}
//height_field {tga "c:\mydocu~1\animat~1\celseq~1\images\sandbox.tga" pigment {rgb<1,.9,.8>}
//   normal {bozo } smooth finish {ambient .53}}                         

prism {linear_spline .2,.25,7, 
  <1,0>,
  <1.33,-.25>,
  <1.67,-.25>,
  <2,0>,
  <1.67,.25>,
  <1.33,.25>,
  <1,0>
  pigment {rgbt<1,1,0,0>} finish {phong 1} rotate <90,0,0> scale .25 translate <-.25,0,0>}

//ant

declare walkant=union{
blob{
  threshold .65
  sphere {<0,.1,.05>, .5, 1}
  sphere {<0,0,.15>,.25, 1}
}
cylinder{<.15,.1,.05><.15,.5,.05>,.01}
cylinder{<.15,.5,.05><.25,.65,.5>,.01}
cylinder{<-.15,.1,.05><-.15,.5,.05>,.01}
cylinder{<-.15,.5,.05><-.25,.65,.5>,.01}
cylinder {<0,.1,0><0,-.5,0>, .05}
sphere {<0,-.45,0>, .2}
cylinder {<0,-.5,0><0,-1, -.5>,.05}
sphere { <0,0,0>,.5 scale <.5,.5,1> rotate <-45,0,0>  translate <0,-1, -.5>}


cylinder {<0,-.45,0><-.35, -.75, -.35>,.05}
cylinder {<-.35, -.75, -.35><-.25,-1,.3>,.05}

cylinder {<0,-.45,0><.35, -.75, -.35>,.05}
cylinder {<.35, -.75, -.35><.25,-1,.3>,.05}

cylinder {<0,-.45,0><-.35, -.45, -.35>,.05}
cylinder {<-.35, -.45, -.35><-.25,-.55,.3>,.05}

cylinder {<0,-.45,0><.35, -.45, -.35>,.05}
cylinder {<.35, -.45, -.35><.25,-.55,.3>,.05}

//legs

union{

//leg1

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 rotate <0,0,(5*sin(4*clock))-5> translate <0,-3,0>}
rotate <0,0,15*sin(clock*4)> translate <0,6, .5>
}

//leg2

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 rotate <0,0,(5*sin(4*clock))-5> translate <0,-3,0>}
rotate <0,0,15*sin(-clock*4)> translate <0,6, -.5> }    

rotate <0,270,0> scale <.25, .20, .25> translate <0,-1.8,0>
pigment{rgb<1.015,0,0>} finish {phong 1.015 reflection .76125}
}
}

//#object {ant scale .0125 rotate <0,180,0> translate <.985,.52,.975-(.5*clock)/15>}

//#object {ant scale .0125 rotate <0,270,0> translate <.8-(.125*clock),0.472893549,.475>
//   pigment{rgb<1.015,0,0>} finish {phong 1.015 reflection .76125}}
   
declare robot = union {
                      
//head
union{                                   
  difference{                                   
    sphere {<0,0,0>,1 scale <.667,1,.333>}
    box {<-1,.3,-1><1,2,1>}
    pigment {rgb<1,1,1>} finish {ambient .25 phong 1 reflection .25}
  }
  difference{
    box{<-.65,-.75,-.25><-.85,1,1> pigment {rgb<0,0,1>}}
    box{<-2,.4,-1> <2,2,0>}
    }
  difference {
    box{<.65,-.75,-.25><.85,1,1> pigment {rgb<0,0,1>}}
    box{<-2,.4,-1> <2,2,0>}    
    }
  box{<.85,.8,-.35><-.85,1.05,1> pigment{rgb<0,0,1>}}
  box{<.65,1.05,0><-.65,1.25,1> pigment{rgb<0,0,1>}}
  box{<.2,.9,-.375><-.2,1.15,0> pigment{rgb<1,1,0>}}
  cone{<0,.85,-.175>,.0625 <0,3,-.175>,0 pigment {rgb<1,1,0>}}
  cone{<0,.85,-.175>,.0625 <1,2,-.175>,0 pigment {rgb<1,1,0>}}
  cone{<0,.85,-.175>,.0625 <-1,2,-.175>,0 pigment {rgb<1,1,0>}}
    
  prism {linear_spline -.4,.4,7, 
    <1,0>,
    <1.33,-.25>,
    <1.67,-.25>,
    <2,0>,
    <1.67,.25>,
    <1.33,.25>,
    <1,0>
    pigment {rgbt<1,1,0,.5>} finish {ambient 2 phong 1} rotate <90,0,0> scale .4 translate <-.93,.6,0>} 

  prism {linear_spline -.4,.4,7, 
    <1,0>,
    <1.33,-.25>,
    <1.67,-.25>,
    <2,0>,
    <1.67,.25>,
    <1.33,.25>,
    <1,0>
    pigment {rgbt<1,1,0,.5>} finish {ambient 2 phong 1} rotate <90,0,0> scale .4 translate <-.18,.6,0>}  
  
box{<-.65,-.75,0><.65,1,1> pigment {rgb<1,0,0>}}
box{<-.15,.5,-.5><.15,.15,.25> rotate<30,0,0> pigment {rgb<1,0,0>} }
cylinder {<0,0,.325><0,-1,.325>, .4 pigment {rgb<1,1,1>} finish {phong 1  reflection .25} }
cylinder {<0,-.95,.325><0,-1,.325>, .75 pigment {rgb<1,1,1>} finish {phong 1  reflection .25} }
cylinder{<-1.15,.25,.75><1.15,.25,.75>,.25 scale <1,1,1> pigment {rgb<1,1,1>} finish {phong 1  reflection .25} }
cone {<-1.15,.25,.75>,.05 <-1.15,2.75,.75>,0 pigment {rgb<1,1,1>} finish {phong 1  reflection .25} }
cone {<1.15,.25,.75>,.05 <1.15,2.75,.75>,0 pigment {rgb<1,1,1>} finish {phong 1 reflection .25} }

//body

difference{
sphere {<0,-6,0>,4.1 scale <1,.5, .33> pigment {rgb<1,0,0>} finish {phong 1 reflection .25}}
box {<-5, 2,-3> <-2.5, -6,3> pigment {rgb<1,1,1>} finish {phong 1 reflection .25}}
box {<5, 2,-3> <2.5,-6,3> pigment {rgb<1,1,1>} finish {phong 1 reflection .25}}
} 

box {<-1.5, -7,-.5> <1.5,-3,.75> pigment {rgb<1,1,1>} finish {ambient .25 phong 1 reflection .25}}    

difference{
sphere {<0,-15,0>,3 scale <1,.5, .33> pigment {rgb<1,0,0>} finish {phong 1 reflection .25}}
box {<-5, 2,-3> <-2, -20,3> pigment {rgb<1,1,1>} finish {phong 1 reflection .25}}
box {<5, 2,-3> <2,-20,3> pigment {rgb<1,1,1>} finish {phong 1 reflection .25}}
} 

//legs

box {<-2,-7,-.5><-.5,-13,.5> pigment {rgb<1,1,1>} finish {phong 1 reflection .25}}
box {<-2.2,-12,-.52><-.48,-17,.52> pigment {rgb<1,0,0>} finish {phong 1 reflection .25}}
box {<-2.2,-15.5,-1.52><-.48,-17,.52> pigment {rgb<1,0,0>} finish {phong 1 reflection .25}}

box {<2,-7,-.51><.5,-17,.51> pigment {rgb<1,1,1>} finish {phong 1 reflection .25}}
box {<2.2,-12,-.52><.48,-17,.52> pigment {rgb<1,0,0>} finish {phong 1 reflection .25}}
box {<2.2,-15.5,-1.52><.48,-17,.52> pigment {rgb<1,0,0>} finish {phong 1 reflection .25}}

//cockpit
sphere {<0,-3,-1>, 1 pigment {rgbt <0,1,.6,.65>} finish {ambient 1 reflection .5 phong 1}}

//arms

union {
box {<-4.1,-1.9,-.1><4.1,-2.1,.1> pigment {rgb <1,1,1>} finish {ambient .25 phong 1 reflection .25}}

//left arm

difference {
sphere {<-3.5,-2,0>,1.5 }
box {<10,-2,-10><-10,-10,10>}
box {<-3.5, -10, 10> <10, 10, -10>}
pigment {rgb<0,0,1>} scale <2,1,1>translate <4,-.5,0>}

box {<4,-1.5,.5><5,-5,-.5> pigment {rgb <1,1,1>} finish {ambient .25 phong 1 reflection .25}}
sphere { <4.5,-5.25,0>,.5 pigment {rgb<0,0,1>}}
box {<3.9,-5.75,.6> <5.1,-9,-.6> pigment {rgb<1,0,0>} finish {ambient .25 phong 1 reflection .25}}
sphere { <4.5,-9.25,0>,.75 pigment {rgb<1,1,1>} finish {ambient .25 phong 1 reflection .25}}


//right arm

difference {
sphere {<3.5,-2,0>,1.5 }
box {<-10,-2,-10><10,-10,10>}
box {<3.5, -10, 10> <-10, 10, -10>}
pigment {rgb<0,0,1>} scale <2,1,1> translate <-4,-.5,0>}           

box {<-4,-1.5,.5><-5,-5,-.5> pigment {rgb <1,1,1>} finish {ambient .25 phong 1 reflection .25}}
sphere { <-4.5,-5.25,0>,.5 pigment {rgb<0,0,1>}}
box {<-3.9,-5.75,.5> <-5.1,-9,-.5> pigment {rgb<1,0,0>} finish {ambient .25 phong 1 reflection .25}}
sphere { <-4.5,-9.25,0>,.75 pigment {rgb<1,1,1>} finish {ambient .25 phong 1 reflection .25}}

rotate <0,0,0>} scale <1,1,1>}

}

#object {robot rotate <0,75+(25*clock),0> scale <.015625, .015625, .015625> translate <.65, 2+clock, .45>}


//explosion
 
//#declare numrock=1

//#declare sizaccel=seed(1)
//#declare r2=seed(2)

//#while (numrock<250)

//union{ 
//sphere {<0,0,0>,.65*(clock-.75) hollow on
//pigment {rgbt<1,1,1,1>}
//interior{
//media { emission intervals 10
//samples 1, 1
//confidence .9
//variance 1/128
//ratio 0.9
//emission 2
//density { spherical turbulence 1+(clock-1.0111111111)      
//   color_map{
//   [0.0 rgbt <0,0,0,clock-1.0111111111>]
//   [.25 rgbt <1,0,0,clock-1.0111111111>]
//   [0.5 rgbt <1,.5,0,clock-1.0111111111>]   
//   [1.0 rgbt <1,1,1,clock-1.0111111111>]
//      }
// } }
//}
//scale <1,2,1>}
  
//sphere {<0,0,0>,1/60*rand(sizaccel) 
//    translate <0,.5*rand(sizaccel)*sin(pi*(clock-1.0111111111)/2),1*(clock-1.0111111111)*rand(sizaccel)> 
//    rotate <0,360*rand(r2),0>
//    pigment {rgb<1,1,1>}
//}
//translate <.65, .4, .45> }

//#declare numrock=numrock+1

//#end
