#declare cam_start   = <-170.71, -60, 30>;     
#declare cam_start_a = cam_start + < 150, 0, 0>;               
#declare cam_start_b = cam_start_a + <50*sin(radians(135)), -50 +  50 * cos(radians(135)), 0>;      
#declare cam_start_c = cam_start_b + < 50 * (sin(radians(-90))+sin(radians(45))), 50 * ( cos(radians(-90)) - cos(radians(45))), 0>;
#declare cam_start_d = cam_start_c + < 0, -200, 0>; 
#declare cam_end     = cam_start_d + <0, -1500, 0>;

#switch (clock)
   #range(0,0.23)
      #declare cam_location = cam_start + <clock/.23*150, 0, 0>;
      #break    
   #range(0.23,0.41)                                               
      #declare temp_radians = radians((clock-.23)/.18*135);
      #declare cam_location = cam_start_a + < 50* sin (temp_radians), -50 +  50 * cos(temp_radians), 0>;
      #break                                                                                     
   #range(0.41,0.47)                  
      #declare temp_radians = radians(-45 - (clock-.41)/.06*45 );                                    
      #declare cam_location = cam_start_b + < 50 * (sin(temp_radians)+sin(radians(45))), 50 * ( cos(temp_radians) - cos(radians(45))), 0>;  
      #break                          
   #range(0.47,0.80)                  
      #declare cam_location = < 0, - ( (clock - 0.47)/(0.8 - 0.47)) * 200, 0 > + cam_start_c;             
      #break        
   #range(0.80,.9)                                  
      #declare temp_radians = radians((clock-.8)/.1*180 -90);
      #declare cam_location = cam_start_d + <0, -1500 * (1 + sin(temp_radians)) /2 , 0>;
      #break
   #else
      #declare cam_location = cam_end;        
#end                                 
//#debug concat("pos_cam = ", str(cam_location.x,2,2), " " , str(cam_location.y,2,2), " ", str(cam_location.z,2,2), "\n")
                                      

#declare look_start   = <-125, 0, 10>;   
#declare look_start_a = look_start + <200, 0, 0>;                              
#declare look_start_b = look_start_a + <-75, 0, 0>;   
#declare look_end     = look_start_b -100*z;                           

#switch(clock)
   #range (0, 0.3)
      #declare temp_radians = radians(clock/0.3*180 -90);
      #declare look_location = look_start + <200* (sin(temp_radians)+1)/2, 0,0>;      
      #break      
   #range (0.3, 0.47)
      #declare temp_radians = radians((clock-0.3)/0.15*180 -90);
      #declare look_location = look_start_a + < -75 * (sin(temp_radians)+1)/2, 0,0>;
      #break         
   #range(0.47, 0.8)
      #declare look_location = look_start_b;
      #break
   #range(0.8,1)        
      #declare temp_radians = radians((clock-0.8)/0.2*180 -90);
      #declare look_location = look_start_b + < 0,0, -100 * (sin(temp_radians)+1)/2>;
      #break      
   #else
      #declare look_location = look_end;
#end                        
//#debug concat("pos_look = ", str(look_location.x,2,2), " " , str(look_location.y,2,2), " ", str(look_location.z,2,2), "\n")
