// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic TTF font Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.1;

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 1.0, -6.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.25,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 10, -30>
}

// ----------------------------------------

#declare Text_Tex = texture
{
  pigment { granite scale 0.5 }
  finish { specular 0.7 }
}

text
{
  ttf "tt_omnib.ttf", "TEAM BEANIE",
  0.75, // depth
  0  // spacing
  texture {Text_Tex} 
  scale 0.9
  translate <-2.3, 0.5, 0>
}

text
{
  ttf "tt_omnib.ttf", "BY CORY NICHOL",
  0.5, // depth
  0  // spacing
  texture {Text_Tex}
  scale 0.6   
  translate < -2.3, -0.5, 0>
}


difference {
   sphere { <0, 0, 0> 0.25 }
   plane { y, 0}
   material  
   {   
      texture
      {      
         pigment
         {
            radial    
            frequency 8
            color_map
            {
               [ 0.0     rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <1.0, 0.0, 0.0, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 0.0, 0.0, 0.0, 0.0> ]
            }
            
         }
      }
   rotate 90
   } 
   translate <-0.64, 1.2,0>
}

cylinder // Main post
{
  0*y,  0.25*y,  0.01       
   material  
   {   
      texture
      {      
         pigment
         {
            radial    
            frequency 2
            color_map
            {
               [ 0.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
               [ 1.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
            }
            
         }
      }
   }   
   translate < -0.64, 1.25, 0>
}


superellipsoid { 
  <1.0, 5.0> 
   material  
   {   
      texture
      {      
         pigment
         {
            radial    
            frequency 1
            color_map
            {
               [ 0.0     rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
               [ 0.5     rgbft <1.0, 0.0, 0.0, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 0.0, 0.0, 0.0, 0.0> ]
            }
            
         }
      }
   rotate 90*x        
   rotate 90*z
   }
  rotate 360*clock*y
  scale <0.25, 0.025, 0.025>
  translate <-0.64, 1.5,0>
}    

