
#include "objUtils.inc"
                        
#declare SlickCardboard  = 
texture {   
  pigment { color rgb <1.0, 1.0, 1.0> }   
  normal {
    gradient <1.0, 1.0, 0.0> , 0.01
    scale  0.05
  }   
  finish {
    ambient 0.27
    diffuse 0.8
    reflection 0.02
  }
}

#declare BrownCardboard = 
texture {      
  pigment {  color rgb <0.675, 0.472, 0.325> }      
  normal {
    gradient <1.0, 1.0, 0.0> , 0.02
    scale  0.1
  }      
  finish {
    ambient 0.3
    diffuse 0.7
    specular 0.1
  }      
}
                        
#macro RobotBox(outer_flap_angle, top_flap_angle, bottom_flap_angle)
#local bh = 7.5;   //box height
#local bw = 3;   //box width
#local bd = 2;     //box depth
#local corner_rad = 0.05;
#local bt = 0.105; //box thickness 
#local eg = 0.01;   //edge gap
#local bh2 = bh/2;
#local bw2 = bw/2; 
#local bd2 = bd/2;
union {
  difference { //outside of main box      
    union {
      rsRoundBox(<-bd2, -bw2, -bh2>, <bd2, bw2, bh2>, corner_rad)
    }
    box {
      <(bd-bt)/2, (bw-bt)/2, (bh-bt)/2>,
      <-(bd+1)/2, -(bw-bt)/2, -(bh-bt)/2>
    }
    texture {SlickCardboard}
  }
  box {          //outside right door
    <-bt/2, 0, -bh2+bt/2+eg>,<0, bw2-bt/2-eg, bh2-bt/2-eg> 
    material {
      texture {SlickCardboard}
      texture {   
        pigment {
          image_map  {
            gif   "fedex_pak.gif" once interpolate 2
          }
        }
        normal {
          gradient <1.0, 1.0, 0.0> , 0.01
          scale  0.05
        }   
        finish {
          ambient 0.27
          diffuse 0.8
          reflection 0.02
        }
        scale <bw*1.5,bw,1>
        rotate <90,90,-90> 
        translate <0,bw-bt/2,bh*0.45>
        
      }
    }
    rotate z*outer_flap_angle
    translate <-bd2+bt/2, -bw2+bt/2, 0>
  }
  box {        //outside left door
    <-bt/2, -bw2+bt/2+eg, -bh2+bt/2+eg>,<0, 0, bh2-bt/2-eg> 
    material {
      texture {SlickCardboard}
      texture {   
        pigment {
          image_map  {
            gif   "fedex_pak.gif" once interpolate 2
          }
        }
        normal {
          gradient <1.0, 1.0, 0.0> , 0.01
          scale  0.05
        }   
        finish {
          ambient 0.27
          diffuse 0.8
          reflection 0.02
        }
        scale <bw*1.5,bw,1>
        rotate <90,90,-90> 
        translate <0,bt/2,bh*0.45>
      }
      texture {   
        pigment {
          image_map  {
            gif   "TitleCredits.gif" once interpolate 2
          }
        }
        normal {
          gradient <1.0, 1.0, 0.0> , 0.01
          scale  0.05
        }   
        finish {
          ambient 0.27
          diffuse 0.8
          reflection 0.02
        }
        scale <1.05, 0.7, 0.7>
        rotate <90,0,-90> 
        translate <0, -2.5*bt,bh*0.1>
      }
    }
    rotate -z*outer_flap_angle
    translate <-bd2+bt/2, bw2-bt/2, 0>
  }
  box {  //top flap
    <0 , -bw2+bt, -bw2+bt+eg>,<bt/2, bw2-bt, 0> 
    texture {SlickCardboard}
    rotate y*top_flap_angle
    translate <-bd2+bt/16, 0, bh2-bt/4>
  }
  box {  //bottom flap
    <0 , -bw2+bt, bw2-bt-eg>,<bt/2, bw2-bt, 0> 
    texture {SlickCardboard}
    rotate -y*bottom_flap_angle
    translate <-bd2+bt/16, 0, -bh2+bt/4>
  }
    
  union {  // Brown inside of box 
    difference {       //inside of box
      box {
        <(bd-bt)/2, (bw-bt)/2, (bh-bt)/2>,
        <-(bd-bt)/2, -(bw-bt)/2, -(bh-bt)/2>
      }
      union {
        box {
          <(bd2-bt), (bw2-bt), (bh2-bt)>,
          <-(bd+1)/2, -(bw2-bt), -(bh2-bt)>
        }
        box {
          <-bd2+bt, bw2-bt/2, bh2>,
          <-bd2-bt, -bw2+bt/2, -bh2> 
        }
      }
    }
    box {          //inside right door
      <0, 0, -bh2+bt/2+eg>,<bt/2, bw2-bt/2-eg, bh2-bt/2-eg> 
      rotate z*outer_flap_angle
      translate <-bd2+bt/2, -bw2+bt/2, 0>
    }
    box {        //inside left door
      <0, -bw2+bt/2+eg, -bh2+bt/2+eg>,<bt/2, 0, bh2-bt/2-eg> 
      rotate -z*outer_flap_angle
      translate <-bd2+bt/2, bw2-bt/2, 0>
    }
    box {  //top flap
      <bt/2 , -bw2+bt, -bw2+bt+eg>,<bt, bw2-bt, 0> 
      rotate y*top_flap_angle
      translate <-bd2+bt/16, 0, bh2-bt/4>
    }
    box {  //bottom flap
      <bt/2 , -bw2+bt, bw2-bt-eg>,<bt, bw2-bt, 0> 
      rotate -y*bottom_flap_angle
      translate <-bd2+bt/16, 0, -bh2+bt/4>
    }
    texture {BrownCardboard}
  }
  translate z*(bh2+0.02)
} 
#end