// Clock   Frame
// 700     000-050 Title
// 000-045 050-095 Air molecules floating around
// 045-090 095-140 Pan down to surface (pan more naturally)
// 090-180 140-230 Robot goes by
// 180-270 230-320 Watch robot split into two robots
// 270-384 320-434 Watch new robot land near lots of other robots
// 385-475 434-525 CNN.com close-up
// 475-655 525-705 Zoom-out then in to show desk being consumed
// 655-700 705-750 Desk consumption continues up-close
// 700-900 750-950 Credits

#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"  
#include "stones2.inc"
#include "woods.inc"

#declare rspin = 8;
#declare rdeg = 0.2;
#declare rseed = seed(0);
#declare fade = 1;

//ROBOT
#macro RobotMacro (height)
  #declare loopnum = 0;
  #while (loopnum <= height)
    #declare angleval = 0;
    #while (angleval < 360)
      sphere { <0,0,4>,.75 
        rotate y*angleval
        #declare newx = rdeg * sin( radians(rspin*clock + 360*rand(rseed)));
        #declare newy = rdeg * sin( radians(rspin*clock + 360*rand(rseed)));
        #declare newz = rdeg * sin( radians(rspin*clock + 360*rand(rseed)));
        translate <newx, newy + loopnum, newz>
        pigment { rgb <fade*.4,fade*.4,fade*.4> }
        finish { specular .1 roughness .5 }
      }
      #declare angleval = angleval + 15;  
    #end
    #declare loopnum = loopnum + 1;
  #end
#end

//Begin atomic scale
#if (clock<385)
#declare robspeed = 1;
#declare cx=4;
#declare cy=20;
#declare cz=-24;

camera {
  #declare lx = 0;
  #declare ly = 0;
  #if (clock < 45)
    #declare ly = cy + 20;
  #end 
  #if (clock >= 45 & clock < 90)
    //#declare ly = cy + 20 - (clock-45)*40/45;
    #declare ly = cy + 20 - sin(radians(2*(clock-45))) * (clock-45)*40/45;
  #end
  #if (clock >= 180 & clock < 270)
    #declare cx = -(clock-135)*robspeed;
    #declare cy = 5;
    #declare lx = cx;
    #declare ly = cy+5;
    #declare cz = -20;
  #end
  #if (clock >= 270 & clock < 315)
    #declare ly = cy + 20 - (clock-270)*40/45;
  #end
  location  <cx,  cy, cz>
  look_at <lx, ly, 0>
}


//ROBOTS
#if (clock < 270)
  union { RobotMacro(5) translate <-(clock-135)*robspeed,0,0> }
  #if (clock < 225)
    union { RobotMacro(5) translate <-(clock-135)*robspeed,5,0> }
  #else
    union { RobotMacro(5) 
      rotate <0,0,-2*(clock-225)> 
      translate <-(clock-135)*robspeed,5,0>
      translate <(clock-225)*.25,.7*(clock-225),0>
      }
  #end
#else
  #if (clock < 315)
    union { RobotMacro(5)
      rotate <0,0,315-clock>
      translate <.4*(clock-315),0.75*(315-clock),15>
      }
  #else
    union { RobotMacro(5) translate <clock-315,0,15> } 
  #end
  union { RobotMacro(7) 
    //First drop
    #if (clock-360 >= -4 & clock-360 <= -2)
      #if (clock-360 = -4 | clock-360 = -2)
        rotate <20,0,0>
      #end
      #if (clock-360 = -3)
        rotate <40,0,0>
      #end
      translate <0,-5-(clock-360),0>
    #end
    #if (clock-360 >= -1 & clock-360 <= 1)
      translate <0,-4,0>
    #end
    #if (clock-360 >= 2 & clock-360 <= 4)
      #if (clock-360 = 2 | clock-360 = 4)
        rotate <-20,0,0>
      #end
      #if (clock-360 = 3)
        rotate <-40,0,0>
      #end
      translate <0,clock-360-5,0>
    #end
    //Second drop
    #if (clock-360 >= 11 & clock-360 <= 13)
      #if (clock-360 = 11 | clock-360 = 13)
        rotate <20,0,0>
      #end
      #if (clock-360 = 12)
        rotate <40,0,0>
      #end
      translate <0,5-(clock-360)/2,0>
    #end
    #if (clock-360 >= 14 & clock-360 <= 16)
      translate <0,-2,0>
    #end
    #if (clock-360 >= 17 & clock-360 <= 19)
      #if (clock-360 = 17 | clock-360 = 19)
        rotate <-20,0,0>
      #end
      #if (clock-360 = 18)
        rotate <-40,0,0>
      #end
      translate <0,(clock-360)/2-10,0>
    #end
    //Position
    translate <10,0,clock-360> 
    }
  union { RobotMacro(8) translate <350-clock,-2,0> }
  union { RobotMacro(6) translate <402-clock,0,8> }
  union { RobotMacro(10) translate <404-clock,0,-6> }
#end

//AIR
#declare loopnum = 0;
#while (loopnum <= 400)
  #declare newx = 200*(.5-rand(rseed))+clock*(.5-rand(rseed));
  #declare newy = 200*(.5-rand(rseed))+clock*(.5-rand(rseed));
  #declare newz = 200*(.5-rand(rseed))+clock*(.5-rand(rseed));
  #if (newy < 0.5)
    #declare newy = 2*0.5-newy;
  #end
  sphere { <newx, newy, newz>, .75
    pigment { rgb <.4,.6,.8> }
    finish { specular .1 roughness .5 }
    hollow
    }
  #declare loopnum = loopnum + 1;
#end

//DESKTOP UPCLOSE
#declare xoff = 0;
#declare zoff = 0;
#declare howwide = 75-1;
#declare howtall = 3-1;
#declare howdeep = 50-1;
#if (clock < 65 | (clock >= 180 & clock < 290))
  #declare howwide = 0;
  #declare howdeep = 0;
#end 
#if (clock >= 315)
  #declare howtall = 7-1;
#end
union {
  #declare ypos = 0;
  #while (ypos >= -howtall)
    #declare xoff = mod(xoff + 1,2);
    #declare zoff = mod(zoff + 1,2);
    #declare zpos = -howdeep/2;
    #while (zpos <= howdeep/2)
      #if (ypos >= -2 | (zpos > howdeep/2+cz-6 & zpos < howdeep/2+cz+21)) // attempt to speed up parsing
      #declare xpos = -howwide;
      #while (xpos <= howwide/2)
        #declare newx = xpos + xoff/2 + rdeg * sin( radians(rspin*clock + 360*rand(rseed)));
        #declare newy = ypos + rdeg * sin( radians(rspin*clock + 360*rand(rseed)));
        #declare newz = zpos + zoff/2 + rdeg * sin( radians(rspin*clock + 360*rand(rseed)));
        #declare theta = radians(rand(rseed)*360);
        #declare gamma = radians(rand(rseed)*360);
        //First left-right
        #if (ypos < -1 | ypos > 1 | zpos < howdeep/2+cz-4 | zpos > howdeep/2+cz+4 | xpos < -(clock-135)*robspeed)
          //Second left-right
          #if (clock < 315 | ypos < -1 | ypos > 1 | zpos > howdeep/2+cz+17 | zpos < howdeep/2+cz+13 | xpos < 0 | xpos > clock-315)
          #if (clock < 315 | ypos < -1 | ypos > 1 | zpos > howdeep/2+cz+19 | zpos < howdeep/2+cz+11 | xpos < 2 | xpos > clock-315)
          //Third left-right deep
          #if (clock < 315 | ypos < -3 | ypos > 1 | zpos < howdeep/2+cz-4 | zpos > howdeep/2+cz+4 | xpos < 350-clock) 
          //Fourth front-back
          #if (clock < 315 | ypos < -1 | ypos > 1 | zpos > howdeep/2+cz+clock-360 | xpos < 6 | xpos > 14)
          #if (clock < 315 | ypos < -5 | ypos > 1 | zpos > howdeep/2+cz+clock-360 | xpos < 6 | xpos > 14 | zpos > howdeep/2+cz+4 | zpos < howdeep/2+cz-4)
          #if (clock < 315 | ypos < -3 | ypos > 1 | zpos > howdeep/2+cz+clock-360 | xpos < 6 | xpos > 14 | zpos > howdeep/2+cz+19 | zpos < howdeep/2+cz+11)
            sphere { <newx, newy, newz>, 0.75 }
          #end
          #end
          #end
          #end
          #end
          #end
        #end
        #declare xpos = xpos + 1;
      #end
      #end // end speedup
      #declare zpos = zpos + 1;
    #end
    #declare ypos = ypos - 1;
  #end
  pigment { rgb <.5,.3,.1> }
  finish { specular .1 roughness .5 }
  translate <0, 0, howdeep/2+cz>
}

//LIGHTS
light_source {
  <cx, cy, cz>
  color White
}
 
light_source {
  <100, 100, 100>
  color White
  spotlight
  radius 30
  falloff 36
  tightness 10
  area_light <1, 0, 0>, <0, 0, 1>, 2, 2
  adaptive 1
  jitter
  point_at <0, 0, 0>
}
#end 
//End atomic scale


//*********************************************************


//Begin human scale
#if (clock >= 385 & clock < 700)

#if (clock>=385 & clock < 475)
camera {
  #declare cx = -2.75;
  #declare cy = 0.25;
  #declare cz = -3;
  #declare ly = 0.25;
  #declare lz = 7;
  #declare lx = cx;
  location <cx,cy,cz>
  look_at <lx,ly,lz>
}
#end

#if (clock >= 475)
camera {
  location <0,0,0>
  look_at <0,0,1>
  #if (clock < 655)
    rotate <(clock-475)/4,(clock-475)/12,0>
    #declare cx = -2.75*(505-clock)/(505-475);
    #declare cy = -(11.75/8100)*pow(clock-565,2) - (8/180)*(clock-565) + 8;
    #declare cz = (13.5/8100)*pow(clock-565,2) + (3/180)*(clock-565) - 15;
    translate <cx,cy,cz>
  #else
    rotate <(655-475)/4,(clock-475)/12,0>
    translate <13.75,-7.75-(clock-655)*0.0025,(clock-655)*0.0025>
  #end
}
#end

//Monitor
#declare monitor_black = 
texture {
  pigment { rgb <0.3,0.3,0.3> }
  finish {
    specular 0.1
    roughness 0.001
  }
}
//Monitor Front
difference {
  box { <0,0,0>,<1,1,1> 
    texture { monitor_black }
    scale <12.24,9.68,2>
    translate <-12.24/2,-9.68/2,0>
  }
  box { <0,0,0>,<1,1,1> 
    texture { monitor_black }
    scale <10.24,7.68,2> 
    translate <-10.24/2,-7.68/2,-0.5>
  }
}
//Monitor Back
box { <0,0,0>,<1,1,1>
  texture { monitor_black }
  scale <10.24,7.68,10>
  translate <-10.24/2,-7.68/2,2>
}
//Monitor Base
difference {
  sphere { <0,-1,5>,5 texture { monitor_black } }
  box { <-10,-4,-10>,<10,4,10> }
  }
cylinder { <0,-7,5>,<0,-6.5,5>, 4 texture { monitor_black } }

//Screen
#if (clock < 685)
box { <0,0,0>,<1,1,1> 
  pigment { image_map { sys "cnn_homepage_best.bmp" } }
  finish { ambient 1.0 diffuse 0.0 }
  scale <10.24,7.68,1>
  translate <-10.24/2,-7.68/2,0.5>
}
#end
#declare monitor_glass = 
texture {
  pigment { rgbf <1.0, 1.0, 1.0, 0.95> }
  finish {
    specular 0.1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1
    ior 1.5
  }
}
intersection {
  difference {
    sphere { <0,0,500>, 500 texture { monitor_glass } }
    sphere { <0,0,500>, 499.99 texture { monitor_glass } } 
  }
  box { <0,0,0>,<1,1,1> 
    scale <10.24,7.68,1> 
    translate <-10.24/2,-7.68/2,0> 
  }
}

//Walls
box { <-75,-50,21>,<75,50,22>
  texture {
    pigment { 
      agate scale 0.1
      color_map {
        [0.0  rgb <0.7, 0.6, 0.6>]
        [0.3  rgb <0.8, 0.7, 0.7>]
        [1.0  rgb <0.8, 0.7, 0.7>]
      }
      scale 10
    }
    normal { bumps 0.5 scale 0.05 }
  }
}

//Desk
box { <-75,-10,-20>,<75,-8,20>
  texture { T_Wood1 scale <5,1,2> rotate <0,90,0> }
}

//Keyboard/Mouse Cable
#declare rseed = seed(0);
#macro CableMacro (depth)
  #if (depth < 40)
    union {
      cylinder { <0,0,0>,<0,0,1>,0.1 }
      CableMacro (depth+1)
      #if (depth < 10)
        rotate <0,4,0>
      #end
      #if (depth < 20 & depth > 10)
        rotate <0,-4,0>
      #end
      #if (depth < 30 & depth > 20)
        rotate <0,4,0>
      #end
      #if (depth < 40 & depth > 30)
        rotate <0,-4,0>
      #end
      translate <0,0,1>
    }
  #end
#end
union {
  CableMacro(0)
  pigment { rgb <0.25,0.25,0.25> }
  translate <0,-7.95,-17.5>
}

//Pictures on Wall
box { <0,0,0>,<1,1,1>
  pigment { image_map { sys "jack.bmp" } }
  finish { ambient 0.2 diffuse 0.8 } 
  scale <12,6.72,0.1>
  translate <12,8,19.9>
}
box { <0,0,0>,<1,1,1>
  pigment { image_map { sys "ollie.bmp" } }
  //finish { ambient 0.01 diffuse 0.99 } 
  scale <12,6.72,0.1>
  translate <12,0,19.9>
}
//Push Pins
cylinder { <0,0,0>,<0,0,1>,0.4
  pigment { rgb <0,0.2,0.8> }
  translate <18,14,19>
}
cylinder { <0,0,0>,<0,0,1>,0.4
  pigment { rgb <0,0.2,0.8> }
  translate <18,6,19>
}

//Robots consuming desk
intersection {
  blob {
    threshold 0.5
    #declare howmany = 0;
    #while (howmany < 2000)
      #if (clock < 655)
        sphere { <15.25+0.3*(655-clock)*rand(rseed)+30*rand(rseed),-8,40*(rand(rseed)-0.5)>,2,1 }
      #else
        sphere { <15.25+0*rand(rseed)+30*rand(rseed),-8,40*(rand(rseed)-0.5)>,2,1 }
      #end
      #declare howmany = howmany + 1;
    #end
  }
  box { <-50,-10,20>,<50,-7.99,-20> }
  pigment { rgb <0.5,0.5,0.5> }
  finish { specular .1 roughness .5 }
}

#if (clock >= 655)
//Molecular Robots
#declare numrows = 0;
#while (numrows < 10)
  #declare numcols = 0;
  #while (numcols < 7)
    union { RobotMacro(5+int(rand(rseed)*5)) scale 0.01 translate <14+numrows*0.1-(clock-655)*0.01-pow(7-numcols,3)*0.0004,-8,0.6-numcols*0.1> }
    #declare numcols = numcols + 1;
  #end
  #declare numrows = numrows + 1;
#end

//Molecular Desk
#declare zpos = 0;
#while (zpos < 0.8)
  #declare xpos = 13.5;
  #while (xpos < 14.3)
    #declare ypos = -8;
    #declare newx = xpos + 0.002 * sin( radians(rspin*clock + 360*rand(rseed)));
    #declare newy = ypos + 0.002 * sin( radians(rspin*clock + 360*rand(rseed)));
    #declare newz = zpos + 0.002 * sin( radians(rspin*clock + 360*rand(rseed)));
    sphere { <newx, newy, newz>,0.0075
      texture { T_Wood1 scale <5,1,2> rotate <0,90,0> }
      /*pigment { rgb <.5,.3,.1> }
      finish { specular .1 roughness .5 }*/
    }
    #declare xpos = xpos + 0.01;
  #end
  #declare zpos = zpos + 0.01;
#end
#end

light_source {
  <0, 20, -100>
  color White
}   

light_source {
  <0, 50, -10>
  color White
  spotlight
  radius 30
  falloff 36
  tightness 10
  area_light <1, 0, 0>, <0, 0, 1>, 2, 2
  adaptive 1
  jitter
  point_at <0, 0, 0>
}      

#end
//End human scale


//*********************************************************

#if (clock >= 700)

camera {
  location <0,0,-10>
  look_at <0,0,0>
}

light_source {
  <0, 0, -10>
  color White
}   

// Title Shot
/*
text { ttf "timrom.ttf" "Erik's NanoBots" 0.03, 0 pigment { rgb <1*fade,1*fade,1*fade> } translate <-3.4,1.5,-4> }
union { RobotMacro(10) scale 0.4 translate <0,-2.75,0> }
text { ttf "timrom.ttf" "by Erik Shelley" 0.03, 0 scale 0.4 pigment { White } finish { ambient 0.3 } translate <1,-2.45,-4> }
//text { ttf "timrom.ttf" "( Jan 2000 )" 0.03, 0 scale 0.3 pigment { White } finish { ambient 0.4 } translate <1,-2.85,-4> }
*/
// Credits

#declare scroll = 0.09;
#if (clock < 700+50)
text { ttf "timrom.ttf" "Erik's NanoBots" 0.01, 0 pigment { rgb <1*fade,1*fade,1*fade> } translate <-3.4,0,-4> }
#else
text { ttf "timrom.ttf" "Erik's NanoBots" 0.01, 0 pigment { White } translate <-3.4,scroll*(clock-750),-4> }
text { ttf "timrom.ttf" "Created in Pov-Ray 3.1" 0.01, 0 scale 0.5 pigment { White } translate <-2.5,scroll*(clock-750)-4,-4> }
text { ttf "timrom.ttf" "by Erik Shelley" 0.01, 0 scale 0.5 pigment { White } translate <-1.8,scroll*(clock-750)-5,-4> }
text { ttf "timrom.ttf" "with input from Melissa" 0.01, 0 scale 0.5 pigment { White } translate <-2.5,scroll*(clock-750)-6,-4> }
text { ttf "timrom.ttf" "Starring:" 0.01, 0 scale 0.5 pigment { White } translate <-3.4,scroll*(clock-750)-8,-4> }
text { ttf "timrom.ttf" "Cat in top picture: Jack" 0.01, 0 scale 0.5 pigment { White } translate <-2.5,scroll*(clock-750)-9.5,-4> }
text { ttf "timrom.ttf" "Cat in bottom picture: Oliver" 0.01, 0 scale 0.5 pigment { White } translate <-2.5,scroll*(clock-750)-10.25,-4> }
#end

#end