/* This File Should be compiled in to a dll called h_foct.dll */
/* The dll can then be used with POVRay that has Suzuki's IsoSurface Patch */

#include <math.h>
#define DLL

#include "isofunc.h"

#define xt XYZ[X]
#define yt XYZ[Y]
#define zt XYZ[Z]

double R_int(const double f1, const double f2){
	return (double)(f1+f2-sqrt(f1*f1+f2*f2));
	}

double R_uni(const double f1, const double f2){
	return (double)(f1+f2+sqrt(f1*f1+f2*f2));
	}

double sq(const double xx){
	return xx*xx;
	}

double dFOct(const double px, const double py, const double pz){
	double head,hana,xface1,xface2,atama1,xkuti1,xkuti2,xkuti;
	double eye1,eye2,eye3,eye4,eye5,eye6,eye7,eye8,eye9;
	double atama2,atama3,atama4,atama5,atama;
	double body1,body2,body3,body4,body5,body6,body7,body;
	double cubiwa,suzu,hara1,hara2,hara3,hara4,hara5,hara6,hara7,hara8,hara9;
	double xlleg,xrleg,xlfoot,xrfoot,xlashi,xrashi,ashi;
	double rhige1,rhige2,rhige3,xlhige1,xlhige2,xlhige3;
	double rhani,rhige4,rhige5,rhige6,rhige;
	double xlhani,xlhige4,xlhige5,xlhige6,xlhige,hige;
	double fs1,fs2,hand1,hand2,ude1,ude2,ude3,ude4,ude5;
	double te1,te2,fs3,xx,yy,zz;

	xx=10.*px;
	yy=10.*py;
	zz=10.*pz;

	head=1-sq(xx/6.)-sq((yy-4.5)/5.5)-sq(zz/6.);

	hana=1-sq(xx/0.8)-sq((yy-6.5)/0.8)-sq((zz-5.9)/0.8);

	xface1=1-sq(xx/6.)-sq((yy-4.5)/5.5)-sq((zz-0.3)/6.);
	xface2=1-sq(xx/4.7)-sq((yy-3.7)/4.5);

	xkuti1=1.-sq(xx/4)-sq((yy-4.5)/4)-sq((zz-6)/4);
	xkuti2=4.5-yy;
	xkuti=R_int(xkuti1,xkuti2);

	eye1=1.-sq(xx/6.)-sq((yy-4.5)/5.5)-sq((zz-0.4)/6);
	eye2=1.-sq((xx-1.5)/1.5)-sq((yy-7.5)/1.4);
	eye3=R_int(eye1,eye2);
	eye4=1.-sq((xx+1.5)/1.5)-sq((yy-7.5)/1.4);
	eye5=R_int(eye1,eye4);
	eye6=1.-sq((xx-0.3)/0.3)-sq((yy-7.5)/0.3)-sq((zz-5.5)/0.3);
	eye7=R_int(eye3,-eye6);
	eye8=1.-sq((xx+0.3)/0.3)-sq((yy-7.5)/0.3)-sq((zz-5.5)/0.3);
	eye9=R_int(eye5,-eye8);

	atama1=R_int(xface1,xface2);
	atama2=R_uni(atama1,head);
	atama3=R_uni(eye7,atama2);
	atama4=R_uni(eye9,atama3);
	atama5=R_uni(atama4,hana);
	atama=R_int(atama5,-xkuti);

	body1=1.-sq(xx/4.5)-sq((yy+2)/6.0)-sq(zz/4.5);
	body2=6.+yy;
	body3=1.-yy;
	body4=R_int(body3,body2);
	body5=R_int(body1,body4);
	cubiwa=0.25-sq(xx)-sq(yy)-sq(zz)-16.+8.*sqrt(sq(xx)+sq(zz));
	suzu=0.64-sq(xx)-sq(yy)-sq(zz-4.5);
	body6=R_uni(body5,cubiwa);
	hara1=1.-sq(xx/4.5)-sq((yy+2)/6.0)-sq((zz-0.3)/4.5);
	hara2=1.-sq(xx/2.3)-sq((yy+3)/2.3);
	hara3=R_int(hara1,hara2);
	hara4=1.-sq(xx/1.6)-sq((yy+3)/1.6);
	hara5=1.-sq(xx/4.5)-sq((yy+2)/6.0)-sq((zz-0.6)/4.5);
	hara6=-3-yy;
	hara7=R_int(hara4,hara6);
	hara8=R_int(hara7,hara5);
	hara9=R_uni(hara8,hara3);
	body7=R_uni(body6,hara9);
	body=R_uni(body7,suzu);

	xlleg=1.-sq((xx-3)/3.0)-sq((yy+7.5)/1.5)-sq(zz/4.0);
	xrleg=1.-sq((xx+3)/3.0)-sq((yy+7.5)/1.5)-sq(zz/4.0);
	xlfoot=1.-sq((xx-2)/1.0)-sq((yy+6)/1.0)-sq(zz/2.0);
	xrfoot=1.-sq((xx+2)/1.0)-sq((yy+6)/1.0)-sq(zz/2.0);
	xlashi=R_uni(xlleg,xlfoot);
	xrashi=R_uni(xrleg,xrfoot);
	ashi=R_uni(xlashi,xrashi);

	rhani=R_int(xx-0,7-xx);
	rhige1=0.04-sq(zz-4.5)-sq(xx-2)-sq(yy+3)-100.+20.*sqrt(sq(xx-2)+sq(yy+3));
	rhige2=0.04-sq(zz-4.5)-sq(xx-2)-sq(yy+3.5)-100.+20.*sqrt(sq(xx-2)+sq(yy+3.5));
	rhige3=0.04-sq(zz-4.5)-sq(xx-2)-sq(yy+4.)-100.+20.*sqrt(sq(xx-2)+sq(yy+4.));
	rhige4=R_uni(rhige1,rhige2);
	rhige5=R_uni(rhige3,rhige4);
	rhige6=R_int(rhige5,rhani);
	rhige=R_int(rhige6,yy-0.);

	xlhani=R_int(xx+7,0-xx);
	xlhige1=0.04-sq(zz-4.5)-sq(xx+2)-sq(yy+3)-100.+20.*sqrt(sq(xx+2)+sq(yy+3));
	xlhige2=0.04-sq(zz-4.5)-sq(xx+2)-sq(yy+3.5)-100.+20.*sqrt(sq(xx+2)+sq(yy+3.5));
	xlhige3=0.04-sq(zz-4.5)-sq(xx+2)-sq(yy+4.)-100.+20.*sqrt(sq(xx+2)+sq(yy+4.));
	xlhige4=R_uni(xlhige1,xlhige2);
	xlhige5=R_uni(xlhige3,xlhige4);
	xlhige6=R_int(xlhige5,xlhani);
	xlhige=R_int(xlhige6,yy-0);
	hige=R_uni(xlhige,rhige);

	fs1=R_uni(atama,body);
	fs2=R_uni(fs1,ashi);

	hand1=2.-sq(xx-8)-sq(yy+2.5)-sq(zz);
	hand2=2.-sq(xx+8)-sq(yy+2.5)-sq(zz);

	ude1=1-sq(zz)-sq(xx)-sq(yy+21)-400.+40.*sqrt(sq(xx)+sq(yy+21));
	ude2=xx+8;
	ude3=8-xx;
	ude4=R_int(ude1,ude3);
	ude5=R_int(ude4,ude2);

	te1=R_uni(ude5,hand1);
	te2=R_uni(te1,hand2);

	fs3=R_uni(fs2,te2);

	return R_uni(fs3,hige);
	}

double dRobot(const double px, const double py, const double pz){
	double fobj2,f1,f2,f3,f4,f5,f6,f7,f8,f9,f10, xx, yy, zz;
	double fa,fb,fc,fd,fe,ff,fg,fh,fi,fj,fk,fl,fm,fn,fo,fp,fx,fy,fz;

    xx=8.*px;
    yy=8.*py;
    zz=8.*pz;
/*  robot figure */
/* body */
	f1=-xx+3;
	f2=xx+3;
	fx=R_int(f1,f2);
	f3=-yy+2;
	f4=yy+4;
	fy=R_int(f3,f4);
	f5=zz+3;
	f6=-zz+3;
	fz=R_int(f5,f6);
	fa=R_int(fx,fy);
	fa=R_int(fa,fz);
	f1=-yy-2*zz+8;
	f2=yy-2*zz+8;
	f3=-xx+3;
	f4=xx+3;
	f5=zz-3;
	f6=R_int(f1,f2);
	f7=R_int(f3,f4);
	fb=R_int(f6,f7);
	fb=R_int(fb,f5); 
/* head */
	f1=-xx+3;
	f2=xx+3;
	f3=-yy+6;
	f4=yy-2.2;
	f5=zz+3;
	f6=-zz+3;
	fx=R_int(f1,f2);
	fy=R_int(f3,f4);
	fz=R_int(f5,f6);
	fc=R_int(fx,fy);
	fc=R_int(fc,fz);  
/*  ear  */
	f1=xx-3;  
	f2=-xx+3.9;
	f3=-yy+5;
	f4=yy-3.3;
	f5=zz+0.9;
	f6=-zz+0.9;
	fx=R_int(f1,f2);
	fy=R_int(f3,f4);
	fz=R_int(f5,f6);
	fd=R_int(fx,fy);
	fd=R_int(fd,fz); 
	f1=xx+3.9;
	f2=-xx-3;
	f3=-yy+5;
	f4=yy-3.3;
	f5=zz+0.9;
	f6=-zz+0.9;
	fx=R_int(f1,f2);
	fy=R_int(f3,f4);
	fz=R_int(f5,f6);
	fe=R_int(fx,fy);
	fe=R_int(fe,fz);  
/*  eye  */
	f1=1-(xx-1.1)*(xx-1.1)-(yy-4.2)*(yy-4.2);  
	f2=zz-3;
	f3=-zz+3.5;
	ff=R_int(f1,f2);
	ff=R_int(ff,f3);
	f1=1-(xx+1.1)*(xx+1.1)-(yy-4.2)*(yy-4.2);
	f2=zz-3;
	f3=-zz+3.5;
	fg=R_int(f1,f2);
	fg=R_int(fg,f3);  
/*  sholder */
	f1=xx-3;       
	f2=-xx+5.5;
	f3=yy;
	f4=-yy+2;
	f5=zz+1;
	f6=-zz+1;
	f7=xx+5.5;
	f8=-xx-3;
	fx=R_int(f1,f2);
	f9=R_int(f7,f8);
	fy=R_int(f3,f4);
	fz=R_int(f5,f6);
	fh=R_int(fx,fy);
	fh=R_int(fh,fz);
	fi=R_int(f9,fy);
	fi=R_int(fi,fz);  
/*  arm  */
	f1=1-(xx-4.2)*(xx-4.2)-zz*zz;      
	f2=1-(xx+4.2)*(xx+4.2)-zz*zz;
	f3=-yy; 
	f4=yy+3;
	f5=R_int(f3,f4);
	fj=R_uni(f1,f2);
	fj=R_int(fj,f5); 
/* mouse */
	f1=-xx+0.5;  
	f2=xx+0.5;
	f3=yy-2.3;
	f4=-yy+3.1;
	f5=zz-2;
	f6=R_int(f1,f2);
	f7=R_int(f3,f4);
	fk=R_int(f6,f7);
	fk=R_int(fk,f5); 
/* hand */
	f1=0.25-(xx-4.2)*(xx-4.2)-(yy+4.5)*(yy+4.5)-zz*zz-1+2*sqrt((yy+4.5)*(yy+4.5)+zz*zz);
	f2=0.25-(xx+4.2)*(xx+4.2)-(yy+4.5)*(yy+4.5)-zz*zz-1+2*sqrt((yy+4.5)*(yy+4.5)+zz*zz);
	fl=R_uni(f1,f2); 
	/* foot */
	f1=xx-0.6;
	f2=-xx+2.6;
	f3=-xx-0.6;
	f4=xx+2.6;
	f5=yy+7;
	f6=-yy-4;
	f7=-zz+1.5;
	f8=zz+1.5;
	f9=R_int(f1,f2);
	f10=R_int(f3,f4);
	fy=R_int(f5,f6);
	fz=R_int(f7,f8);
	fm=R_uni(f9,f10);
	fm=R_int(fm,fy);
	fm=R_int(fm,fz);  
/* hand  */
	f1=xx-3.7;
	f2=-xx+4.7;
	f3=-xx-3.7;
	f4=xx+4.7;
	f5=-yy-4.5;
	f6=yy+6;
	f7=zz+0.4;
	f8=-zz+0.4;
	f9=R_int(f1,f2);
	f10=R_int(f3,f4);
	fy=R_int(f5,f6);
	fz=R_int(f7,f8);
	fn=R_uni(f9,f10);
	fn=R_int(fn,fy);
	fn=R_int(fn,fz);  
/* foot */
	f1=1-((xx-1.6)*(xx-1.6)/(1.2*1.2))-((yy+8)*(yy+8)/(1.5*1.5))-((zz*zz)/(4*4));
	f2=1-((xx+1.6)*(xx+1.6)/(1.2*1.2))-((yy+8)*(yy+8)/(1.5*1.5))-((zz*zz)/(4*4));
	f3=yy+8;
	fo=R_uni(f1,f2);
	fo=R_int(fo,f3); 

	fp=1-xx*xx-(yy-6)*(yy-6)-zz*zz;

	fobj2=R_uni(fa,fb);
	fobj2=R_uni(fobj2,fc);
	fobj2=R_uni(fobj2,fd);
	fobj2=R_uni(fobj2,fe);
	fobj2=R_uni(fobj2,ff);
	fobj2=R_uni(fobj2,fg);
	fobj2=R_uni(fobj2,fh);
	fobj2=R_uni(fobj2,fi);
	fobj2=R_uni(fobj2,fj);
	fobj2=R_int(fobj2,-fk);
	fobj2=R_uni(fobj2,fl);
	fobj2=R_uni(fobj2,fm);
	fobj2=R_int(fobj2,-fn);
	fobj2=R_uni(fobj2,fo);
    
	return R_uni(fobj2,fp);
	}

double dRob_let(const double px, const double py, const double pz){
	double fobj1,f1,f2,f3,f10,f11,f12,f13,f14,f15,f16,f17,f18;
	double fa,fb,fc,fd,fe,ff,fg,fh,fi,fj,fk,fl,fm,fn,fo,fp,fq,fz;
	double fk4,fk1,fl4,fl1,fm4,fm1,fn4,fn1,fo4,fo1,fp16,fp9,xx,yy,zz;

	xx=px*10;
	yy=py*8.;
	zz=pz*8.;
/* robot  */
	f1=zz+3;
	f2=3-zz;
	fz=R_int(f1,f2);
	f1=xx+10;
	f2=-9-xx;
	fa=R_int(f1,f2);
	f1=xx+5;
	f2=-4-xx;
	fb=R_int(f1,f2);
	f1=xx+2;
	f2=-1-xx;
	fc=R_int(f1,f2);
	f1=xx;
	f2=1-xx;
	fd=R_int(f1,f2);
	f1=xx-5;
	f2=6-xx;
	fe=R_int(f1,f2);
	f1=xx-8;
	f2=9-xx;
	ff=R_int(f1,f2);
	f1=xx-12;
	f2=13-xx;
	fg=R_int(f1,f2);
	f1=xx-10;
	f2=15-xx;
	fh=R_int(f1,f2);
	f1=2-yy;
	f2=yy-1;
	fi=R_int(f1,f2);
	f1=yy-5;
	f2=1-yy;
	f18=R_int(fi,fh); 
	f1=1-yy;
	f2=yy+1; 
	fj=R_int(f1,f2);
	f1=-yy+3;
	f2=yy+3;
	fq=R_int(f1,f2);
	f10=R_uni(fa,fd); f10=R_uni(f10,fg); 

	f11=R_uni(fb,fc); f12=R_uni(fe,ff); 
	f13=R_uni(f11,f12);
	f13=R_int(f13,fj);   

	fk4=4-(xx+3)*(xx+3)-(yy-1)*(yy-1);
	fk1=1-(xx+3)*(xx+3)-(yy-1)*(yy-1);
	fk=R_int(fk4,-fk1);
	fl4=4-(xx+3)*(xx+3)-(yy+1)*(yy+1);
	fl1=1-(xx+3)*(xx+3)-(yy+1)*(yy+1);
	fl=R_int(fl4,-fl1);
	fm4=4-(xx-2)*(xx-2)-(yy+1)*(yy+1);
	fm1=1-(xx-2)*(xx-2)-(yy+1)*(yy+1);
	fm=R_int(fm4,-fm1);
	fn4=4-(xx-7)*(xx-7)-(yy+1)*(yy+1);
	fn1=1-(xx-7)*(xx-7)-(yy+1)*(yy+1);
	fn=R_int(fn4,-fn1);
	fo4=4-(xx-7)*(xx-7)-(yy-1)*(yy-1);
	fo1=1-(xx-7)*(xx-7)-(yy-1)*(yy-1);
	fo=R_int(fo4,-fo1);
	fp16=16-(xx+6)*(xx+6)-(yy+1)*(yy+1);
	fp9=9-(xx+6)*(xx+6)-(yy+1)*(yy+1);
	fp=R_int(fp16,-fp9);
	f1=-6-xx;
	f2=yy+1;
	f3=R_int(f1,f2);
	fp=R_int(fp,f3);
	f17=R_uni(fp,fm);  
	f14=R_uni(fk,fl); f15=R_uni(fn,fo);
	f16=R_uni(f14,f15);
	f16=R_int(f16,-fj); 
 
	fobj1=R_int(f10,fq);
	fobj1=R_uni(fobj1,f13);
	fobj1=R_uni(fobj1,f16);
	fobj1=R_uni(fobj1,f17);
	fobj1=R_uni(fobj1,f18);
  
	return R_int(fobj1,fz);
	}

double Block(const double xx,const double yy,const double zz, const double *vertex, const double w, const double h, const double l){
	double sx, sy, sz, block;

	sx = R_int((xx-vertex[0]),(vertex[0]+w-xx));
	sy = R_int((yy-vertex[1]),(vertex[1]+h-yy));
	sz = R_int((zz-vertex[2]),(vertex[2]+l-zz));
	block = R_int(sx,sy);
	return R_int(block, sz);
	}

double Rotate3DZ(double *xp, const double theta){
	xp[0]=xp[0]*cos(theta) + xp[1]*sin(theta);
	xp[1]=-xp[0]*sin(theta) + xp[1]*cos(theta);

	return 1.;
	}


double dNihon(const double px, const double py, const double pz){
	double length, lnf, lnc, height, htd, htu, width, wdl, wdr, step, w2, h2;
	double block1, block2, block3, block4, block5, Ni, Hon, xx, yy, zz, tmp;
	double vertex[3], xp[3];

	xx = px*5.5;
	yy = py*5.;
	zz = pz*5.5;
/* kanji Ni*/
//	tmp = xx;
//	xx = zz;
//	zz = tmp;
	length = 8.;
	lnf = -length/2;
	lnc = -lnf;
	height = 8.;
	htd = -height/2;
	htu = -htd;
	width = 8.;
	wdl = -width/2;
	wdr = -wdl;
	step = 2.;
	/*center block*/
	vertex[0] = wdl;
	vertex[1] = htd;
	vertex[2] = lnf;
	block1 = Block(xx,yy,zz,vertex,width,height,length); 
	/*upper hole*/
	vertex[0] = wdl+step;
	vertex[1] = step/2;
	vertex[2] = lnf-step;
	w2 = width-2*step;
	h2 = htu-step;
	block2 = Block(xx,yy,zz,vertex,w2,h2,length+2*step);
	/*lower hole*/
	vertex[0] = wdl+step;
	vertex[1] = htd + step/2;
	vertex[2] = lnf-step;
	w2 = width-2*step;
	h2 = htu-step;
	block3 = Block(xx,yy,zz,vertex,w2,h2,length+2*step);
	Ni = R_int(block1,-block2);
	Ni = R_int(Ni, -block3);
/* kanji Hon */
	/* rotate -90 around y-axis */
	tmp = xx;
	xx = zz;
	zz = tmp;

	vertex[0] = -step/2;
	vertex[1] = htd;
	vertex[2] = lnf;
	block1 = Block(xx,yy,zz,vertex,step,height,length); 
	/* lower */
	vertex[0] = -step;
	vertex[1] = htd+step/2;
	vertex[2] = lnf;
	block2 = Block(xx,yy,zz,vertex,2*step,step/2,length); 
	/* upper */
	vertex[0] = wdl;
	vertex[1] = htu-1.5*step;
	vertex[2] = lnf;
	block3 = Block(xx,yy,zz,vertex,width,step/2,length); 
	/* right */ 
	xp[0] = xx;
	xp[1] = yy - (htu-step);
	xp[2] = zz;
	tmp = Rotate3DZ(xp,3.14/4);
	vertex[0] = -step/4;
	vertex[1] = htd-step;
	block4 = Block(xp[0],xp[1],xp[2],vertex,step/2,htu+step,length);
	/* left */
	xp[0] = xx; 
	xp[1] = yy - (htu-step); 
	xp[2] = zz;
	tmp = Rotate3DZ(xp,-3.14/4);
	vertex[0] = -step/4;
	vertex[1] = htd-step;
	block5 = Block(xp[0],xp[1],xp[2],vertex,step/2,htu+step,length);
	Hon = R_uni(block1, block2);
	Hon = R_uni(Hon, block3);
	Hon = R_uni(Hon, block4);
	Hon = R_uni(Hon, block5);

	return R_int(Ni, Hon);
	}

double Meta4(const double xx, const double yy, const double zz, const double t1, const double t2){
	double Cat, Nihon, Robot, Rob_let;

/* (0,0): Cat */
	Cat = dFOct(xx,yy,zz)/2.;

/* (0,1): Nihon */
	Nihon = dNihon(xx,yy,zz);

/* (1,0): Robot */
	Robot = dRobot(xx,yy,zz);

/* (1,1): Rob_let */
	Rob_let = dRob_let(xx,yy,zz)/8.;

/* bilinear metamorphosis */
	return (Cat*(1.-t1)+Robot*t1)*(1.-t2)+(Nihon*(1.-t1)+Rob_let*t1)*t2;
	}

//**********Note  C:Cat N:Nihon R:Robot L:Robot Letters**********

double Meta2CR(const double xx, const double yy, const double zz, const double t1){
	double Cat, Robot;

	if(t1==0.0) return dFOct(xx,yy,zz)/2.;
	if(t1==1.0) return dRobot(xx,yy,zz);

/* (0,0): Cat */
	Cat = dFOct(xx,yy,zz)/2.;

/* (1,0): Robot */
	Robot = dRobot(xx,yy,zz);



/* linear metamorphosis */
	return Cat*(1.-t1)+Robot*t1;
	}

double Meta2RL(const double xx, const double yy, const double zz, const double t1){
	double Robot, Rob_let;

	if(t1==0.0) return dRobot(xx,yy,zz);
	if(t1==1.0) return dRob_let(xx,yy,zz)/8.;
/* (1,0): Robot */
	Robot = dRobot(xx,yy,zz);

/* (1,1): Rob_let */
	Rob_let = dRob_let(xx,yy,zz)/8.;

/* linear metamorphosis */
	return Robot*(1.-t1)+Rob_let*t1;
	}

double Meta2NL(const double xx, const double yy, const double zz, const double t1){
	double Nihon, Rob_let;

	if(t1==0.0) return dNihon(xx,yy,zz);
	if(t1==1.0) return dRob_let(xx,yy,zz)/8.;

/* (0,1): Nihon */
	Nihon = dNihon(xx,yy,zz);

/* (1,1): Rob_let */
	Rob_let = dRob_let(xx,yy,zz)/8.;

/* linear metamorphosis */
	return Nihon*(1.-t1)+Rob_let*t1;
	}
double Meta2CN(const double xx, const double yy, const double zz, const double t1){
	double Cat, Nihon;
	
	if(t1==0.0) return dFOct(xx,yy,zz)/2.;
	if(t1==1.0) return dNihon(xx,yy,zz);

/* (0,0): Cat */
	Cat = dFOct(xx,yy,zz)/2.;

/* (0,1): Nihon */
	Nihon = dNihon(xx,yy,zz);

/* linear metamorphosis */
	return Cat*(1.-t1)+Nihon*t1;
	}
double Meta2NR(const double xx, const double yy, const double zz, const double t1){
	double Nihon, Robot;

/* (0,1): Nihon */
	Nihon = dNihon(xx,yy,zz);

/* (1,0): Robot */
	Robot = dRobot(xx,yy,zz);

/* linear metamorphosis */
	return Nihon*(1.-t1)+Robot*t1;
	}
double Meta2CL(const double xx, const double yy, const double zz, const double t1){
	double Cat, Rob_let;

/* (0,0): Cat */
	Cat = dFOct(xx,yy,zz)/2.;

/* (1,1): Rob_let */
	Rob_let = dRob_let(xx,yy,zz)/8.;

/* linear metamorphosis */
	return Cat*(1.-t1)+Rob_let*t1;
	}





//********************************************************************************************************************************
//************************************ POVRAY CAN CALL THE FOLLOWING FUNCTIONS ***************************************************
//********************************************************************************************************************************

//**********Note  C:Cat N:Nihon R:Robot L:Robot Letters**********

FUNC FMeta4(FUNCTION *Func, VECTOR XYZ){
	if(P0==0.0) return -Meta2CN(xt, yt, zt, P1);
	if(P0==1.0) return -Meta2RL(xt, yt, zt, P1);
	if(P1==0.0) return -Meta2CR(xt, yt, zt, P0);
	if(P1==1.0) return -Meta2NL(xt, yt, zt, P0);
	return -Meta4(xt, yt, zt, P0, P1);
	}

FUNC FMeta2CR(FUNCTION *Func, VECTOR XYZ){
	return -Meta2CR(xt, yt, zt, P0);
	}

FUNC FMeta2RL(FUNCTION *Func, VECTOR XYZ){
	return -Meta2RL(xt, yt, zt, P0);
	}

FUNC FMeta2NL(FUNCTION *Func, VECTOR XYZ){
	return -Meta2NL(xt, yt, zt, P0);
	}

FUNC FMeta2CN(FUNCTION *Func, VECTOR XYZ){
	return -Meta2CN(xt, yt, zt, P0);
	}

FUNC FMeta2NR(FUNCTION *Func, VECTOR XYZ){
	return -Meta2NR(xt, yt, zt, P0);
	}

FUNC FMeta2CL(FUNCTION *Func, VECTOR XYZ){
	return -Meta2CL(xt, yt, zt, P0);
	}

FUNC FOct(FUNCTION *Func, VECTOR XYZ){
	return -dFOct(xt, yt, zt);
	}

FUNC FRobot(FUNCTION *Func, VECTOR XYZ){
	return -dRobot(xt, yt, zt);
	}

FUNC FRob_let(FUNCTION *Func, VECTOR XYZ){
	return -dRob_let(xt, yt, zt);
	}

FUNC FNihon(FUNCTION *Func, VECTOR XYZ){
	return -dNihon(xt, yt, zt);
	}

