// PROYECTO:
//
// DEL CONCEPTO A LA REALIDAD VIRTUAL
//
// INICIO: 25-dic-1999
//
//
// 1 fase: Primer plano desenfocado. Pisotn de  .
//          Mientras se ve que sigue movindose, se va enfocando al pie.
//          Pocos segundos 2?
//
// 2 fase: Vista general del robot desde adelante arriba.
//
// 3 fase: Salto de las dianas.
//                                 
// 3 fase y media: si me da tiempo, 'visualizacin y anlisis de amenazas'
//
// 4 fase: Primer plano de can disparando y girando. Se sigue viendo al
//          robot moverse. Salto de las vainas del can?
// 
// 5 fase: Vista desde atrs del robot disparando, con balas trazadoras y las
//          dianas estallando una tras otra. Si da tiempo, se aade lanzamiento de cohetes.
//
//
// 6 fase: Robot en primer plano, de frente, sin fondo, y la leyenda
//          'Can Cerbero'
//          'El futuro refuerzo del Revaticano'
//

#include "colors.inc"
#include "metals.inc"

global_settings
{
   max_trace_level 50
   motion_blur 10, 0.04
}   


// #declare calidad = false;
#include "rbox.inc"
#include "robot.inc"


#declare cielo   = true;
#declare colinas = true;
#declare sol     = true;
#declare suelo   = true;
#declare niebla  = false;

#declare long_muslo       = 1.25;
#declare long_pantorrilla = 1.25;






#switch (clock)
#debug concat(str(clock,4,4),"\n")

  #range (0,2)
     
     #declare camera_location = <1,.2,-2>;
     #declare camera_look_at  = <1,.1,0>;
     camera {
        location camera_location
        look_at camera_look_at
     } 
//     cylinder{<0,-1000,0>,<0,1000,0>,2 pigment{color rgb 1} finish{ambient 1}}
     #declare i           = mod(clock,1) ;
     #declare j           = int(clock) *2 ;
     #declare alt_eje     = 2 ;
     #declare long_paso   = 2 ;
     #declare alt_max_pie = 1 ;
     #declare robot_step  = i ;
     object{robot(i,0,0,0,0) translate <clock*2 - 2,0,0>}
  #break
  #range (2,6)  
     #declare i           = mod(clock,1) ;
     #declare j           = int(clock) *2 ;
     #declare camera_location = <1+(clock-2)*2,.2 +(clock-2)/2,-2-(clock-2)/2>;
     #declare camera_look_at  = <1+(clock-2)*2.25,.1+(clock-2)/2,0>;
     camera {
        location camera_location
        look_at camera_look_at
     } 
//     cylinder{<0,-1000,0>,<0,1000,0>,2 pigment{color rgb 1} finish{ambient 1}}
     #declare alt_eje     = 2 ;
     #declare long_paso   = 2 ;
     #declare alt_max_pie = 1 ;
     #declare robot_step  = i ;
     object{robot(i,0,0,0,0) translate <clock*2 - 2,0,0>}
  #break
  
  #range (6,10)  //  
     #declare i           = mod(clock,1) ;
     #declare j           = int(clock) *2 ;
     #declare camera_location = <1+(clock-2)*2,2.2 ,-4>;
     #declare camera_look_at  = <2+(clock-2)*2,2.1,0>;
     camera {
        location camera_location
        look_at camera_look_at
     } 
//     cylinder{<0,-1000,0>,<0,1000,0>,2 pigment{color rgb 1} finish{ambient 1}}
     #declare alt_eje     = 2 ;
     #declare long_paso   = 2 ;
     #declare alt_max_pie = 1 ;
     #declare robot_step  = i ;
     object{robot(i,0,0,0,0) translate <clock*2 - 2,0,0>}
  #break

  
  
  
  #range (10,12)
     #declare camera_location = <-5+clock*2,3,-6>;
     #declare camera_look_at  = <clock*2+2, 2, 0>;
     camera {
        location camera_location
        look_at  camera_look_at
     }
     #declare i           = mod(clock,1) ;
     #declare j           = int(clock) *2 ;
     #declare alt_eje     = 2 ;
     #declare long_paso   = 2 ;
     #declare alt_max_pie = 1 ;
     #declare robot_step  = i ;
     object{robot(i,0,0,0,0) translate <clock*2 - 2,0,0>}
  #break     
  
  #range (12, 14)
     #declare i=(clock-12)/2;
     #declare camera_location = <98.5,0.5,i*7-4>;
     #declare camera_look_at  = <100,0.5,i*7-4>;
     #debug concat(str(i,4,4),"  ")
     camera{
        location camera_location
        look_at  camera_look_at
     }
     object{diana_1 rotate -90*(1-i)*z translate <100,0,-3>}
     object{diana_2 rotate -90*(1-i)*z translate <100,0,0>}
     object{diana_3 rotate -90*(1-i)*z translate <100,0,3>}
     #debug concat(str(  -89*(1-i),4,4),"\n")
  #break
  
  //Si da tiempo, pantalla de 2-3 segundos con anlisis de objetivos
  
  #range (14,18) //Primer plano can
    #declare i=mod(clock,1);
    #declare j=clock-14;
    #declare camera_location = <clock*2+1.5,1.7,.9>;
    #declare camera_look_at  = <clock*2  ,2 , 0>;
    camera{
       location camera_location
       look_at  camera_look_at            
    }
     #declare alt_eje     = 2 ;
     #declare long_paso   = 2 ;
     #declare alt_max_pie = 1 ;
     #declare robot_step  = i ;
    
    #declare disparo=false; 
    #if(clock>14.25 & clock <16.76)
       #if(mod(clock,1)>.33 & mod(clock,1)<.66)
     #declare disparo=true; #end
     #end
    
    
    
    object{robot(i,<0,30-(15*j),-10>,0,0,disparo) translate <clock*2 -2, 0,0>}
    #break  
     
        
#end


#declare effect_type       = "Sun"
#declare effect_location   = <5000,2200,0>;
#declare effect_brightness = 1.5 ;
  
#if (sol & calidad)
   #declare options_only      = true;
   #include "lens.inc"
   #undef effect_type
   #declare glow_type         = 2;
   #declare options_only      = false;
   #include "lnsefcts.inc"
#end   

#if (cielo & calidad)
   sky_sphere {
   pigment {
      gradient y
      pigment_map {
         [0 rgb <.957,0.497,0>*1.5]         
         [0.8 rgb <.4, .6, .8>]
      }
   }
   }
   
   object{cloud1}
   object{cloud2}
   object{cloud3}
   #else
   background{color rgb 1}
              
#end

#if (!calidad)
#declare gradiente_x=texture{
        pigment{gradient x 

                color_map {
                [0 rgbt <0,1,0,0>]
                [0.1 rgbt <0,1,0,0>]
                [0.1 rgbt<0,0,0,0>]
                [1 rgbt <0,0,0,0>]
                }
            }
        finish{ambient 0.7}
}
#declare gradiente_z=texture{
        pigment{gradient z

                color_map {
                [0 rgbt <0,1,0,0>]
                [0.1 rgbt <0,1,0,0>]
                [0.1 rgbt<0,0,0,1>]
                [1 rgbt <0,0,0,1>]
                }
            }
        finish{ambient 0.7}
        }    
 
#end
   
#if (colinas)        
   height_field { 
   tga "test2.tga"
   #if (calidad)   smooth #end
   translate <-.15,-.5,-.15>
   
   rotate <0,180,0>
     
//   water_level 16/256
   scale <12000,1000,12000> 
   #if (calidad)
      texture{ 
         pigment {color <.88, .74, .65>}
         normal {crackle 1 turbulence .8}
      }
   finish{ambient .3}
      
   #else
      texture{gradiente_x}
      texture{gradiente_z}
   #end
  
   translate <-200, 0 ,-200>
   translate <-90,0,-180 >
   rotate <0,-90,0>
   }
#end  
  
#if (niebla & calidad)   
  
   fog {
      fog_type 2
      color rgbt <0.7,0.7, 0.7, 0.25>
      distance 5
      fog_offset 0
      fog_alt 1
      turbulence 0.25
      omega .2
      lambda .9
      octaves 3
   }
#end

#if (suelo)   
   
   plane { y,0 
      #if (calidad)
          texture{
        pigment {color <.85, .7, .6>
        }
        finish{ ambient .5}
        normal{
        crackle 1
        turbulence 0.8
        //scale <1,0.1,1>
        }
      }        
   #else
      texture{gradiente_x}
      texture{gradiente_z}
   #end

    translate <-200,0,-200>}
#end

#declare light_color = <0.8, 0.5, 0.5>;

light_source { effect_location colour light_color }             //Luz principal. La que va con el sol
//light_source { effect_location colour light_color/3 shadowless} //Luces de relleno, para que se note un poco
//light_source { camera_location colour White/10 shadowless}      //las normales del terreno
           