// POV-Ray Include File - Units
// created 19 October 1999 Mark Wagner
//
// Assorted units of measurement
//
// Note: This file can be used for units based on 1 
//  centimeter = 1 pov unit, or it can be based on any
//  other equivalence by defining the variable "cm" to
//  be whatever number of pov units you want before
//  including this file, eg.
//
//		#declare cm = .01;
//		#include "units.inc"
//
//  would set all the units in this file to be
//  proportional to a centimeter 0.01 pov units long.
//
// Note: some names for units are used by more than one
//  civilization.  When this occurrs, the unit name is 
//  preceeded by the civilization name, eg. Greek_Amma
//
// If you know of any units I don't have here, send
//  them with a conversion to at least one of the
//  units listed here to me at rengaw03@geocities.com
//
//=====================================================
//             Variables
//=====================================================

#ifndef(cm)
	// Make basic unit centimeters if not otherwise instructed
	#declare cm = 1;
#end

// Metric units
#declare mm = 0.1*cm;
#declare MM = mm;
#declare CM = cm;
#declare meter = 100*cm;
#declare Meter = meter;
#declare meters = meter;
#declare Meters = meter;
#declare km = 1000*Meters;
#declare Km = km;
#declare KM = km;
#declare Kilometer = km;
#declare Kilometers = km;

#declare Angstrom = 1e-8*cm;
#declare Decimeter = 10*cm;
#declare Dekameter = 10*meter;
#declare Hectometer = 100*meter;
#declare Gigameter = 10e9*meter;
#declare Micron = .0001*cm;

// Common English units
#declare in = 2.54*cm;
#declare In = in;
#declare inch = in;
#declare Inch = in;
#declare inches = in;
#declare Inches = in;
#declare Foot = 12*Inches;
#declare foot = Foot;
#declare Feet = Foot;
#declare feet = Foot;
#declare Yard = 3*Feet;
#declare yard = Yard;
#declare Yards = Yard;
#declare yards = yard;
#declare Yd = Yard;
#declare yd = Yard;
#declare Mile = 5280*Feet;
#declare mile = Mile;
#declare miles = Mile;
#declare Miles = Mile;

// Other English units
#declare Cable = 185.37*Meter;
#declare US_Chain = 66*Feet;
#declare Ramden_Chain = 100*Feet;
#declare Fathom = 6*Feet;
#declare US_Survey_Feet = 1.000002*Feet;
#declare Furlong = 660*Feet;
#declare Hand = 4*Inches;
#declare Mils = .001*Inches;
#declare League = 15840*Feet;
#declare Nautical_League = 18228*Feet;
#declare British_Nautical_League = 18240*Feet;
#declare Gunters_Link = 0.01*US_Chain;
#declare Ramden_Link = 1*Feet;
#declare British_Nautical_Mile = 6080*Feet;
#declare Nautical_Miles = 1852*Meter;
#declare Nails = 2.25*Inches;
#declare Pace = 2.5*Feet;
#declare Points = .013837*Inches;
#declare Pica = 12*Points;
#declare Rods = 198*Inches;
#declare British_Rope = 20*Feet;
#declare Old_English_Span = 6*Inches;
#declare Spans = 9*Inches;
#declare Poles = 5.5*Yards;

// Ancient Greek units
#declare Digit = 1.84*cm;
#declare Origua = 100*Digit;
#declare Greek_Amma = 10*Origua; 
#declare Stadion = 10*Greek_Amma;

// Ancient Roman units
#declare Digitus = 1.84*cm;
#declare Palmus = 4*Digitus;
#declare Roman_Amma = 4*Digitus;
#declare Pes = 4*Palmus;
#declare Passus = 5*Pes;
#declare Stadium = 125*Passus;
#declare Millar = 8*Stadium;

//Various cubits
#declare Biblical_Cubit      = 21.8*Inches;
#declare Egyptian_Cubit      = 20.6*Inches;
#declare Babylonian_Cubit    = 20.9*Inches;
#declare Assyrian_Cubit      = 21.6*Inches;
#declare English_Druid_Cubit = 20.4*Inches;
#declare Jerusalem_Cubit     = 20.6*Inches;
#declare Arabic_Cubit        = 21.3*Inches;
#declare Aztec_Cubit         = 20.7*Inches;
#declare Chinese_Cubit       = 20.9*Inches;
#declare Greek_Cubit         = 18.2*Inches;
#declare English_Cubit       = 18.0*Inches;

//Various feet
#declare Athenian_Feet    = 12.44*Inches;
#declare Aegina_Feet      = 12.36*Inches;
#declare Miletus_Feet     = 12.52*Inches;
#declare Olympia_Feet     = 12.64*Inches;
#declare Etruria_Feet     = 12.44*Inches;
#declare Roman_Feet       = 11.66*Inches;
#declare Old_English_Feet = 13.19*Inches;
#declare Old_French_Feet  = 12.79*Inches;
#declare Old_Russian_Feet = 13.17*Inches;

// Other units
#declare Archin = 1*Meter;
#declare Astronomical_Unit = 1.496e8*Kilometers;
#declare AU = Astronomical_Unit;
#declare Light_Year = 63241.07*AU;
#declare Parsec = 3.08568e16*Meters;
#declare Cloth_Ell = 45*Inches;
#declare Li = Miles/3;
#declare Pu = 70.5*Inches;
#declare Tu = 100.142*Miles;
#declare Liniya = .1*Inches;
#declare Verst = 3500*Feet;
#declare Miglio = .925*Miles;
#declare Milion = 1478*Meters;
#declare Ri = 2.44*Miles;
#declare Shaku = .378*Meters;
#declare Toise = 1.949*Meters;
#declare Vara = 2.6816*Feet;
#declare Zoll = 3*cm;
